;------------------------------------------------------------
; Sample assembly file.
;------------------------------------------------------------

;---------------------------------------------------------------------------
;   Font is saved in the filenamed DEMO.PAS.  To use the font, you must call
;   interrupt 10h, function 11h, sub-function 10h to load up the font.
;   
;   The following are the parameter needed to call the function:
;  
;                 AX  =  1110H      (ah = 11H, al = 10H)
;		  BH  =  bytes per character 
;		  BL  =  block to load to.  (use 0)
;		  CX  =  number of character defined by table
;		  DX  =  starting character value
;		  ES  =  segment of the table (use Seg())
;		  BP  =  offset of the table (use Ofs())
;
;   Notice:  You should always upload the character immediately after set
;            the Video mode.  Also you must make sure that page 0 is active.
;	    If it is not call immediately after the video mode set, some
;	    side effects may occur.  I had experience some palette errors
;	    my self, when I call this function with out changing video 
;	    mode.  This doesn't happen all the time, however.  But be on 
;	    the safe side is the best.   
;   
;   FONT MANIA will supply you with the height of the font.  It is defined
;   by your label name with "_POINTS" added at the end of the string.  For
;   example, if your label reference is call DEMO, then DEMO_POINTS will 
;   represent the byte-per-character of the font (the height of the font).
;   
;   Set the CX to 256 if you want to upload the whole font.   If you want to 
;   only upload part of font.  Set CX to whatever number of the character 
;   you want to upload, and set DX to the first character you want to upload.
;   
;   For example, suppose you want to upload the character 65 to 88, 
;   ('A' to 'Z') and the label reference is DEMO.  Here are the parameter
;   needed:
;   
;		 AX  =  1110h
;		 BH  =  DEMO_POINTS
;		 BL  =  0
;		 CX  =  24               ( 24 characters to load )
;		 DX  =  65               ( first character to load )
;		 ES  =  SEGMENT DEMO
;		 BP  =  OFFSET DEMO
;		 
;   See below for examples of how to set the registers. 
;----------------------------------------------------------------------------		 

code	segment	para
	org	100h

start:
	mov	ax, 3			; set the SCREEN MODE first
	int	10h

	mov	ax, 1110h		; use USER's FONT upload function
	mov	bh, DEMO_POINTS		; get the bytes per character in bh
					; FONT MANIA will provided the font
					; height.  LABEL_POINTS.
	xor	bl, bl			; load to character block 0
	mov	cx, 256			; load all 256 character
	xor	dx, dx			; begin with character 0 (ascii NULL)
	mov	bp, offset DEMO		; address of the font.  LABEL
	int	10h			; upload it
	
	int	20h			; terminate the program

include	demo.asm			; the font data.

code	ends

	end	start			; end of file / starting point