/*
             Rock v1.3 - Fidonet mailer for point systems
                 Copyright (C) 1995  Jean-Marc Xiume'
         This software is distributed under the terms of the
    GNU General Public License. Read "license.doc" for more details.

****** Concatenate the *.FLO files of the boss' different nets
                    in a single file named with the main address ******
*/

options results
options failat 99

Parse upper arg od .


if ~open('cfg',"rock:rock.cfg",'R') then exit 1

i=0
j=0

do while ~eof('cfg')
  L=Upper(strip(ReadLn('cfg'),'B'))
  if left(L,7) ~= "SET NET" then iterate

  j=j+1
  parse var L "SET NET" i " " z.i ":" n.i "/" f.i "." p.i .

  if i ~= j then do
    say "* Error in rock.cfg (NETS) : net numbers are not consecutive"
    exit 2
  end
end

v=close('cfg')

if i=0 then do
  say "* No nets found in rock.cfg (NETS)"
  exit 3
end
if i=1 then exit 0

j=2
mflo = od||z.1'.'n.1'.'f.1'.'p.1'.FLO'

do while j <= i
  cflo = od||z.j'.'n.j'.'f.j'.'p.j'.FLO'
  if exists(cflo) then do
    address COMMAND "type "cflo ">>" mflo
    address COMMAND "delete >NIL: "cflo
  end
  j=j+1
end

exit 0
