/*
**  By: Jim Nutt
*/

#ifndef VIO_H
#define VIO_H

/* initialization and termination functions */

int   VIOopen(void);
void  VIOclose(void);

/* scrolling functions */

void  VIOscrollright(int x1, int y1, int x2, int y2, int count);
void  VIOscrollleft(int x1, int y1, int x2, int y2, int count);
void  VIOscrollup(int x1, int y1, int x2, int y2, int count);
void  VIOscrolldown(int x1, int y1, int x2, int y2, int count);

/* screen clear */

void  VIOclear(int x1, int y1, int x2, int y2);

/* write to screen */

void  VIOputc(const char c);
void  VIOputs(const char far * s);
void  VIOputr(int x, int y, int w, int h, unsigned short far * b);

/* read from screen */

int   VIOgetca(const int x, const int y);
int far * VIOgetra(int x1, int y1, int x2, int y2, unsigned short far * b);

/* set colors */

void  VIOsetfore(const int c);
void  VIOsetback(const int c);

/* get current color settings */

int   VIOgetfore(void);
int   VIOgetback(void);

/* set the write cursor */

void  VIOgotoxy(int x, int y);

/* update the screen and visible cursor */

void  VIOupdate(void);

/* get the current write cursor position */

int   VIOwherex(void);
int   VIOwherey(void);

/* get screen information */

unsigned int   VIOsegment(void);

int   VIOcolumns(void);
int   VIOrows(void);
int   VIOmode(void);
int   VIOheight(void);

/* set segment information */

void  VIOsetSegment(unsigned int s);
void  VIOsetRows(int r);
void  VIOsetCols(int c);

/* get BIOS cursor location */

void  VIOcursor(int  * x, int  * y, int  * shape);


#endif
