/* userlist - look up name in fido userlist */
/* written by Paul Edwards */
/* released to the public domain */
/* note - although the fido userlist consists of fixed length
   records sorted alphabetically, I am doing a sequential
   search for simplicity */
/* The fido userlist contains records like the following:
   Bloggs, Joe      3:666/666
   */   

#include "msged.h"

ADDRESS lookup(char *name, char *fn)
{
    FILE *fp;
    ADDRESS tmpAddr;
    char buf[200];
    char revName[200];
    int lenRev;
    char *p;
    
    tmpAddr = CurArea.addr;
    if (tmpAddr.domain != NULL)
    {
        tmpAddr.domain = strdup(tmpAddr.domain);
    }
    tmpAddr.notfound = 1;
    fp = fopen(fn, "r");
    if (fp == NULL)
    {
        return (tmpAddr);
    }
    makeReverse(revName, name);
    strlwr(revName);
    lenRev = strlen(revName);
    while (fgets(buf, sizeof buf, fp) != NULL)
    {
        strlwr(buf);
        if (strncmp(buf, revName, lenRev) == 0)
        {
            p = buf + strlen(buf) - 1;
            while ((p >= buf) && (isspace(*p)))
            {
                *p = '\0';
                p--;
            }
            while ((p >= buf) && (!isspace(*p)))
            {
                p--;
            }
            if ((p >= buf) && (isspace(*p)))
            {
                p++;
            }
            if (tmpAddr.domain != NULL) 
            {
                free(tmpAddr.domain);
            }
            fclose(fp);
            return (parsenode(p));
        }
    }
    fclose(fp);
    return (tmpAddr);
}

void makeReverse(char *revName, char *name)
{
    char *lastSpace;
    int len;
    
    lastSpace = strrchr(name, ' ');
    if (lastSpace == NULL)
    {
        strcpy(revName, name);
        return;
    }
    len = strlen(lastSpace + 1);
    memcpy(revName, lastSpace + 1, len);
    memcpy(revName + len, ", ", 2);
    memcpy(revName + len + 2, name, (size_t)(lastSpace - name));
    *(revName + len + 2 + (size_t)(lastSpace - name)) = '\0';
    return;
}
