/* msged.h
**
** released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
** Changes released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
** Main header file for all Msgedsq src files.
*/

#define  NOSPELL         /* no spelling checker support */
#define  MSGEDSQ         /* for winsys.h byte & ulong defs */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <io.h>
#include <time.h>

#include "mcompile.h"    /* compiler specifics */
#include "nedit.h"       /* line definitions */
#include "pascal.h"      /* hides the oldstyle far/near/pascal */
#include "dirute.h"

#define ALPHA 0

#if ALPHA
#define CLOSED " alpha"
#define PIDALPHA ".a"
#else
#define CLOSED ""
#define PIDALPHA ""
#endif

/* pid version is not allowed to have trailing 0's, but I like 
   them on the tearline */

#define PIDVER "3.05"
#define VERSION "3.05"

#ifndef __OS2__
#   define PROG         "Msgedsq"
#else
#   define PROG         "Msgedsq/2"
#endif

#define NO              0
#define YES             1
#define FAIL            0
#define OK              1
#define HIDE            2
#define RIGHT           0
#define LEFT            1
#define SAVE            1
#define ABORT           -1

#define GDOMAINS        0x01         /* gate domains */
#define GZONES          0x02         /* gate zones */
#define BOTH            0x04         /* gate both */

#define FIDO            0x00
#define SQUISH          0x01 

#define USENET          0x01
#define FIDONET         0x02

#define PATHLEN         64
#define BLOCKLEN        255
#define BUFLEN          4096

#define MAXUSERS        11

#define MT_QUO           0x0001     /* msg has a quote */
#define MT_REP           0x0002     /* msg is a reply (no quote) */
#define MT_ARC           0x0004     /* check for dest. area */
#define MT_FOL           0x0008     /* insert followup template */
#define MT_NEW           0x0010     /* msg is new (no to:) */
#define MT_FOR           0x0020     /* forwarded message */
#define MT_RED           0x0040     /* redirected message */

#define WR_HEADER       0x0001      /* write header only */
#define WR_ALL          0x0002      /* write all msg */
#define RD_HEADER       0x0004      /* read header only */
#define RD_ALL          0x0008      /* read all msg */

#define ERR_OPEN_MSG    -1          /* error opening msg */
#define ERR_CLOSE_MSG   -2          /* error closing message */
#define ERR_OPEN_AREA   -3          /* error opening area */
#define ERR_CLOSE_AREA  -4          /* error closing area */
#define ERR_NO_AREA     -5          /* no area currently open! */

/* useful time-saving macros */

#define ST              string_vars
#define SW              switch_vars
#define thisnode        alias[0]
#define CurArea         arealist[SW->area]

/* structures and typedefs */

/*
**  Attributes used & recognized by Msgedsq.
**
*/

struct _attributes
{
    unsigned int private:1;    /* private message flag     */
    unsigned int crash:1;      /* crash mail               */
    unsigned int recvd:1;      /* received by addressee    */
    unsigned int sent:1;       /* message sent             */
    unsigned int attached:1;   /* file attached            */
    unsigned int forward:1;    /* message in transit       */
    unsigned int orphan:1;     /* unknown destination      */
    unsigned int killsent:1;   /* kill after sending       */
    unsigned int local:1;      /* local message            */
    unsigned int hold:1;       /* hold for pickup          */
    unsigned int direct:1;     /* do no gating on this msg */
    unsigned int freq:1;       /* file request             */
    unsigned int rreq:1;       /* return receipt requested */
    unsigned int rcpt:1;       /* return receipt           */
    unsigned int areq:1;       /* audit trail request       */
    unsigned int ureq:1;       /* update file request       */
};



/*
**  Structure defining a 5D fidonet address, or
**  an internet address (stored in the domain).
*/

typedef struct _address
{
    uint  zone;
    uint  net;
    uint  node;
    uint  point;
    char *domain;
    uint  notfound:1;
    uint  fidonet:1;
    uint  internet:1;
    uint  bangpath:1;
} ADDRESS;


/*
**  Structure defining an alias for header
**  and cc: entry.
*/

typedef struct _alias
{
    int   attr;                 /* wuz an attribute specified? */
    char *alias;                /* the alias */
    char *name;                 /* the real name */
    char *subj;                 /* the subject */
    struct _attributes attrib;  /* the attributes (if used) */
    ADDRESS addr;               /* the address (if used) */
} ALIAS;


/*
**  Structure defining a V7 nodelist.
*/

typedef struct _domain_list
{
    char *name;                    /* full domain name eg. fidonet.org */
    char *base_name;               /* base name of nodelist ie. nodex */
    char *sysop;                   /* sysop lookup filename eg. sysop.ndx */
} D_LIST;


/*
** Defines a user plus the corresponding useroffset and
** lastread values.  The current values are copied to
** the global equivalents (to avoid extra work).
*/

typedef struct _user
{
    char  *name;
    char  *lastread;
    ulong  offset;
} USER;


/*
** Defines an area group.  This is used to determine what username
** and template to use in an area.  Only used on startup.
*/

typedef struct _group
{
    char *search;
    uint  username;
    uint  template;
} GROUP;


/*
**  The internal area structure.  Contains
**  all info relevant for an area.
*/

typedef struct _area
{
    int      status;       /* status of the area, 0 = closed, 1 = open */
    ADDRESS  addr;         /* the address to use in this message */
    char    *description;  /* what the user calls the area */
    char    *tag;          /* what confmail calls it! */
    char    *path;         /* where the area is on disk */

    uint     local:1;      /* local message area */
    uint     netmail:1;    /* netmail message area*/
    uint     echomail:1;   /* echomail area */
    uint     news:1;       /* usenet news area */
    uint     uucp:1;       /* usenet mail area */
    uint     new:1;        /* a message has been entered */
    uint     priv:1;       /* default privileged */
    uint     hold:1;       /* default hold */
    uint     direct:1;     /* default direct */
    uint     crash:1;      /* default crash */
    uint     killsent:1;   /* default crash */

    uint     template;     /* index into template array */
    uint     username;     /* index into username array */

    uint     msgtype;      /* the message type */
    ulong    first;        /* first message in the area ?? */
    ulong    last;         /* last message in the area */
    ulong    current;      /* current message in the area */
    ulong    messages;     /* how many messages in the area */
    ulong    lastread;     /* the highest message read */
} AREA;



/*
**  The internal message structure.  Built
**  to reflect both squish (32bit) and other
**  msgbase structures.
*/

typedef struct _msg
{
    ulong    msgnum;            /* message number (UMSGID) */
    char    *reply;             /* id of message this is a reply to */
    char    *msgid;             /* this messages msgid */
    char    *isfrom;            /* who from */
    char    *isto;              /* who to */
    char    *subj;              /* message subject */

    uint     new:1;             /* new message ? */
    uint     change:1;          /* message been changed ? */
    uint     scanned:1;         /* msg been scanned ? */
    uint     newrcvd:1;         /* msg just received? */
    uint     soteot:1;          /* msg sot/eot protected? */

    time_t   timestamp;         /* creation date, */
    time_t   time_arvd;         /* time message arrived */

    ulong    replyto;           /* thread to previous msg */
    ulong    replies[10];       /* thread to next msg(s) */

    struct _attributes attrib;  /* message attribute */
    int      times_read;        /* times msg been read */
    int      cost;              /* cost of message */

    ADDRESS  to;                /* destination address of message */
    ADDRESS  from;              /* origin address of message */
    LINE    *text;              /* the message buffer */
} msg;


/*
**  A command/label assignment structure (for the keyboard).
**
*/

struct _command
    {
    char *label;
    void ( *action)(void);
    };


/*
**  Handle for msgbase access functions.
**
*/

typedef struct _msghandle
{
    msg  *(*MsgReadHeader)(ulong n, int type);
    char *(*MsgReadText)(ulong n);
    int   (*MsgWriteHeader)(msg *m, int type);
    int   (*MsgWriteText)(char *text, ulong n, unsigned long mlen);
    int   (*MsgDelete)(ulong n);
    int   (*AreaSetLast)(AREA a);
    long  (*MsgAreaOpen)(AREA *a);
    int   (*MsgAreaClose)(void);
    int   (*MsgClose)(void);
    unsigned long  (*UidToMsgn)(ulong n);
    unsigned long  (*MsgnToUid)(ulong n);
} msghandle;


/*
**  These are the system strings, for access across
**  the system.
*/

struct _sv
{
   char *username,                  /* who is you */
        *quotestr,                  /* how to prefix a quote */
        *fidolist,                  /* nodelist user list */
        *userlist,                  /* personal user list */
        *origin,                    /* origin line */
        *outfile,                   /* default export filename */
        *home,                      /* home directory */
        *lastread,                  /* name of the lastread file */
        *cfgfile,                   /* name of the config file */
        *confmail,                  /* confmail log file name */
        *template,                  /* template file */
        *nodepath,                  /* path to current nodelist */
        *nodebase,                  /* base (current) nodelist name */
        *sysop,
#ifndef __OS2__
        *swap_path,                 /* swap path... */
#endif
        *helpfile,                  /* helpfile name */
        *uucpgate,                  /* the UUCP gate name to send to */
        *comspec,                   /* file spec of command processor */
        *editorName;                /* name of external editor */
};


/*
**  These are the system switches, for access
**  across the system.
*/

struct _swv
{
    ulong useroffset;             /* offset into lastread file */
    int area,                     /* current area number */
        areas,                    /* how many message areas */
        aliascount,               /* how many aliases do you have? */
        otheraliases,             /* how many "other" aliases? */
        numtemplates,             /* how many templates in use ? */
        domains,                  /* how many domains listed */
        rm,                       /* the right margin */
        qm,                       /* the quote margin */
        pointnet,                 /* private net number of point */
        tabsize,                  /* how many spaces for a tab */
        nodelists,                /* number of nodelists */
        rquote,                   /* dfns for the reply funcs; quote */
        rotharea,                 /* reply other area */
        rfollow,                  /* reply followup */
        rextra,                   /* reply extra - user definable */
        gate,                     /* zone/domain gate messages? */
        override,                 /* override the area origin line */
        scanned,                  /* areas have been scanned */
        redraw,                   /* redraw screen header? */
        msgids,                   /* add msgid lines */
        opusdate,                 /* put in the opus time stamp */
        stripnotes,               /* strip hidden lines */
        shownotes,                /* show hidden lines */
        seenbys,                  /* show seenby lines */
        tearline,                 /* show a tearline/origin? */
        confirmations,            /* confirm deletes, aborts? */
        datearrived,              /* show the date msg arrived? */
        showaddr,                 /* shows curr address on screen */
        use_lastr,                /* whether to use lastread/current */
        qquote,                   /* quote quotes? */
        savecc,                   /* save cc original copy? */
        rawcc,                    /* save the raw cc msg? */
        chopquote,                /* chop off the end of quoted msgs? */
        hardquote,                /* don't reformat quoted text? */
        showcr,                   /* show CRs ? */
        showeol,                  /* show eol? */
        showrealmsgn,             /* show real msg#s in <alt><l> */
        usemouse,                 /* use the mouse? */
        tabexpand,                /* expand tabs? */
        editcronly,               /* show CRs in editor only */
        usepid,                   /* use a pidinstead of a tearline */
        soteot;                   /* use SOT/EOT */
};


#ifndef INCL_MAIN

extern struct _swv *switch_vars;     /* array of switches */
extern struct _sv  *string_vars;     /* array of strings */
extern msghandle    msgdo[];         /* msgbase functions */
extern ADDRESS     *domain_list;     /* list of ^aDOMAIN lookups */
extern ADDRESS     *alias;           /* list of AKA's */
extern ADDRESS      uucp_gate;       /* closest UUCP gate */
extern D_LIST      *node_lists;      /* list of v7 nodelists */
extern AREA        *arealist;        /* list of areas for system */
extern ALIAS       *aliaslist;       /* list of alias lookups */
extern USER         user_list[11];   /* list of system users */
extern char       **templates;       /* list of templates */
extern msg         *message;         /* current message */
extern uint        *macros[41];      /* macros */
extern int          maxy;            /* max y pos, 1 origin */
extern int          maxx;            /* max x pos, 1 origin */
extern int          cur_start;       /* these are ega/vga default */
extern int          cur_end;         /* cursor sizes */
extern int          rot13;           /* rot13 this message? */

#endif /* #ifndef INCL_MAIN (any files other than init.c) */

#include "mprotos.h"                       /* all the various prototypes */

/* various and sundry macros */

#define release(s)                {if (s != NULL) free(s); s = NULL;}
#define unused(x)                 ((void)(x))

#define MsgReadHeader(n,type)     (msgdo[CurArea.msgtype].MsgReadHeader(n,type))
#define MsgReadText(n)            (msgdo[CurArea.msgtype].MsgReadText(n))
#define MsgWriteHeader(m,type)    (msgdo[CurArea.msgtype].MsgWriteHeader(m,type))
#define MsgWriteText(text,n,mlen) (msgdo[CurArea.msgtype].MsgWriteText(text,n,mlen))
#define MsgDelete(n)              (msgdo[CurArea.msgtype].MsgDelete(n))
#define AreaSetLast(a)            (msgdo[CurArea.msgtype].AreaSetLast(a))
#define MsgAreaOpen(a)            (msgdo[CurArea.msgtype].MsgAreaOpen(a))
#define MsgAreaClose()            (msgdo[CurArea.msgtype].MsgAreaClose())
#define MsgClose()                (msgdo[CurArea.msgtype].MsgClose())
#define UidToMsgn(n)              (msgdo[CurArea.msgtype].UidToMsgn(n))
#define MsgnToUid(n)              (msgdo[CurArea.msgtype].MsgnToUid(n))

#define DOROT13(c) ((rot13==0)?(c):(rot13==1)?(!isalpha((c)))?(c):((((c) >= (char) 'A') && \
                   ((c) <= (char) 'M')) || (((c) >= (char) 'a') && ((c) <= (char) 'm')))?((c) + (char) 0xd)\
                   :((((c) >= (char) 'N') && ((c) <= (char) 'Z')) || (((c) >= (char) 'n') && ((c) <= (char) 'z')))?\
                   ((c) - (char) 0xd):(c):((c) >= (char) '!') ? ((((c) + (char) 47) > (char) '~') ? ((c) - (char) 47) :\
                   ((c) + (char) 47)) : (c))

msg *KillMsg(msg *m);

/*--- end --- */
