/*
 * released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
*/

#include <stdlib.h>
#include <errno.h>

#include "dirute.h"

#ifdef __OS2__
#define INCL_DOSPROCESS
#include <os2.h>

#include <string.h>
#include <errno.h>

union {
    FDATE a;
    unsigned int b;
} dc;

union {
    FTIME a;
    unsigned int b;
} tc;

static FILEFINDBUF3 InfoBuf;

HDIR    hDir;
ULONG    cSearch;
ULONG    usAttrib;

#define FILENAMELEN 255

int dir_findfirst(char * filename, int attribute, struct _dta * dta)
{
    hDir     = 0x0001;
    usAttrib = attribute;
    cSearch  = 1;

    if (DosFindFirst( filename
                     , &hDir
                     , usAttrib
                     , &InfoBuf
                     , sizeof InfoBuf
                     , &cSearch
                     , FIL_STANDARD) != 0)
    {
        DosFindClose( hDir );
        errno = ENOENT;
        return (-1);
    } else {
        dta->attrib     = (char)InfoBuf.attrFile;           /**OS2**/
        dta->size       = InfoBuf.cbFile;
        dc.a            = InfoBuf.fdateLastWrite;
        tc.a            = InfoBuf.ftimeLastWrite;
        dta->wr_time    = tc.b;
        dta->wr_date    = dc.b;
        strcpy( dta->name, InfoBuf.achName);
        errno = 0;
        return (0);
    }
}

int dir_findnext(struct _dta * dta)
{

    if ((DosFindNext( hDir
                    , &InfoBuf
                    , (USHORT)(FILENAMELEN + 23)
                    , &cSearch)
                    ) || (cSearch != 1))
    {
        DosFindClose( hDir );
        errno = ENOENT;
        return (-1);
    } else {
        dta->attrib    = (char)InfoBuf.attrFile;           /**OS2**/
        dta->size      = InfoBuf.cbFile;
        dc.a            = InfoBuf.fdateLastWrite;
        tc.a            = InfoBuf.ftimeLastWrite;
        dta->wr_time    = tc.b;
        dta->wr_date    = dc.b;
        strcpy(  dta->name, InfoBuf.achName);
        errno = 0;
        return (0);
    }
}

#else /* of __OS2__ */
#ifdef __TURBOC__

#include <dos.h>
#include <dir.h>
#include <string.h>

static struct ffblk ffblk;

int dir_findfirst(char * filename, int attribute, struct _dta * dta)
{
    int done;

    done = findfirst(filename, &ffblk, attribute);

    if (!done)
    {
        strcpy(dta->name, ffblk.ff_name);
        dta->wr_time = ffblk.ff_fdate;
        dta->wr_date = ffblk.ff_ftime;
        dta->size    = ffblk.ff_fsize;
        dta->attrib  = ffblk.ff_attrib;
        return 0;
    }
    return -1;
}

int dir_findnext(struct _dta * dta)
{
    if (!findnext(&ffblk))
    {
        strcpy(dta->name, ffblk.ff_name);
        dta->wr_time = ffblk.ff_fdate;
        dta->wr_date = ffblk.ff_ftime;
        dta->size    = ffblk.ff_fsize;
        dta->attrib  = ffblk.ff_attrib;
        return 0;
    }
    return -1;
}

#else  /* MSC version of these routines */

#include <dos.h>

struct _find_t ffblk;

int dir_findfirst(char * filename, int attribute, struct _dta * dta)
{
    int done;

    done = _dos_findfirst(filename, attribute, &ffblk);

    if (!done)
    {
        strcpy(dta->name, ffblk.name);
        dta->wr_time = ffblk.wr_date;
        dta->wr_date = ffblk.wr_time;
        dta->size    = ffblk.size;
        dta->attrib  = ffblk.attrib;
        return 0;
    }
    return -1;
}

int dir_findnext(struct _dta * dta)
{
    if (!_dos_findnext(&ffblk))
    {
        strcpy(dta->name, ffblk.name);
        dta->wr_time = ffblk.wr_date;
        dta->wr_date = ffblk.wr_time;
        dta->size    = ffblk.size;
        dta->attrib  = ffblk.attrib;
        return 0;
    }
    return -1;
}

#endif
#endif /* of __OS2__ */
