/* areas.c
**
**  Released into the public domain by John Dennis, 1994.
**  written by jim nutt, John Dennis
**
**  This file contains the routines to select one of the areas
**  specified in the config files.  It pops up a list with all the
**  areas and lets the user chose.
**
*/

#include "msged.h"
#include "main.h"
#include "menu.h"

extern int msgederr;

void  areascan(void);

char **alist;

void BuildList(void)
{
    AREA  *a;
    char   line[50];
    int    i;

    alist = calloc(SW->areas + 2, sizeof(char *));

    for (i = 0; i < SW->areas; i++)
    {
        a = arealist + i;

        if (a->messages)
        {
            sprintf(line, "%-30.30s %6ld %6ld",
                a->description,
                a->messages - a->current, /* mod 1995-04-25 PE */
/*    a->messages - ((a->msgtype == FIDO) ? a->lastread : a->current), */
                a->messages);
        }
        else
            sprintf(line, "%-30.30s %s",a->description, SW->scanned ? "empty" : "unscanned");

        alist[i] = strdup(line);
    }
    alist[i] = NULL;
}

int  selectarea(void)
{
    WND   *hCurr, *hWnd;
    int    ret;
    int    wid, dep, i;

    msgederr = 0;
    wid      = 50;
    dep      = min(maxy - 6, SW->areas + 2);
    
    hCurr = Wtop();
    if ((hWnd = WPopUp(wid, dep, SBDR|SHADOW, cm[MN_BTXT], cm[MN_NTXT])) == NULL)
        return SW->area;

    WTitle(" Select Message Area ", cm[MN_BTXT]);
    WWriteStr(5,  0, cm[MN_BTXT], "Area Description");
    WWriteStr(34, 0, cm[MN_BTXT], "Unread");
    WWriteStr(42, 0, cm[MN_BTXT], "Total");
    BuildList();

    ret = SelBox(alist, 1, dep - 2, wid - 1, SW->area, hWnd->wid, cm[MN_STXT], cm[MN_NTXT], 2);

    for (i = 0; i < SW->areas; i++)
        free(alist[i]);

    free(alist);

    if (ret < 0)
        msgederr = 1;

    WClose(hWnd);
    WCurr(hCurr);

    return ((ret < 0) ? SW->area : ret);
}

/* end of file */
