(* NOTE: LGPL is NOT Pascal! LGPL integers are 4-bytes, equivelant to what
         Borland Pascal calls a "longint"
*)

const
 nbspec=8;
 numbasestartspec=5;
 numueqp=6;
 numudev=18;
 numdev=350;
 numobj=2048;
 numst=50;
 numprod=3;
 numbase=75;
 numspell=5;
 numbforsale=8;
 numterrain=50;
 hinc=45;

 maxusers=255; (* not fully implemented *)

 maxmapx=125;
 maxmapy=125;
 maxmapz=1;
 maxgenobj=255;
 maxtover=64;
 maxquest=32;

 numca=100;
 maxtav=50;
 numtcode=27;
 maxinclude=10;
 maxtrestrict=4;

 maxpurparts=10;
 numpurparts=9;
 kirkpart=1;
 xebocpart=2;
 drakpart=3;
 xebpart=4;
 tranliuspart=5;
 vayderrpart=6;
 snowguypart=7;
 lokipart=8;
 serpinepart=9;

 ammomax=20;
 vortexbattmax=9999;

 maxteams=10;
 maxteamplayers=5;

 maxmon=300;

 maxnab=15;

 maxpmask=10;
const
 terrain_impass  = 0;
 terrain_pass    = 1;
 terrain_water   = 2;
 terrain_lava    = 3;

 store_none      = 0;
 store_weap      = 1;
 store_armor     = 2;
 store_misc      = 3;
 store_ammo      = 4;
 store_basereact = 5;
 store_basemisc  = 6;
 store_basedef   = 7;
 store_basemoat  = 8;
 store_baseweap  = 9;
 store_computer  = 10;
 store_weaplr    = 11;
 store_troysteak = 12;
 store_troydisk  = 13;
 store_gsrz      = 14;
 store_basefact  = 15;
 store_EEEE	 = 16;
 store_town2	 = 17;
 store_town3     = 18;
 store_town4     = 19;
 store_town5     = 20;
 store_town6	 = 21;
 store_town7     = 22;
 store_town8	 = 23;
 store_town9	 = 24;
 store_kill	 = 25;
 store_basepack  = 26;
 store_basescav  = 27;
 store_baseene	 = 28;
 store_basemed   = 29;
 store_acmefort  = 30;
 store_acmeweap  = 31;
 store_acmeROM   = 32;

 devapp_radio    = 0;
 devapp_medkit	 = 1;
 devapp_weapon   = 2;
 devapp_rweapon  = 3;
 devapp_armor    = 4;
 devapp_aml	 = 5;
 devapp_bad	 = 6;
 devapp_lrscan	 = 7;
 devapp_ammo     = 8;
 devapp_medline  = 9;
 devapp_rope	 = 10;
 devapp_rations  = 11;
 devapp_scanner  = 12;
 devapp_stealth  = 13;
 devapp_gblaster = 14;
 devapp_armorn   = 15;
 decapp_grenade  = 16;
 devapp_cyceye	 = 17;
 devapp_deathbadge = 18;
 devapp_warper   = 19;
 devapp_communicator = 20;
 devapp_reactor  = 21;
 devapp_comm	 = 22;
 devapp_deffield = 23;
 devapp_moat	 = 24;
 devapp_bweap	 = 25;
 devapp_laptop	 = 26;
 devapp_rom	 = 27;
 devapp_troysteak = 28;
 devapp_tele	 = 29;
 devapp_recharge = 30;
 devapp_pylonkey = 31;
 devapp_vortex	 = 32;
 devapp_unitran  = 33;
 devapp_mine	 = 34;
 devapp_boat     = 35;
 devapp_mapper   = 36;
 devapp_cryo	 = 37;
 devapp_bgen	 = 38;
 devapp_mappack  = 39;
 devapp_genobj   = 40;

 sex_male        = 0;
 sex_female	 = 1;
 sex_other	 = 2;
type
 pbyte = pointer to byte;

 puritronunit=record
	       ishere: boolean;
	       userrealname: string[25];
	       reset: boolean;
	       blah: array 24 of byte;
	      end;

 puritrontype=record
	       parts: array maxpurparts of puritronunit;
	       blah: array 200 of byte;

	       active: boolean;
	      end;

 storeset = array 5 of byte;

 devdeftype=record
	     num: word;               (* device number               *)
	     var1,var2: integer;      (* start up variables          *)
	     x,y,z: byte;             (* object x,y,z position       *)
	     devapp: byte;            (* application type            *)
	     useleft: word;
	     maxuse: word;
	     decuse: boolean;
	     name: string[18];        (* device name                 *)
	     store: storeset;         (* store it sells at           *)
	     cost: comp;              (* how much it costs           *)
	     usable: boolean;         (* can it be used?             *)
	     pic: string[8];          (* ansi picture identifier     *)
	     picnum: word;
	    end;

 pdevdef     = pointer to devdeftype;
 devdefarray = array numdev of pdevdef;
 pdevdefarray= pointer to devdefarray;

 devicetype=record
	     num: word;               (* Device Numbers              *)
	     var1,var2: integer;      (* generic variables           *)
	     x,y,z: byte;             (* object x,y,z position       *)
	     devapp: byte;            (* application type            *)
	     useleft: word;           (* maximum uses and uses left  *)
	    end;

 pdevicetype = pointer to devicetype;

 devarray=  array numudev of devicetype;

 usertype=  record
	     realname: string[35];    (* real name of user           *)
	     alias: string[25];       (* user's alias                *)

	     devices: devarray;
	     weapon1: devicetype;     (* Close combat weapon         *)
	     weapon2: devicetype;     (* Ranged combat weapon        *)
	     auxweapon: devicetype;   (* Auxilary close weapon       *)
	     armor: devicetype;       (* armor                       *)
	     medline: devicetype;     (* Automated medical lining    *)
	     laptop: devicetype;      (* GS-224 Laptop               *)

	     hitpts,hitmax: word;     (* user's hitpoints and hitmax *)
	     unused_1: integer;
	     str,dex,agl: word;       (* strength, dexterity, agil   *)
	     lvl: word;               (* level                       *)
	     exp: comp;               (* experience                  *)
	     money: comp;             (* money                       *)
	     bank: comp;              (* money in the bank           *)
	     alive: boolean;          (* alive ?                     *)
	     x,y,z: byte;             (* x,y,z coords                *)
	     hunger: word;            (* hunger points               *)
	     expert: boolean;         (* expert on?                  *)
	     combat: integer;         (* battles faught in           *)
	     flee: integer;           (* battles fleed in            *)
	     surrender: integer;      (* battles surrendered in      *)
	     kills: integer;          (* number of monsters killed   *)
	     hits: integer;           (* times he hit somebody       *)
	     misses: integer;         (* times he missed somebody    *)
	     lastread: word;          (* message base lastread ptr   *)
	     enhansi: boolean;        (* used enhanced ansi if avail *)
	     clrmap: boolean;         (* color map?                  *)
	     forceansi: boolean;      (* force ansi on?              *)
	     compass: boolean;
	     dietoff: boolean;
	     products: array numprod of comp;
	     buysteak: boolean;
	     getdisk: boolean;
	     didtetris: boolean;
	     rent: integer;
	     rentday: word;
	     lastcity: byte;          (* last city user was at       *)
	     combattext: byte;        (* Entry in monsters.txt w/ combat txt *)
	     timetoday: word;
	     sex: byte;
	     flags: word;
	     quests: integer;
	     janitor: integer;
	     casacct: integer;
	     maintrun: byte;
	     deathtoday: byte;
	     loan: integer;
	     maintdelcount: word;
	     team: byte;
	     fortattack: byte;
	     combatmode: byte;
	     anchorx,anchory,anchorz: byte; (*EMWARP anchor point*)
	     addpts: byte;
	     unused_2: array 12 of byte;
	    end;
 pusertype = pointer to usertype;

 clonetype=record
	    realname: string[35];
	    alias: string[25];
	    hitmax: word;
	    str,dex,agl: word;
	    lvl: word;
	    exp: comp;
	    alive: boolean;
	    blah: array 10 of byte;
	   end;

 monsterrec= record
	      mindist: word;
	      maxdist: word;
	      origx: byte;
	      origy: byte;
	      origz: byte;
	      line: word;
	      str,dex,agl: byte;
	      ifalive: byte;
	      isreal: byte;
	      flags: byte;
	      trestrict: array maxtrestrict of byte;
	     end;

 terraintype= record
	       dng: word;
	       typ: string[12];
	       map: string[2];
	       clr: byte;
	       pas: byte;
	      end;

 baserec = record
	    x,y,z: byte;
	    owner: byte;
	    name: string[20];
	    password: string[8];
	    active: boolean;
	    products: array numprod of integer; (* Products on hand      *)
	    prodfs:   array numprod of integer; (* Products for sale     *)
	    prodsp:   array numprod of word;    (* Prod sell prices      *)
	    prodbp:   array numprod of word;    (* Prod buy prices       *)
	    prodbm:   array numprod of integer; (* Prod buy money        *)
	    med:      integer;                      (* Medkit doses on hand  *)
	    medfs:    integer;                      (* Medkit doses for sale *)
	    medprice: word;                         (* Price of medkit dose  *)
	    energyfs: integer;                      (* Energy for sale       *)
	    energyprice: word;                      (* Energy price          *)
	    energy:  comp;                          (* Energy on hand        *)
	    money:   comp;                          (* money on hand         *)
	    teleprice: integer;                     (* teleportation price   *)
	    spec:    array nbspec of devicetype; (* Specialty Devices     *)

	    forsale: array numbforsale of devicetype;    (* Devices for sale      *)
	    saleprice: array numbforsale of integer;     (* For sale prices       *)

	    basereg: boolean;

	    tollprice: integer;

	    flags: integer;

	    blah: array 8 of byte;
	   end;

 teamtype=   record
	      players: array maxteamplayers of byte;
	      numplayers: byte;
	      name: string[30];
	      pword: string[8];
	     end;
type
 laptoprec=record
	    mask: integer;
	    cmdname: string[8];
	    cmdext: string[3];
	    filesize: integer;
	    date: string[8];
	    time: string[6];
	   end;
const
 numlapcmd=28;
(* LapCmd: array[1..numlapcmd] of  laptoprec =
  ((mask:      0; cmdname: 'DIR';      cmdext: 'COM'; size:   13142; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'EXIT';     cmdext: 'COM'; size:    2714; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'CHKDSK';   cmdext: 'COM'; size:    9535; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'COPY';     cmdext: 'COM'; size:   31244; date: '04-27-12'; time: '10:04p'),
   (mask:      1; cmdname: 'NOTES';    cmdext: 'EXE'; size:   41797; date: '08-12-13'; time: ' 3:39a'),
   (mask:      2; cmdname: 'AUTONAV';  cmdext: 'EXE'; size:  237421; date: '07-26-14'; time: ' 8:17a'),
   (mask:      4; cmdname: 'TRANSFER'; cmdext: 'EXE'; size:   77842; date: '11-09-13'; time: ' 2:32p'),
   (mask:      8; cmdname: 'RANKINGS'; cmdext: 'EXE'; size:   23292; date: '02-17-13'; time: ' 7:24a'),
   (mask:     16; cmdname: 'VIEWLOG';  cmdext: 'COM'; size:   10654; date: '09-30-13'; time: '11:24p'),
   (mask:     32; cmdname: 'EMWARP';   cmdext: 'EXE'; size:  139772; date: '03-11-14'; time: ' 2:49a'),
   (mask:     64; cmdname: 'FORTLIST'; cmdext: 'EXE'; size:   34229; date: '08-14-14'; time: ' 6:52p'),
   (mask:    128; cmdname: 'DIET';     cmdext: 'EXE'; size:  124772; date: '12-03-13'; time: '11:24a'),
   (mask:    256; cmdname: 'CSTATS';   cmdext: 'COM'; size:   27429; date: '07-22-13'; time: ' 3:33a'),
   (mask:    512; cmdname: 'LRSCAN';   cmdext: 'EXE'; size:  118245; date: '09-27-13'; time: ' 1:24p'),
   (mask:   1024; cmdname: 'SCANNER';  cmdext: 'EXE'; size:   96014; date: '04-26-14'; time: ' 7:30a'),
   (mask:   2048; cmdname: 'TROYINFO'; cmdext: 'EXE'; size:  107323; date: '07-19-14'; time: '10:29p'),
   (mask:   4096; cmdname: 'COMMLINK'; cmdext: 'COM'; size:   27094; date: '01-21-14'; time: ' 2:36p'),
   (mask:   8192; cmdname: 'TETRIS';   cmdext: 'EXE'; size:   63294; date: '03-18-13'; time: ' 7:14a'),
   (mask:  16384; cmdname: 'APPRAISE'; cmdext: 'EXE'; size:   72036; date: '04-13-14'; time: ' 9:15p'),
   (mask:  32768; cmdname: 'TCODE';    cmdext: 'EXE'; size:  102997; date: '04-26-14'; time: ' 6:39a'),
   (mask:  65536; cmdname: 'HISTORY';  cmdext: 'COM'; size:   56024; date: '04-23-14'; time: ' 7:04p'),
   (mask: 131072; cmdname: 'WINDOWS';  cmdext: 'EXE'; size:69045234; date: '10-02-13'; time: ' 2:29p'),
   (mask: 262144; cmdname: 'FORTINV';  cmdext: 'EXE'; size:   10324; date: '05-23-14'; time: ' 6:19a'),
   (mask: 524288; cmdname: 'BARTALK';  cmdext: 'COM'; size:   25329; date: '01-19-14'; time: ' 2:22p'),
   (mask:1048576; cmdname: 'SPWEAP';   cmdext: 'COM'; size:   19234; date: '03-22-14'; time: '11:59p'),
   (mask:2097152; cmdname: 'WEAPSMTH'; cmdext: 'EXE'; size:   10926; date: '07-31-14'; time: ' 1:14p'),
   (mask:      0; cmdname: 'VER';      cmdext: 'COM'; size:    1936; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'HELP';     cmdext: 'COM'; size:   22349; date: '04-27-12'; time: '10:04p')
   );
   *)
const
 flagscannercloak=1;

 flagbaseholo=1;

 flaglrscan=1;
 flagroaddata=2;
 flagbigdata=4;
 flaghasmapper=8;
 flagtinyfort=16;

 flaguserdull=1;         (*not using the fancy character sheet*)
 flagusersc=2;           (*store colors disabled*)
 flagusernodel=4;        (*set if user is on No-Deletion status*)
 flagusernodonate=8;     (*set if user is on No-Donations status*)
 flagusernorank=16;      (*set if user should not be ranked*)
 flaguserquick=32;       (*set if user is using QUICK gterm*)
 flaguserrow=64;         (*set if user uses row format inventory*)
 flagusertinyfort=128;   (*use [B] symbol on map instead of fort map tile*)

 flagweapacc1=1;
 flagweapacc2=2;
 flagweapacc3=1+2;
 flagweapstun=4;
 flagweapburst=8;
 flagweapuni=16;
 flagweapint1=32;
 flagweapint2=64;
 flagweapint3=64+32;

 flagarmorrecharge=1;
 flagarmorstr1=2;
 flagarmorstr2=4;
 flagarmorstr3=2+4;
 flagarmordex1=8;
 flagarmordex2=16;
 flagarmordex3=8+16;
 flagarmoragl1=32;
 flagarmoragl2=64;
 flagarmoragl3=32+64;

 flagweapaccn=flagweapacc3;       (*any accurized weapon*)
 flagweapintn=flagweapint3;       (*any intensified weapon*)

 flagmonisreal=1;                 (*set if monster uses ISREAL*)
 flagmonwateronly=2;              (*set for water only monsters*)
 flagmonlandwater=4;              (*set for land/water monsters*)
 flagmonnorandom=8;               (*disables random encounters*)

 flagminesmart=1;                 (*set if smart mine*)
 flagmineenergy=2;                (*set if mine is energy drainer*)
 flagmineteleport=4;              (*set if mine is a teleporter mine*)
 flagminerobo=8;                  (*set if mine is a robomine*)
 flagminenowarn=16;               (*set if mine has warning DISABLED! *)

 flagratiskelp=1;                 (*set if ration is kelp ration - spq #14*)

 flagbgentele1=4;                 (*standard teleporter*)
 flagbgentele2=8;                 (*excelsior teleport*)
 flagbgentele3=16;                (*transporter*)
 flagbgencomm=32;                 (*communications*)
 flagbgencloak=64;                (*cloaking device*)
 flagbgenwander=128;              (*wanderer*)
 flagbgenfactory=256;             (*factory*)
 flagbgendrainer=512;             (*ammo drainer*)

 flagbgenprox0=1024;              (*proximity detector (dist=0)*)
 flagbgenprox1=2048;              (*proximity detector (dist=1)*)
 flagbgenprox2=1024+2048;         (*proximity detector (dist=2)*)
 flagbgenprox3=4096;              (*proximity detector (dist=3)*)
 flagbgenprox4=4096+1024;         (*proximity detector (dist=4)*)
 flagbgenprox5=4096+2048;         (*proximity detector (dist=5)*)
 flagbgenprox6=4096+2048+1024;    (*proximity detector (dist=6)*)

 flagbgentoll0=8192;              (*toll station (dist=0)*)
 flagbgentoll1=16384;             (*toll station (dist=1)*)
 flagbgentoll2=8192+16384;        (*toll station (dist=2)*)
 flagbgentoll3=32768;             (*toll station (dist=3)*)
 flagbgentoll4=32768+8192;        (*toll station (dist=4)*)
 flagbgentoll5=32768+16384;       (*toll station (dist=5)*)
 flagbgentoll6=32768+16384+8192;  (*toll station (dist=6)*)

 flagbgenspread0=65536;           (*mine spreader (dist=0)*)
 flagbgenspread1=131072;          (*mine spreader (dist=1)*)
 flagbgenspread2=131072+65536;    (*mine spreader (dist=2)*)
 flagbgenspread3=262144;          (*mine spreader (dist=3)*)
 flagbgenspread4=262144+65536;    (*mine spreader (dist=4)*)
 flagbgenspread5=262144+131072;   (*mine spreader (dist=5)*)
 flagbgenspread6=262144+131072+
			  65536;  (*mine spreader (dist=6)*)

 flagbgenreactor=65536*8;         (*reactor*)

 flagbgenscav0=65536*16;          (*scavenger radius 0*)
 flagbgenscav1=65536*32;          (*scavenger radius 1*)
 flagbgenscav2=65536*16+65536*32; (*scavenger radius 2*)
 flagbgenscav3=65536*64;          (*scavenger radius 3*)
 flagbgenscav4=65536*64+65536*16; (*scavenger radius 4*)
 flagbgenscav5=65536*64+65536*32; (*scavenger radius 5*)
 flagbgenscav6=65536*64+65536*32+
			65536*16; (*scavenger radius 6*)

 flagbgenscan=65536*128;          (*scanner*)

 flagbgendevlock=65536*256;       (*device lock*)
 flagbgenantisd=65536*512;        (*anti self destruct*)

 flagbgensell1=65536*1024;        (*autosellers*)
 flagbgensell2=65536*2048;
 flagbgensell3=65536*4096;
 flagbgensell4=65536*8192;

 flagbgensmartscav=65536*16384;   (*says scavenger droid is smart*)

 flagbgenproxn=flagbgenprox6;     (*any prox detector*)

 flagbgentolln=flagbgentoll6;     (*any toll station*)

 flagbgenspreadn=flagbgenspread6; (*any spreader*)

 flagbgenscavn=flagbgenscav6;     (*any scavenger*)
var
 user: pusertype;
 usernum: pbyte;
 devicedef: pdevdefarray;

 pchar_player,
 mchar_player,
 dchar_player: pusertype;

#define devdef_decuse(num) (devicedef^[num]^.decuse)
#define devdef_maxuse(num) (devicedef^[num]^.maxuse)
#define devdef_usable(num) (devicedef^[num]^.usable)
#define devdef_name(num)   (devicedef^[num]^.name)

#define onoff(b) (Cond(b,"On","Off"))
#define yesno(b) (Cond(b,"Yes","No"))
#define mine_smart(d) ((wammo(d.var1) & flagminesmart)<>0)
#define mine_energy(d) ((wammo(d.var1) & flagmineenergy)<>0)
#define mine_teleport(d) ((wammo(d.var1) & flagmineteleport)<>0)
#define mine_robo(d) ((wammo(d.var1) & flagminerobo)<>0)
#define mine_warn(d) ((wammo(d.var1) & flagminenowarn)=0)

