unit globals;

interface
uses emsalloc;

const
 compilerev=3;

 nbspec=8;
 numbasestartspec=5;
 numueqp=6;
 numudev=18;
 numdev=350;
 numobj=2048;
 numst=50;
 numprod=3;
 numbase=75;
 numspell=5;
 numbforsale=8;
 numterrain=50;
 hinc=45;

 maxusers=255; {not fully implemented}

 maxmapx=125;
 maxmapy=125;
 maxmapz=1;
 maxgenobj=255;
 maxtover=64;
 maxquest=32;

 numca=100;
 maxtav=50;
 numtcode=27;
 maxinclude=10;
 maxtrestrict=4;

 maxpurparts=10;
 numpurparts=9;
 kirkpart=1;
 xebocpart=2;
 drakpart=3;
 xebpart=4;
 tranliuspart=5;
 vayderrpart=6;
 snowguypart=7;
 lokipart=8;
 serpinepart=9;

 ammomax=20;
 vortexbattmax=9999;

 maxteams=10;
 maxteamplayers=5;

 doauth: boolean=true;

 maxmon=300;

 maxnab=15;

 maxpmask=10;

 gtpacketver = 'D';

 regfilename1: string[5] ='LO';

 gamename='Land Of Devastation';
 gamename3: string[32] = 'Land Of Devastation';
 authname='Scott M. Baker';
 vernum='4.10';

 regfilename3: string[5] ='G.DAT';
 gamename2: string[32] = 'Land Of Devastation';
 authfile1: string[5] = 'AUTH';
 regfilename2: string[5] = 'DRE';

 strdef_maxreplace = 5;

 hunt: word = 0;

 usemod: boolean = false;
type
 tpass = (Imp, Pass, Water, Lava);
 strptr=^string;
 storetype= (NoStore,Weap,Armr,Supp,Ammo,BaseReact,BaseMsc,BaseDef,BaseMoat,
             BaseWeap,computer,weaplr,troysteak,troydisk,gsrz,BaseFact,EEEE,
             town2,town3,town4,town5,town6,town7,town8,town9,
             kill,BasePack,BaseScav,BaseEne,BaseMed,AcmeFort,AcmeWeap,
             AcmeROM,endstore);

 maptype=   array[1..maxmapx,1..maxmapy] of byte;
 mapptr=    ^maptype;
 devapptype=(Radio,Medkit,Weapon,RangeWeapon,Armor,AML,BAD,LRScan,AmmoP,
             medline,rope,rations,scanner,stealth,gblaster,armorn,grenade,
             cyceye,deathbadge,warper,communicator,reactor,comm,deffield,
             moat,bweap,laptop,rom,troysteakp,tele,recharge,pylonkey,
             vortexbatt,unitran,mine,boat,mapper,cryo,bgen,MapPack,
             genobjapp);

 sextype =  (male,female,other);

 bigpicident=string[8];

 ogtypetype= (ogheader,ogfooter,ograndtext,ogconvert,ogadditem,ogreplicate,ogfail);

 iftypetype= (ifTerrain,ifNTerrain,ifDoLoki,ifDoQuest,IfQuest,IfNQuest,
              ifPuritron,ifNPuritron,ifLevel,ifNLevel,ifExper,IfNExper,
              ifDoSerpine,ifMindist,ifMaxdist,IfTestX,ifNTestX,IfTestY,
              ifNTestY,IfTestZ,IfNTestZ);

 ifptr=^iftype;
 iftype=record
         iftype: iftypetype;
         data: longint;
         next: ifptr;
        end;

 genobjtype=record
             tag: word;
             ogtype: ogtypetype;
             tstart,tend: word;
             iflist: ifptr;
             cnvin,cnvout: word;
            end;

 genobjptr=^genobjtype;

 genobjarray=array[1..maxgenobj] of genobjptr;

 tovertype = record
              x,y,z: word;
              typ: byte;
             end;

 toverarraytype = array[1..maxtover] of tovertype;

 puritronunit=record
               ishere: boolean;
               userrealname: string[25];
               reset: boolean;
               blah: array[1..24] of byte;
              end;

 puritrontype=record
               parts: array[1..maxpurparts] of puritronunit;
               blah: array[1..200] of byte;

               active: boolean;
              end;

 CasinoUnit=record                        { 1 - Coin Flip    }
             timesplayed: longint;        { 2 - Guess number }
             timeswon: longint;           { 3 - Slot Machine }
             timeslost: longint;          { 4 - Trivia       }
             moneyspent: comp;
             moneywon: comp;
             moneylost: comp;
             lastplayer: string[25];
             blah: array[1..10] of word;
            end;

 MDataType=record
             games: array[1..12] of casinounit;

             donations: comp;
             tax: comp;
             plays: word;
             timeused: word;
             datestamp: longint;
             totalplays: longint;
             totaltime: longint;

             tover: toverarraytype;
             numtover: word;

             blah: array[1..512] of byte;
            end;

 datasettype= record
               sdstart,sdend: word;
               name: strptr;
               author: strptr;
               prodname: array[1..3] of strptr;
               menustem: string[8];
               cityname: array[1..10] of strptr;
               hisstr: strptr;
               herstr: strptr;
               itsstr: strptr;
               hestr:  strptr;
               shestr: strptr;
               itstr:  strptr;
               mhimstr: strptr;
               fhimstr: strptr;
               ihimstr: strptr;
               obstart,obend: word;

               egadoccent,       egacomcent,      egaclone,
               egapurroom,       egafinance,      egasurr,
               egafortatck,      egafortcnfg,     egatavern,
               egabartalk,       egaftrade,       egafortfin,
               egafortret,       egafortmm1,      egafortbad,
               egafortmain,      egalaptop,       egaeeeebig,
               egakillbig,       egahortbig,      egahortstor,
               egatport,         egateam,         egatquart,
               egatele1,         egatele2,        egatranlius,
               egaAcmeFort,      egaAcmeWeap,     egaAcmeweapsmith,
               egaAcmeTech,      egaAcmeMain,     egaLoki,
               egaTadsu:   bigpicident;

               charpic: array[male..other] of bigpicident;

               egatown: array[1..10] of bigpicident;

               kelpreward: longint;

               emwarpmine: byte;

               townsalv: array[1..10] of word;
              end;

 sysoptype=  record
              asciitop10: string[128];
              ansitop10: string[128];
              maxtime: word;
             end;

 generaltype=record
              startstr: word;            { New Player Starting values }
              startdex: word;
              startagl: word;
              starthp: word;
              startmoney: word;
              startdev1: string[25];
              startdev2: string[25];
              startdev3: string[25];

              basecost: longint;         { Cost of fortress           }
              lev2exp: longint;          { level 2 experience         }
              expmul: byte;              { Experience multiplier      }
              levlim: byte;              { Level repeate              }
              levpts: byte;

              basestartspec: array[1..numbasestartspec] of string[25];

{              basestartweap: string[25];
              basestartdef: string[25];
              basestartreact: string[25];
              basestartmoat: string[25];
              basestarttele: string[25];}

              basestartene: longint;
              basemaxitems: word;
              playermaxbases: word;

              janitorpay: longint;
              killobj: boolean;

              statmodeavail: boolean;
              alphamodeavail: boolean;
              reflexmodeavail: boolean;

              reflexdelay: word;
              reflexhit: word;
              reflexincr: word;
              alphadelay: word;
              alphahit: word;

              LRAnsiLx: byte;
              LRAnsiLy: byte;
              LRAnsiGx: byte;
              LRAnsiGy: byte;
              LRAnsiTx: byte;
              LRAnsiTy: byte;
              LRAnsiBf: byte;
              LRAnsiBb: byte;
              LRAnsiCx: byte;
              LRAnsiCy: byte;
              LRAnsiCf: byte;
              LRAnsiCb: byte;

              minloanday: byte;

              FSAnsiFx: byte;
              FSAnsiFy: byte;
              FSAnsiFf: byte;
              FSAnsiFb: byte;
              FSAnsiTx: byte;
              FSAnsiTy: byte;
              FSAnsiTf: byte;
              FSAnsiTb: byte;

              loanint: byte;
              bankint: byte;
              gameint: byte;
              loanmax: byte;

              PTAnsiPx: byte;
              PTAnsiPy: byte;
              PTAnsiPf: byte;
              PTAnsiPb: byte;
              PTAnsiNxo: byte;
              PTAnsiNyo: byte;
              PTAnsiNf: byte;
              PTAnsiNb: byte;

              purmoney: array[1..numpurparts] of longint;
              purexp: array[1..numpurparts] of longint;

              daystodel: word;
              daystodeldead: word;

              inbankmax: longint;
              incasmax: longint;
              inloanmax: longint;

              monsellmult: real;

              vbattammoeff: array[1..ammomax] of byte;
              vbattammonames: array[1..ammomax] of string[20];
              numvbattammo: word;

              PTAnsinx: byte;
              PTAnsiny: byte;
              PTAnsiRx: byte;
              PTAnsiRy: byte;
              PTAnsiRf: byte;
              PTAnsiRb: byte;
              PTAnsiAx: byte;
              PTAnsiAy: byte;
              PTAnsiAf: byte;
              PTAnsiAb: byte;

              purquest: array[1..numpurparts] of word;

              taxlevel: byte;
              taxpercent: byte;

              maxfortattack: byte;

              trivia_cost,
              trivia_pay,
              caslimit: longint;

              porig: array[1..maxpmask] of byte;
              pnew: array[1..maxpmask] of byte;

              LRAnsiC2x: byte;
              LRAnsic2y: byte;

              maxtransport: byte;

              deathperday: byte;

              maxbasemoney: comp;
              maxbaseenergy: comp;

              unused: word;
              basesalvage: word;

              vortexeneprice: word;

              ACMEthreeroundprice: word;
              ACMEaccprice: array[1..3] of word;
              ACMEintprice: array[1..3] of word;
              ACMEuniprice: word;
              ACMEstunprice: word;

              stun5odds: word;
              stun4odds: word;
              stun3odds: word;
              stun2odds: word;
              stun1odds: word;
              stunaddodds: word;

              scavratio: word;
              maxscavmoney: longint;

              scavmedratio: word;
              maxscavmed: longint;

              scaveneratio: word;
              maxscavene: longint;

              ACMEscandecloakprice: word;
              ACMEarmor1price: word;
              ACMEarmor2price: word;
              ACMEarmor3price: word;

              ACMEarmor1bp: longint;
              ACMEarmor2bp: longint;
              ACMEarmor3bp: longint;

              taxlevel2: byte;
              taxpercent2: byte;
              discpercent: byte;

              moneyperlevel: longint;
              xebocmax: word;

              numquest: word;

              raiseall: boolean;
             end;

 devdeftype=record
             num: word;               { device number               }
             var1,var2: longint;      { start up variables          }
             x,y,z: byte;             { object x,y,z position       }
             devapp: devapptype;      { application type            }
             useleft: word;
             maxuse: word;
             decuse: boolean;
             name: string[18];        { device name                 }
             store: set of storetype; { store it sells at           }
             cost: comp;              { how much it costs           }
             usable: boolean;         { can it be used?             }
             pic: string[8];          { ansi picture identifier     }
             picnum: word;
            end;

 devdeftptr=^devdeftype;
 devdefarray= array[0..numdev] of devdeftptr;

 devicetype=record
             num: word;               { Device Numbers              }
             var1,var2: longint;      { generic variables           }
             x,y,z: byte;             { object x,y,z position       }
             devapp: devapptype;      { application type            }
             useleft: word;           { maximum uses and uses left  }
            end;

 pdevicetype = ^devicetype;



 devarray=  array[1..numudev] of devicetype;
 usertype=  record
             realname: string[35];    { real name of user           }
             alias: string[25];       { user's alias                }
             devices: devarray;
             weapon1: devicetype;     { Close combat weapon         }
             weapon2: devicetype;     { Ranged combat weapon        }
             auxweapon: devicetype;   { Auxilary close weapon       }
             armor: devicetype;       { armor                       }
             medline: devicetype;     { Automated medical lining    }
             laptop: devicetype;      { GS-224 Laptop               }
             hitpts,hitmax: word;     { user's hitpoints and hitmax }
             unused_1: longint;
             str,dex,agl: word;       { strength, dexterity, agil   }
             lvl: word;               { level                       }
             exp: comp;               { experience                  }
             money: comp;             { money                       }
             bank: comp;              { money in the bank           }
             alive: boolean;          { alive ?                     }
             x,y,z: byte;             { x,y,z coords                }
             hunger: word;            { hunger points               }
             expert: boolean;         { expert on?                  }
             combat: longint;         { battles faught in           }
             flee: longint;           { battles fleed in            }
             surrender: longint;      { battles surrendered in      }
             kills: longint;          { number of monsters killed   }
             hits: longint;           { times he hit somebody       }
             misses: longint;         { times he missed somebody    }
             lastread: word;          { message base lastread ptr   }
             enhansi: boolean;        { used enhanced ansi if avail }
             clrmap: boolean;         { color map?                  }
             forceansi: boolean;      { force ansi on?              }
             compass: boolean;
             dietoff: boolean;
             products: array[1..numprod] of comp;
             buysteak: boolean;
             getdisk: boolean;
             didtetris: boolean;
             rent: longint;
             rentday: word;
             lastcity: byte;          { last city user was at       }
             combattext: byte;        { Entry in monsters.txt w/ combat txt }
             timetoday: word;
             sex: sextype;
             flags: word;
             quests: longint;
             janitor: longint;
             casacct: longint;
             maintrun: byte;
             deathtoday: byte;
             loan: longint;
             maintdelcount: word;
             team: byte;
             fortattack: byte;
             combatmode: byte;
             anchorx,anchory,anchorz: byte; {EMWARP anchor point}
             addpts: byte;
             unused_2: array[1..12] of byte;
            end;

 clonetype=record
            realname: string[35];
            alias: string[25];
            hitmax: word;
            str,dex,agl: word;
            lvl: word;
            exp: comp;
            alive: boolean;
            blah: array[1..10] of byte;
           end;

 useridxtype= record
               x,y,z: byte;
               alive: boolean;
              end;

 useridxarray= array[1..maxusers] of useridxtype;


 dstrarray= array[1..numst] of word;
 combattype=record
             player: usertype;        { player who is in combat     }
             typ: byte;
             talkto: word;
             dudepic: bigpicident;
             desc: dstrarray;         { description of player       }
             fleetxt: dstrarray;      { what to say when player runs}
             fleeran: dstrarray;      { random flee text            }
             killhim: dstrarray;      { when player kills monster   }
             disintequip: array[1..numueqp] of byte;
             disintinv: array[1..numudev] of byte;
             disintper: word;
             berserk: boolean;
             isreal: word;
             except0: boolean;
             nosurr: boolean;         { monster does not allow surrender }
             nosell: boolean;         { monster will not sell equipment }
             nab: array[1..maxnab] of word;  {Nuke-all-but}
             numnab: word;
             stun: word;              { # turns player is stunned for }
             camped: boolean;
            end;
 combatptr= ^combattype;

 includetype=record
              code: string[2];
              guy1,guy2: byte;
             end;
 cstrtype=record
           numinclude: word;
           include: array[1..maxinclude] of includetype;
           numstr: word;
           strings: dstrarray;
          end;
 cstrptr=^cstrtype;
 cstrarray=array[1..numca] of cstrptr;

 monsterrec= record
              mindist: word;
              maxdist: word;
              origx: byte;
              origy: byte;
              origz: byte;
              line: word;
              str,dex,agl: byte;
              ifalive: byte;
              isreal: byte;
              flags: byte;
              trestrict: array[1..maxtrestrict] of byte;
             end;

 objptr= ^devicetype;
 objarray= array[1..numobj] of objptr;
 terraintype= record
               dng: word;
               typ: string[12];
               map: string[2];
               clr: byte;
               pas: tpass;
              end;
 terrainarray= array[0..numterrain] of terraintype;

 baserec = record
            x,y,z: byte;
            owner: byte;
            name: string[20];
            password: string[8];
            active: boolean;
            products: array[1..numprod] of longint; { Products on hand      }
            prodfs:   array[1..numprod] of longint; { Products for sale     }
            prodsp:   array[1..numprod] of word;    { Prod sell prices      }
            prodbp:   array[1..numprod] of word;    { Prod buy prices       }
            prodbm:   array[1..numprod] of longint; { Prod buy money        }
            med:      longint;                      { Medkit doses on hand  }
            medfs:    longint;                      { Medkit doses for sale }
            medprice: word;                         { Price of medkit dose  }
            energyfs: longint;                      { Energy for sale       }
            energyprice: word;                      { Energy price          }
            energy:  comp;                          { Energy on hand        }
            money:   comp;                          { money on hand         }
            teleprice: longint;                     { teleportation price   }
            spec:    array[1..nbspec] of devicetype;{ Specialty Devices     }

            forsale: array[1..numbforsale] of devicetype;    { Devices for sale      }
            saleprice: array[1..numbforsale] of longint;     { For sale prices       }

            basereg: boolean;

            tollprice: longint;

            flags: longint;

            blah: array[1..8] of byte;
           end;

 basearray= array[1..numbase] of baserec;
 baseptr = ^basearray;
 routept=record
          x,y: byte;
         end;
 routetype = array[1..128] of routept;

 questtype= record
             award: longint;
             mask: longint;
             pts: byte;
            end;
 questarray = array[1..maxquest] of questtype;

 taverntype= record
              personname: string[20];
              personnum: word;
              townnum: word;
             end;

 tavernptr = ^taverntype;

 tavernarray=array[1..maxtav] of tavernptr;

 telecodetype=record
               c: array[1..4] of byte;
               d: byte;
               z,x,y: byte;
              end;
 telearray=array[1..numtcode] of telecodetype;



 teamtype=   record
              players: array[1..maxteamplayers] of byte;
              numplayers: byte;
              name: string[30];
              pword: string[8];
             end;

 teamarray=  array[1..maxteams] of teamtype;

 string35= string[35];

 getattrtype = (gaStr,gaDex,gaAgl);
const
 prodbuy: array[1..numprod] of word = (10,10,10);
 citypricemul: array[1..10] of real = (1,1.25,2.13,3.75,4.22,4.75,5.11,5.30,5.75,6.91);
type
 laptoprec=record
            mask: longint;
            cmdname: string[8];
            cmdext: string[3];
            size: longint;
            date: string[8];
            time: string[6];
           end;
const
 sot=#1;
 ack=#6;
 nak=#21;
 numlapcmd=28;
 LapCmd: array[1..numlapcmd] of  laptoprec =
  ((mask:      0; cmdname: 'DIR';      cmdext: 'COM'; size:   13142; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'EXIT';     cmdext: 'COM'; size:    2714; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'CHKDSK';   cmdext: 'COM'; size:    9535; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'COPY';     cmdext: 'COM'; size:   31244; date: '04-27-12'; time: '10:04p'),
   (mask:      1; cmdname: 'NOTES';    cmdext: 'EXE'; size:   41797; date: '08-12-13'; time: ' 3:39a'),
   (mask:      2; cmdname: 'AUTONAV';  cmdext: 'EXE'; size:  237421; date: '07-26-14'; time: ' 8:17a'),
   (mask:      4; cmdname: 'TRANSFER'; cmdext: 'EXE'; size:   77842; date: '11-09-13'; time: ' 2:32p'),
   (mask:      8; cmdname: 'RANKINGS'; cmdext: 'EXE'; size:   23292; date: '02-17-13'; time: ' 7:24a'),
   (mask:     16; cmdname: 'VIEWLOG';  cmdext: 'COM'; size:   10654; date: '09-30-13'; time: '11:24p'),
   (mask:     32; cmdname: 'EMWARP';   cmdext: 'EXE'; size:  139772; date: '03-11-14'; time: ' 2:49a'),
   (mask:     64; cmdname: 'FORTLIST'; cmdext: 'EXE'; size:   34229; date: '08-14-14'; time: ' 6:52p'),
   (mask:    128; cmdname: 'DIET';     cmdext: 'EXE'; size:  124772; date: '12-03-13'; time: '11:24a'),
   (mask:    256; cmdname: 'CSTATS';   cmdext: 'COM'; size:   27429; date: '07-22-13'; time: ' 3:33a'),
   (mask:    512; cmdname: 'LRSCAN';   cmdext: 'EXE'; size:  118245; date: '09-27-13'; time: ' 1:24p'),
   (mask:   1024; cmdname: 'SCANNER';  cmdext: 'EXE'; size:   96014; date: '04-26-14'; time: ' 7:30a'),
   (mask:   2048; cmdname: 'TROYINFO'; cmdext: 'EXE'; size:  107323; date: '07-19-14'; time: '10:29p'),
   (mask:   4096; cmdname: 'COMMLINK'; cmdext: 'COM'; size:   27094; date: '01-21-14'; time: ' 2:36p'),
   (mask:   8192; cmdname: 'TETRIS';   cmdext: 'EXE'; size:   63294; date: '03-18-13'; time: ' 7:14a'),
   (mask:  16384; cmdname: 'APPRAISE'; cmdext: 'EXE'; size:   72036; date: '04-13-14'; time: ' 9:15p'),
   (mask:  32768; cmdname: 'TCODE';    cmdext: 'EXE'; size:  102997; date: '04-26-14'; time: ' 6:39a'),
   (mask:  65536; cmdname: 'HISTORY';  cmdext: 'COM'; size:   56024; date: '04-23-14'; time: ' 7:04p'),
   (mask: 131072; cmdname: 'WINDOWS';  cmdext: 'EXE'; size:69045234; date: '10-02-13'; time: ' 2:29p'),
   (mask: 262144; cmdname: 'FORTINV';  cmdext: 'EXE'; size:   10324; date: '05-23-14'; time: ' 6:19a'),
   (mask: 524288; cmdname: 'BARTALK';  cmdext: 'COM'; size:   25329; date: '01-19-14'; time: ' 2:22p'),
   (mask:1048576; cmdname: 'SPWEAP';   cmdext: 'COM'; size:   19234; date: '03-22-14'; time: '11:59p'),
   (mask:2097152; cmdname: 'WEAPSMTH'; cmdext: 'EXE'; size:   10926; date: '07-31-14'; time: ' 1:14p'),
   (mask:      0; cmdname: 'VER';      cmdext: 'COM'; size:    1936; date: '04-27-12'; time: '10:04p'),
   (mask:      0; cmdname: 'HELP';     cmdext: 'COM'; size:   22349; date: '04-27-12'; time: '10:04p')
   );
const


 flagscannercloak=1;

 flagbaseholo=1;

 flaglrscan=1;
 flagroaddata=2;
 flagbigdata=4;
 flaghasmapper=8;
 flagtinyfort=16;

 flaguserdull=1;         {not using the fancy character sheet}
 flagusersc=2;           {store colors disabled}
 flagusernodel=4;        {set if user is on No-Deletion status}
 flagusernodonate=8;     {set if user is on No-Donations status}
 flagusernorank=16;      {set if user should not be ranked}
 flaguserquick=32;       {set if user is using QUICK gterm}
 flaguserrow=64;         {set if user uses row format inventory}
 flagusertinyfort=128;   {use [B] symbol on map instead of fort map tile}

 flagweapacc1=1;
 flagweapacc2=2;
 flagweapacc3=1+2;
 flagweapstun=4;
 flagweapburst=8;
 flagweapuni=16;
 flagweapint1=32;
 flagweapint2=64;
 flagweapint3=64+32;

 flagarmorrecharge=1;
 flagarmorstr1=2;
 flagarmorstr2=4;
 flagarmorstr3=2+4;
 flagarmordex1=8;
 flagarmordex2=16;
 flagarmordex3=8+16;
 flagarmoragl1=32;
 flagarmoragl2=64;
 flagarmoragl3=32+64;

 flagweapaccn=flagweapacc3;       {any accurized weapon}
 flagweapintn=flagweapint3;       {any intensified weapon}

 flagmonisreal=1;                 {set if monster uses ISREAL}
 flagmonwateronly=2;              {set for water only monsters}
 flagmonlandwater=4;              {set for land/water monsters}
 flagmonnorandom=8;               {disables random encounters}

 flagminesmart=1;                 {set if smart mine}
 flagmineenergy=2;                {set if mine is energy drainer}
 flagmineteleport=4;              {set if mine is a teleporter mine}
 flagminerobo=8;                  {set if mine is a robomine}
 flagminewarn=16;                 {set if mine has warning disabled}

 flagratiskelp=1;                 {set if ration is kelp ration - spq #14}

 flagbgentele1=4;                 {standard teleporter}
 flagbgentele2=8;                 {excelsior teleport}
 flagbgentele3=16;                {transporter}
 flagbgencomm=32;                 {communications}
 flagbgencloak=64;                {cloaking device}
 flagbgenwander=128;              {wanderer}
 flagbgenfactory=256;             {factory}
 flagbgendrainer=512;             {ammo drainer}

 flagbgenprox0=1024;              {proximity detector (dist=0)}
 flagbgenprox1=2048;              {proximity detector (dist=1)}
 flagbgenprox2=1024+2048;         {proximity detector (dist=2)}
 flagbgenprox3=4096;              {proximity detector (dist=3)}
 flagbgenprox4=4096+1024;         {proximity detector (dist=4)}
 flagbgenprox5=4096+2048;         {proximity detector (dist=5)}
 flagbgenprox6=4096+2048+1024;    {proximity detector (dist=6)}

 flagbgentoll0=8192;              {toll station (dist=0)}
 flagbgentoll1=16384;             {toll station (dist=1)}
 flagbgentoll2=8192+16384;        {toll station (dist=2)}
 flagbgentoll3=32768;             {toll station (dist=3)}
 flagbgentoll4=32768+8192;        {toll station (dist=4)}
 flagbgentoll5=32768+16384;       {toll station (dist=5)}
 flagbgentoll6=32768+16384+8192;  {toll station (dist=6)}

 flagbgenspread0=65536;           {mine spreader (dist=0)}
 flagbgenspread1=131072;          {mine spreader (dist=1)}
 flagbgenspread2=131072+65536;    {mine spreader (dist=2)}
 flagbgenspread3=262144;          {mine spreader (dist=3)}
 flagbgenspread4=262144+65536;    {mine spreader (dist=4)}
 flagbgenspread5=262144+131072;   {mine spreader (dist=5)}
 flagbgenspread6=262144+131072+
                          65536;  {mine spreader (dist=6)}

 flagbgenreactor=65536*8;         {reactor}

 flagbgenscav0=65536*16;          {scavenger radius 0}
 flagbgenscav1=65536*32;          {scavenger radius 1}
 flagbgenscav2=65536*16+65536*32; {scavenger radius 2}
 flagbgenscav3=65536*64;          {scavenger radius 3}
 flagbgenscav4=65536*64+65536*16; {scavenger radius 4}
 flagbgenscav5=65536*64+65536*32; {scavenger radius 5}
 flagbgenscav6=65536*64+65536*32+
                        65536*16; {scavenger radius 6}

 flagbgenscan=65536*128;          {scanner}

 flagbgendevlock=65536*256;       {device lock}
 flagbgenantisd=65536*512;        {anti self destruct}

 flagbgensell1=65536*1024;        {autosellers}
 flagbgensell2=65536*2048;
 flagbgensell3=65536*4096;
 flagbgensell4=65536*8192;

 flagbgensmartscav=65536*16384;   {says scavenger droid is smart}

 flagbgenproxn=flagbgenprox6;     {any prox detector}

 flagbgentolln=flagbgentoll6;     {any toll station}

 flagbgenspreadn=flagbgenspread6; {any spreader}

 flagbgenscavn=flagbgenscav6;     {any scavenger}

 numgtermdev=numudev+6;
type
 gmaptype=array[1..9,1..9] of byte;
 datype= array[1..numgtermdev] of byte;
 devnametype = array[1..numgtermdev] of string[18];
 miscdatatype= record
                datavalid: boolean;
                datainvalid: boolean;
                lodversion: string[5];
                username: string[35];
                useralias: string[35];
                sysopname: string[35];
                bbsname: string[35];
                regname: string[35];
                reg: boolean;
                hitmax: word;
                str,dex,agl: word;
                level: byte;
                ureg: boolean;

                datasetname: string[45];    { from dataset }
                datasetauthor: string[45];

                lev2exp: longint;           { from general }
                expmul: byte;
                levlim: byte;
                levpts: byte;

                armormax: word;

                blah: array[1..30] of byte;
               end;

 gamedatatype= record
                map: gmaptype;
                z,x,y: byte;
                dist: byte;
                danger: byte;
                hitpts: word;
                exper: longint;
                money: longint;
                hunger: byte;
                devpichi: datype;
                devpiclo: datype;
                devusehi: datype;
                devuselo: datype;
                devname: devnametype;
                flags: byte;
                sfgmode: byte;
                timeleft: byte;
                mapflag: gmaptype;
                tername: string[12];
                bigpicname: string[8];
                h,m,s,s100: word;
                quests: longint;
                bank: longint;
                casacct: longint;
                loan: longint;
                blah2: array[1..32] of byte;
               end;

 nomapdatatype= record
                hitpts: word;
                exper: longint;
                money: longint;
                hunger: byte;
                devpichi: datype;
                devpiclo: datype;
                devusehi: datype;
                devuselo: datype;
                devname: devnametype;
                flags: byte;
                sfgmode: byte;
                timeleft: byte;
                bigpicname: string[8];
                h,m,s,s100: word;
                quests: longint;
                bank: longint;
                casacct: longint;
                loan: longint;
                blah: array[1..32] of byte;
               end;

 combatdatatype= record
                  monsterpic: bigpicident;
                  playerpic: bigpicident;
                  monsterhit: word;
                  playerhit: word;
                  monsterhp: word;
                  playerhp: word;
                  devpichi: datype;
                  devpiclo: datype;
                  devusehi: datype;
                  devuselo: datype;
                  devname: devnametype;
                  blah: array[1..32] of byte;
                 end;

 combatdatabigtype= record
                  monsterpic: bigpicident;
                  playerpic: bigpicident;
                  monsterhit: word;
                  playerhit: word;
                  monsterhp: word;
                  playerhp: word;
                  monsterhpmax: word;
                  playerhpmax: word;
                  hitf8: boolean;
                  unhitf8: boolean;
                  blah: array[1..32] of byte;
                 end;

 ansidatatype= record
                chk: word;
                name: string[8];
                blah: array[1..32] of byte;
               end;

 rankrec=record
          name: string[14];
          flags: byte;
          percents: array[1..8] of byte;
          blah: array[1..10] of byte;
         end;

 rankdatatype=record
               numrank: byte;
               theuser: rankrec;
               theavg: rankrec;
               rankings: array[1..12] of rankrec;
              end;

 roadsmaptype=array[1.. ((maxmapx div 4)+1),1..maxmapy] of byte;
 roadsmapptr=^roadsmaptype;
const
 try_ega: boolean = false;
 roadsgood: boolean = false;
 roadsneeded: boolean = false;
 mapsize=sizeof(maptype);
 authfile3: string[5] = 'I.LOD';
 trivmax=200;
 numpk=20;
 authfile2: string[5] = 'ENT';
var
 nomap: nomapdatatype;
 combatdata: combatdatatype;
 combatdatabig: combatdatabigtype;
 lastgamedata,gamedata: gamedatatype;
 lastmiscdata,miscdata: miscdatatype;
 rankdata: rankdatatype;
 roadsmap: EAPointer;
type
 idrec=record
        poslo: word;
        poshi: byte;
       end;
 idarray=array[0..1] of idrec;
 idarrayptr = ^idarray;
 pstring = ^string;
var
 {GAME DEF STUFF}
 gamedef: text;
 gamebin: file;
 talkstart: word;
 trellstart, trellend: word;
 wpsmstart, wpsmend: word;
 spwstart, spwend: word;
 troystart, troyend: word;
 histstart, histend: word;
 laphelpstart, laphelpend: word;
 commstart, commend: word;
 pfstart,pfend: array[1..numpurparts] of word;
 afstart,afend: array[1..numpurparts] of word;
 dataset: datasettype;

 {USED FOR STRDEF REPLACE}

 strdef_numreplace: word;
 strdef_replace1: array[1..strdef_maxreplace] of pstring;
 strdef_replace2: array[1..strdef_maxreplace] of pstring;

 {OTHER STUFF}

 gterm_lastlr: gmaptype;
 gterm_lastlrz,gterm_lastlrx,gterm_lastlry: byte;
 gterm_needlrupdate: boolean;
 gterm_lrpresent: boolean;
 gterm_invscroll: word;
 gterm_comport: word;
 gterm_baud_rate: word;
 gterm_lodusername: string[40];
 gterm_local: boolean;
 sysopdata: sysoptype;
 telecodes: telearray;
 autonavx,autonavy,autonavz: byte;
 general: generaltype;
 terrain: terrainarray;
 devicedef: devdefarray;
 nummondef: word;
 mondef: array[1..maxmon] of EAPointer;
 filesopen: boolean;
 exitsave: pointer;
 usernum: byte;
 user: usertype;
 userfile: file of usertype;
 useridx: useridxarray;
 imap: array[1..numdev] of word;
 numitems: byte;
 zmap: mapptr;
 clonefile: file of clonetype;
 objects: objarray;
 numolist: word;
 pchar,mchar,dchar: combatptr;
 needredraw: boolean;
 realansi: boolean;
 bases: baseptr;
 medcount: word;
 gtermon: boolean;
 lastmove: boolean;
 strdefbytes: word;
 dietcount: word;
 numgroups: word;
 groups: cstrarray;
 tavern: tavernarray;
 numtav: word;
 tryems: boolean;
 numstrdef: word;
 checkmulti: boolean;
 lokexitsave: pointer;
 automaint: boolean;

 {ModPlayer Stuff}
{ moddev: integer;
 modqual: byte;}
 modirq: byte;
 moddma: byte;
 modbase: word;
 msename: string;
 modplayername: string;
 forceremoteaudio: boolean;

 memstart: longint;
 purmask: array[0..numterrain] of byte;
 havepurmask: boolean;
 enhon: boolean;
 npcfortstart: word;

 pkup: array[1..numpk] of word;
 pksend: array[1..numpk] of word;
 pkbyte: array[1..numpk] of longint;

 puritron: puritrontype;
 mdata: ^mdatatype;
 teams: EAPointer;

 timeusedstart: word;

 trivquest: array[1..trivmax] of byte;

 devfill,devgood,devnil: word;

 strdefid: pointer;
 didpause: boolean;

 genobj: genobjarray;
 numgenobj: word;

 quests: questarray;

 strdef_numindex,strdef_idxstart,strdef_idxsize,strdef_strstart: longint;

implementation

end.
