/*Example DOWNMULT.CMD that generates and sends additionally a LogFile of the
  transferred files.
*/

arg prot com node filelist

descfilepath="c:\max\tagger"
dlcounterid="["  /*identifies dlcounter*/
dateformat="E"   /*European, use "U" for US format*/
BBSName="MY BBS" /*Put the Name of your BBS in these Quotes*/

logoff=0
if prot="L" then do
  logoff=1
  prot="Z"
end

dlbbs="dl"node".bbs"
"@if exist "dlbbs" del "dlbbs
rc=lineout(dlbbs,"")                       /*[moreoff]          */
rc=lineout(dlbbs,"P"prot)                  /*[key_poke]prot     */
rc=lineout(dlbbs,"rj")                    /*[chg_protocoll]*/
rc=lineout(dlbbs,"******************************************************")
rc=lineout(dlbbs,"Please hold on, initiating Download ..................")
rc=lineout(dlbbs,"******************************************************")
line=linein(filelist)
fcount=0
do while line<>""
  fcount=fcount+1
  if fcount>25 then do  /*repeat download command*/
    rc=lineout(dlbbs,"P|")                     /*[key_poke]|        */
    rc=lineout(dlbbs,"r")                    /*[menu_cmd download]*/

    fcount=1
  end
  fname=word(line,1)
  rc=lineout(dlbbs,"J"fname"%")            /*[download]filename%*/
  line=linein(filelist)
end
rc=lineout(filelist)
if prot="Z" then rc=lineout(dlbbs,"J"descname()"%")
if logoff=1 then rc=lineout(dlbbs,"P/G")   /*[key_poke]/G       */
rc=lineout(dlbbs,"P|")                     /*[key_poke]|        */
rc=lineout(dlbbs,"r")                    /*[menu_cmd download]*/
rc=lineout(dlbbs,"")                       /*[enter]            */
rc=lineout(dlbbs)
exit

 /**************************************************/
 /*            create Description-Files            */
 /**************************************************/

descname:
call RxFuncAdd "SysFileTree", "RexxUtil", "SysFileTree"

  /*Get Last Name, count number up*/

call sysfiletree descfilepath"\OF"node"*.LOG", "flist", "FO"
if flist.0>0 then do
  olddesc=right(flist.1,12)
"del "flist.1
  oldnum=substr(olddesc,5,4)
  thedesc=descfilepath"\OF"node""right(oldnum+1,4,'0')".LOG"
end
else thedesc=descfilepath"\OF"node"0000.LOG"

   /*generate file */

namewid=13
sizewid=6
datewid=10
linewid=75
leftwid=namewid+sizewid+datewid
descwid=linewid-leftwid

rc=lineout(thedesc,BBSName" Download-Log of: "date(dateformat)"  "time())
rc=lineout(thedesc,"Name          Size  Upload   Description")
rc=lineout(thedesc,"------------------------------------------------------------------------------")
filenum=0
line=linein(filelist)
do while line<>""
  fname=word(line,1)
    name=left(filespec("name",fname),namewid)
    size=format(word(line,2) / 1024,sizewid-1,0)"k"
    date=" "left(word(line,3),datewid-1)
    linedesc=delword(line,1,3)
    if substr(linedesc,1,1)="[" then  /*remove Dl-Counter (one word)*/
      linedesc=delword(linedesc,1,1)
    first=1
    do while first=1 | word(linedesc,1)<>"" /*do once for each wrapped line*/
      if first then do
        first=0
        leftspace=name""size""date""
      end
      else leftspace=left("",leftwid)
      i=0
      do while length(subword(linedesc,1,i+1))<descwid & word(linedesc,i+1)<>""
        i=i+1 /*count max words to fill one line*/
      end
      if i=0 then do /*cut word if too long*/
        thisline=substr(linedesc,1,descwid)
        linedesc=substr(linedesc,descwid+1,length(linedesc)-descwid)
      end
      else do
        thisline=subword(linedesc,1,i)
        linedesc=delword(linedesc,1,i)
      end
      rc=lineout(thedesc,leftspace""thisline)
    end
  line=linein(filelist)
end
rc=lineout(filelist)
rc=lineout(thedesc)

return thedesc /*return name*/
