/* -------------------------------------------------------------------- */
/* REXX procedure to demonstrate the RXANSI REXX extension              */
/*                                                                      */
/* To use locally, just enter 'RXANSI'.                                 */
/* To use remotely, pass the file handle of the comm port,              */
/* For MAXIMUS this would be ;                                          */
/*       [Extern_dos]CMD.EXE /C e:\rxansi\rxansi12\RXANSI %P            */
/*                                                                      */
/* See documentation for futher details                                 */
/*                                                                      */
/* -------------------------------------------------------------------- */

SIGNAL ON SYNTAX NAME usergone /* if remote & user hangsup, goto usergone. */

CALL init                      /* register extensions with REXX */  

rc = RxAnsiInit()              /* Set up ANSI variables */

ARG Commhndl
IF Commhndl = '' THEN         /* If remote user */
   rc = RxMode(MIXED,Commhndl) /* set mode to mixed */
ELSE			       /* but if local */
   rc = RxMouse(ON)            /* turn on mouse support */

CALL Setup                     /* display initial screen */  

DO FOREVER
   rc = RxGoTo(x,y)	       /* position cursor */
   ch = RxGetChar()	       /* get user input */
   IF (ch = 'ESCAPE') & (ch = 'BUTTON_2') THEN  /* if it's not escape.. */
      IF LENGTH(ch) = 1 THEN DO   /* and it's a single character.. */
         Rc = RxPutChars(ch) 	  /* display it */
	 y = y + 1		  /* and step on to next column */
      END
      ELSE 
         CALL Movecursor	  /* must be a cursor control command */
   ELSE 
     CALL dispmenu	       /* Escape hit - go show some menus */
END


/* --------------------------------------------------------------------- */
/* Remote user has hung up - tell host and quit                          */
/* --------------------------------------------------------------------- */
usergone:
  IF lastkey = 'USER GONE' THEN
     SAY 'User gone'
  ELSE
     SAY 'Bug in your Rexx procedure'
  CALL term
  RETURN

/* --------------------------------------------------------------------- */
/* Register all the functions to REXX                                    */
/* --------------------------------------------------------------------- */
init : procedure
CALL RxFuncAdd 'RXANSIINIT','RXANSI','RXANSIINIT'
CALL RxFuncAdd 'RXGOTO',    'RXANSI','RXGOTO'
CALL RxFuncAdd 'RXMODE',    'RXANSI','RXMODE'
CALL RxFuncAdd 'RXMOUSE',   'RXANSI','RXMOUSE'
CALL RxFuncAdd 'RXLINE',    'RXANSI','RXLINE'
CALL RxFuncAdd 'RXLINETYPE','RXANSI','RXLINETYPE'
CALL RxFuncAdd 'RXHMENU',   'RXANSI','RXHMENU'
CALL RxFuncAdd 'RXVMENU',   'RXANSI','RXVMENU'
CALL RxFuncAdd 'RXBOX',     'RXANSI','RXBOX'
CALL RxFuncAdd 'RXGETCHAR', 'RXANSI','RXGETCHAR'
CALL RxFuncAdd 'RXGETCHARS','RXANSI','RXGETCHARS'
CALL RxFuncAdd 'RXPUTCHARS','RXANSI','RXPUTCHARS'
RETURN

/* --------------------------------------------------------------------- */
/* Display initial screen plus sales pitch!                              */
/* --------------------------------------------------------------------- */
Setup:
rc = RxPutChars(white on_black cls)
rc = RxLineType(S,D)                   /* Set line type &       */  
rc = RxBox(2,1,23,80)                  /* Draw Box round screen */

IF commhndl = '' THEN                 /* If remote user, ESCAPE is two */   
DO                                     /* hits of esc.key, so tell them */      
   rc = RxGoTo(24,65)
   rc = RxPutChars(intense yellow 'ESC+ESC = Menu' reset)
END
ELSE
DO
   rc = RxGoTo(24,69)
   rc = RxPutChars(intense yellow 'ESC = Menu' reset)
END

/* Display sales pitch */
rc = RxGoTo(5,60)
rc = RxPutChars(Intense Yellow '     RxANSI' reset)
rc = RxGoTo(6,60)
rc = RxPutChars(Intense Yellow 'Version 1.2' reset)
rc = RxGoTo(8,15)
rc = RxPutChars(intense 'Features available in version 1.2 include ;' ) 
rc = RxGoTo(9,15)
rc = RxPutChars(Blue 'o ' cyan 'Horizontal and vertical menus' ) 
rc = RxGoTo(10,15)
rc = RxPutChars(Blue 'o ' cyan 'Local and remote access' ) 
rc = RxGoTo(11,15)
rc = RxPutChars(Blue 'o ' cyan 'Box and Line drawing commands' ) 
rc = RxGoTo(12,15)
rc = RxPutChars(Blue 'o ' cyan 'Mouse Support' reset) 
rc = RxGoTo(14,15)
rc = RxPutChars(White 'This is a mockup of an editor, as an example of what' ) 
rc = RxGoTo(15,15)
rc = RxPutChars(White 'is achievable with a simple REXX procedure and RXANSI. ' ) 
rc = RxGoTo(17,15)
rc = RxPutChars(White 'Have a play around with the cursor and mouse, use the' ) 
rc = RxGoTo(18,15)
rc = RxPutChars(White 'menus, enter text and see what you think - don''t worry,' ) 
rc = RxGoTo(19,15)
rc = RxPutChars(White 'none of the options do anything.' ) 
rc = RxGoTo(21,35)
rc = RxPutChars(intense yellow 'Enjoy !' reset ) 

/* Initialise a few variables. */
x = 3      
y = 2
fn = ''                            
RETURN

/* --------------------------------------------------------------------- */
/* Deal with cursor movement keys.                                       */
/* --------------------------------------------------------------------- */
Movecursor:
IF ch = 'HOME' THEN DO
   x = 3
   y = 2
END
IF ch = 'END' THEN DO
   x = 23
   y = 79
END
IF ch = 'RIGHT' THEN
   y = y + 1
IF ch = 'LEFT' THEN
   y = y - 1
IF ch = 'UP' THEN
   x = x - 1
IF ch = 'DOWN' THEN
   x = x + 1
IF ch = 'ENTER' THEN DO
   y = 1
   x = x + 1
END
IF ch = 'BUTTON_1' THEN DO
   y = mouse_y
   x = mouse_x
END
/* -------------------------- */
/* Ensure cursor is in bounds */
/* -------------------------- */
IF x < 3 THEN
   x = 3
IF x > 22 THEN
   x = 22
IF y < 2 THEN
   y = 2
IF y > 79 THEN
   y = 79
RETURN

/* --------------------------------------------------------------------- */
/* Display menus                                                         */
/* --------------------------------------------------------------------- */
dispmenu:
m1 = RxHMenu(1,1,File,Control,Search,Help)      /* draw menu */
menuno = WORDPOS(m1,'FILE CONTROL SEARCH HELP') /* Find entry */ 
IF (lastkey = 'ESCAPE') & (lastkey = 'BUTTON_2') THEN DO
   DO UNTIL (lastkey = 'ENTER') | (lastkey = 'BUTTON_1')
/*                              keep going till they choose an entry */  
      SELECT
       when menuno = 1 THEN	 /* Files menu */
          m2 = RxVMenu(2,3,'Edit','Save','Save As','New','Exit')
       when menuno = 2 THEN	 /* Control menu */
          m2 = RxVMenu(2,12,'Insert Line', 'Delete Line','Cut','Paste')
       when menuno = 3 THEN	 /* Search menu */
          m2 = RxVMenu(2,24,'Enter String', 'Search Again')
       when menuno = 4 THEN	 /* Help menu */
          m2 = RxVMenu(2,34,'File', 'Control', 'Search')
       OTHERWISE
      END
      rc = RxLine(2,2,2,79)         /* redraw top of screen */
      IF (lastkey = 'ESCAPE') | (lastkey = 'BUTTON_2') THEN 
        leave
   END

   IF (lastkey = 'ESCAPE') & (lastkey = 'BUTTON_2') THEN DO
      m1 = word('FILE CONTROL SEARCH HELP',menuno)   /* get offset of option */ 
      Rc = RxGoTo(24,1)
      SELECT
       When (M1 = FILE) THEN         /* If they chose FILE, process it */       
         CALL menufile
       When (M1 = CONTROL) | (M1 = SEARCH) | (M1 = HELP) THEN DO /* else do this */
         Rc = RxPutChars('OK. 'blue'(Hit any key to continue)'white)
         rc = RxGoTo(24,18)
         fn = RxGetChar()
         rc = RxGoTo(24,1)
         Rc = RxPutChars('                                                 ')
       END
       OTHERWISE
      END
   END
END
rc = RxGoTo(1,1)
rc = RxPutChars(On_black||copies(' ',80))      /* Remove Horizontal menu */                                             
RETURN


/* --------------------------------------------------------------------- */
/* Process File vertical menu                                            */
/* --------------------------------------------------------------------- */
menufile:
SELECT
  When (M2 = 'Edit') THEN DO         /* Make each option do something */
     Rc = RxPutChars('Enter Filename : ' On_blue)
     fn = RxGetChars(24,18,20,fn)
     rc = RxGoTo(24,1)
     Rc = RxPutChars(On_black '                                                 ')
  END
  When (M2 = 'Save') THEN DO
     Rc = RxPutChars('File Saved 'blue'(Hit any key to continue)'white)
     rc = RxGoTo(24,18)
     rc = RxGetChar()
     rc = RxGoTo(24,1)
     Rc = RxPutChars('                                                 ')
  END
  When (M2 = 'Save As') THEN DO
     Rc = RxPutChars('Enter Filename : ' On_blue)
     fn = RxGetChars(24,18,20,fn)
     rc = RxGoTo(24,1)
     Rc = RxPutChars(On_black '                                                 ')
  END
  When (M2 = 'New') THEN DO
     rc = RxPutChars(cls)
     rc = RxBox(2,1,23,80)
     IF commhndl = '' THEN DO
        rc = RxGoTo(24,65)
        rc = RxPutChars(intense yellow 'ESC+ESC = Menu' reset)
     END
     ELSE DO
        rc = RxGoTo(24,69)
        rc = RxPutChars(intense yellow 'ESC = Menu' reset)
     END
     fn = ''
  END
  When (M2 = 'Exit') THEN DO
     Rc = RxPutChars(white on_black) 
     rc = RxMouse(OFF)            /* turn off mouse support */
     CALL term
     EXIT
  END
  OTHERWISE
END
RETURN

/* --------------------------------------------------------------------- */
/* Deregister all the functions from REXX                                */
/* --------------------------------------------------------------------- */
term : procedure
CALL RxFuncDrop 'RXANSIINIT'
CALL RxFuncDrop 'RXGOTO'   
CALL RxFuncDrop 'RXMODE'   
CALL RxFuncDrop 'RXMOUSE'   
CALL RxFuncDrop 'RXLINE'   
CALL RxFuncDrop 'RXLINETYPE'   
CALL RxFuncDrop 'RXHMENU'  
CALL RxFuncDrop 'RXBOX'    
CALL RxFuncDrop 'RXGETCHAR'
CALL RxFuncDrop 'RXGETCHARS'
CALL RxFuncDrop 'RXPUTCHARS'
RETURN

 
