#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "DPMI.H"
#include "DPMIDOS.H"
#include "ADOSX16.H"

/*
** Copyright (c) Rainer Schnitker 91,92
**
**   ** MALLOC, FREE  from DPMI-memory for 16bit programs **
**
** - void set_memory_type(WORD type)
**      set memory allocation for extmalloc()
**	XMSLIMIT : limit DPMI-memory to XMS maximum
**	LOCKMEM  : Get DPMI-memory and lock this block
**
** - void far *extmalloc(DWORD nbytes)
**	get memory from DPMI-pool
**
** - void extfree(void far * p)
**	free memory block to DPMI-pool
**
** - void farcopy(void far * dest, void far * source, DWORD bytes)
** - int extmovedata(void far * source, void far * dest, DWORD nbytes)
**	copy blocks greater then 64 KB
**
*/

#define PAGESIZE 4096L
#define PAGESIZEHALF 2048L
#define NBUCKETS 9

static WORD limitxms = 0;
static WORD lockmem = 0;

static DWORD memory_use = 0;
static DWORD xms_max = 0;

static unsigned check_xms(void);

void set_memory_type(WORD type)
{
    if (!xms_max) {		/* first time */
	xms_max = (DWORD) check_xms() << 10;
	if (xms_max == 0)
	    xms_max = 0xFFFFFFFF;
    }
    if (type & XMSLIMIT)
	limitxms = 1;
    else
	limitxms = 0;

    if (type & LOCKMEM)
	lockmem = 1;
    else
	lockmem = 0;
}

union overhead {
    struct {
	WORD page;
	WORD offset;
    } free;
    struct {
	DWORD handle;
	/* memory handle for free() */
    } use;
};

static union overhead nextf[NBUCKETS];

union overhead far *morepages(WORD bucket)
{
    WORD nblks, i, page, nsel, nextpage, selinc;
    DWORD sz, handle, memaddress, news;
    union overhead far *pointer;

    if (bucket > 10)
	sz = (DWORD) (bucket - 10) * PAGESIZE;
    else
	sz = 1L << (bucket + 3);

    if (sz < PAGESIZE) {	/* 1st case : divide 4K-Page in sz-big blocks */
	if (limitxms && (memory_use + PAGESIZE > xms_max))
	    return NULL;
	else
	    memory_use += PAGESIZE;

	if (AllocMem(PAGESIZE, &handle, &memaddress) == -1)
	    return NULL;
	if (lockmem)
	    if (LockLinRegion(PAGESIZE, memaddress) == -1) {
		FreeMem(handle);
		return NULL;
	    }
	if (AllocLDT(1, &page) == -1) {	/* no more selectors ? */
	    FreeMem(handle);	/* free memory */
	    return NULL;
	}
	if (SetBaseAddress(page, memaddress) == -1) {
	    FreeMem(handle);
	    FreeLDT(page);
	    return NULL;
	}
	if (SetLimit(page, PAGESIZE - 1) == -1) {
	    FreeMem(handle);
	    FreeLDT(page);
	    return NULL;
	}
	nblks = (WORD) PAGESIZE / (WORD) sz;	/* number of pieces */
	nblks--;
	nextf[bucket].free.page = page;	/* freelist -> second block */
	nextf[bucket].free.offset = (WORD) sz;
	for (i = 1; i < (nblks); i++) {	/* fill header of blocks */
	    poke(page, i * sz, page);
	    poke(page, i * sz + 2, (i + 1) * sz);
	}
	poke(page, nblks * sz, 0);	/* last block -> NULL */
	poke(page, nblks * sz + 2, 0);
    }
     /* 1st case */ 
    else {			/* 2.nd case : order one selectors per 64 KB */
	if (limitxms && (memory_use + sz > xms_max))
	    return NULL;
	else
	    memory_use += sz;

	if (AllocMem(sz, &handle, &memaddress) == -1)
	    return NULL;
	if (lockmem)
	    if (LockLinRegion(PAGESIZE, memaddress) == -1) {
		FreeMem(handle);
		return NULL;
	    }
	nsel = (WORD) ((sz - 1L) >> 16);	/* nsel = number of selectors */
	nsel++;
	if (AllocLDT(nsel, &page) == -1) {	/* no more selectors? */
	    FreeMem(handle);	/* free memory */
	    return NULL;
	}
	if (sz > 0x10000L)
	    news = 0x10000L;	/* divide in 64KB */
	else
	    news = sz;
	nextpage = page;
	selinc = SelInc();
	for (i = 1; i <= nsel; i++) {
	    if (SetBaseAddress(nextpage, memaddress) == -1) {
		FreeMem(handle);
		FreeManyLDT(page, nsel);
		return NULL;
	    }
	    if (SetLimit(nextpage, (i == 1) ? sz - 1L : news - 1L) == -1) {
		FreeMem(handle);
		FreeManyLDT(page, nsel);
		return NULL;
	    }
	    memaddress += 0x10000L;
	    nextpage += selinc;	/* get next selector number */
	}
    }
    pointer = (union overhead far *) (MK_FP(page, 0));
    if (sz < PAGESIZE)
	pointer->use.handle = 0xFFFFFFFF;
    else
	pointer->use.handle = handle;

    return (pointer);
}

void far *extmalloc(DWORD nbytes)
{
    WORD bucket, amt;
    union overhead far *fp;

    if (nbytes == 0L)
	return NULL;
    nbytes += (DWORD) sizeof(union overhead);

    if (nbytes <= PAGESIZEHALF) {	/* >=2 fields in page */
	amt = 8;		/* bucket=0, 1, 2, 3, 4 , 5 , 6 , 7  , 8	*/
	bucket = 0;		/* <=>    8,16,32,64,128,256,512,1024,2048 */
	while ((WORD) nbytes > amt) {
	    amt <<= 1;
	    if (amt == 0L)
		return NULL;
	    bucket++;
	}
	if (nextf[bucket].free.page == 0) {	/* no mem in list */
	    fp = morepages(bucket);
	    if ((fp) == NULL)	/* no mem from dpmi */
		return NULL;
	} else {		/* mem available */
	    /* now : nextf[] -> myblock -> nextp */
	    /* fp -> myblock */
	    fp = (union overhead far *) MK_FP(nextf[bucket].free.page, nextf[bucket].free.offset);
	    /* nextf[] -> nextp */
	    nextf[bucket].free.page = fp->free.page;
	    nextf[bucket].free.offset = fp->free.offset;
	}
    } else {			/* nbytes > page/2  , alloc one or more pages */
	bucket = (WORD) ((nbytes - 1L) / 4096L) + 1;
	bucket += 10;		/* for morepages */
	fp = morepages(bucket);
	if (fp == NULL)
	    return NULL;
    }
    return ((void far *) (fp + 1));
}

void extfree(void far * p)
{
    union overhead far *fp;
    WORD bucket;
    DWORD n;
    DESCRIPTOR d;

    fp = (union overhead far *) p - 1;

    if (FP_OFF(p) != sizeof(union overhead) || fp->use.handle == 0xFFFFFFFF) {
	fp->free.page = nextf[bucket].free.page;
	fp->free.offset = nextf[bucket].free.offset;
	nextf[bucket].free.page = FP_SEG(fp);
	nextf[bucket].free.offset = FP_OFF(fp);
    } else {
	GetDescriptor(FP_SEG(p), &d);
	n = (DWORD) d.lim_lo | ((DWORD) (d.lim_hi & 15) << 16);
	if (d.lim_hi & GRANULAR_BIT)
	    n = n * PAGESIZE;
	n /= 0x10000;
	FreeMem(fp->use.handle);
	FreeManyLDT(FP_SEG(p), (WORD) n + 1);
    }
}



/*
**  - get the maximum of xms memory in dos box,
**    because dpmi get all system memory
**  - this value can used by ext_malloc with the function
**    set_memory_type(0/XMS_LIMIT/LOCKMEM)
**
*/

static void (far *xms_entry)(void) ;

static int xms_installed(void) {
    _asm mov ax,0x4300
    _asm int 0x2f
    _asm cmp al,0x80
    _asm je xms_present
    return 0;
    xms_present:
    return 1;
}

static void xms_get_entry(void) {
    _asm mov ax,0x4310
    _asm int 0x2f
    _asm mov word ptr xms_entry,bx
    _asm mov word ptr (xms_entry+2),es
}

static unsigned xms_extended_memory(void) {
    unsigned total_extended;

    _asm mov ah,0x08
    xms_entry();
    _asm mov total_extended,dx
    return total_extended;
}

unsigned check_xms(void) {
    WORD mem=0;

    /* xms call only in real mode !! */
    RealModeSwitch();
    if (xms_installed()) {
        xms_get_entry() ;
	mem = xms_extended_memory();
        }
    ProtectedModeSwitch();
    return mem;
}

void farcopy(void far * dest, void far * source, DWORD bytes)
{				/* farcopy for every pointer */
    unsigned long i;
    WORD inc;
    void far *s;
    void far *d;

    inc = SelInc();
    d = dest;
    s = source;

    for (i = 0; i < bytes; i++) {
	*((char far *) d) = *((char far *) s);
	FP_OFF(d)++;
	if (FP_OFF(d) == 0)
	    FP_SEG(d) = FP_SEG(d) + inc;
	FP_OFF(s)++;
	if (FP_OFF(s) == 0)
	    FP_SEG(s) = FP_SEG(d) + inc;
    }
}

int extmovedata(void far * source, void far * dest, DWORD nbytes)
{				/* faster farcopy for 2-byte align */
    void far *s;
    void far *d;
    WORD first, last, i, inc, n = 0;

    if (FP_OFF(dest) != FP_OFF(source))
	return -1;
    if (nbytes == 0L)
	return 0;

    inc = SelInc();
    d = dest;
    s = source;
    first = 0xFFFF - FP_OFF(source);
    first++;
    if (nbytes > (DWORD) first) {
	nbytes -= (DWORD) first;
	n = (WORD) (nbytes / 0x10000);
	last = (WORD) (nbytes % 0x10000);
    } else {
	last = 0;
	first = (WORD) nbytes;
    }

    movedata(FP_SEG(s), FP_OFF(s), FP_SEG(d), FP_OFF(d), first);
    FP_OFF(d) = 0;
    FP_OFF(s) = 0;
    for (i = 1; i <= n; i++) {
	FP_SEG(d) += inc;
	FP_SEG(s) += inc;
	movedata(FP_SEG(s), FP_OFF(s), FP_SEG(d), FP_OFF(d), 0xFFFF);
	*((char far *) d + 0xffff) = *((char far *) s + 0xffff);
    }
    if (last) {
	FP_SEG(d) += inc;
	FP_SEG(s) += inc;
	movedata(FP_SEG(s), FP_OFF(s), FP_SEG(d), FP_OFF(d), last);
    }
    return 0;
}
