#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

void CursorWait( void );
void CursorArrow( void );

//----------------------------------------------------------------------------//

CLIPPER MOVEWINDOW()
{
   HWND hWnd    = _parni( 1 );
   WORD wRow    = _parni( 2 );
   WORD wCol    = _parni( 3 );
   WORD wWidth  = _parni( 4 );
   WORD wHeight = _parni( 5 );
   RECT rct;

   if( ! _parni( 4 ) )
   {
      GetWindowRect( hWnd, &rct );
      wWidth  = rct.right - rct.left;
      wHeight = rct.bottom - rct.top;
   }

   _retl( MoveWindow( hWnd, wCol, wRow, wWidth, wHeight, _parl( 6 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER WNDCOPY()  //  hWnd        Copies any Window to the Clipboard!
{
   HWND hWnd = _parni( 1 );
   BOOL bAll = _parl( 2 );
   HDC  hDC  = GetDC( hWnd );
   WORD wX, wY;
   HDC  hMemDC;
   RECT rct;
   HBITMAP hBitmap, hOldBmp;

   CursorWait();

   if( bAll )
      GetWindowRect( hWnd, &rct );
   else
      GetClientRect( hWnd, &rct );

   wX = rct.right - rct.left + 1;
   wY = rct.bottom - rct.top + 1;

   if( GlobalCompact( 0 ) < ( wX * wY ) / 8 )
      MessageBox( 0, "Not enough memory", "Error", 0 );
   else
   {
      hMemDC  = CreateCompatibleDC( hDC );
      hBitmap = CreateCompatibleBitmap( hMemDC, wX, wY );
      hOldBmp = SelectObject( hMemDC, hBitmap );

      BitBlt( hMemDC, 0, 0, wX, wY, hDC, 0, 0, SRCCOPY );

      OpenClipboard( hWnd );
      EmptyClipboard();
      SetClipboardData( CF_BITMAP, hBitmap );
      CloseClipboard();

      SelectObject( hMemDC, hOldBmp );
      DeleteDC( hMemDC );
   }
   ReleaseDC( hWnd, hDC );
   CursorArrow();
}

//----------------------------------------------------------------------------//

CLIPPER BRINGWINDO() // WTOTOP( hWnd )  --> lSuccess
{
   _retl( BringWindowToTop( ( HWND ) _parni( 1 ) ) );
}

//----------------------------------------------------------------------------//
