// Managing Time Objects!
// (c) FiveWin - Data tools

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TTime

   DATA   nTime

   METHOD New( nHours, nMinutes, nSeconds ) CONSTRUCTOR

   METHOD System() CONSTRUCTOR

   METHOD AddHours( nHours )     INLINE ::nTime += ( nHours * 3600 )
   METHOD AddMinutes( nMinutes ) INLINE ::nTime += ( nMinutes * 60 )
   METHOD AddSeconds( nSeconds ) INLINE ::nTime += nSeconds

   METHOD cAdd( nHours, nMinutes, nSeconds )
   METHOD cSub( nHours, nMinutes, nSeconds )

   METHOD cGetTime()

   METHOD SysChange() INLINE SysTime( ::nTime )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nHours, nMinutes, nSeconds ) CLASS TTime

   DEFAULT nHours := 0, nMinutes := 0, nSeconds := 0

   ::nTime = If( nHours != 0, nHours * 3600, 0 ) + ;
             If( nMinutes != 0, ( nMinutes * 60 ), 0 ) + nSeconds
   ::nTime %= 86400

return nil

//----------------------------------------------------------------------------//

METHOD System() CLASS TTime

   local cTime := Time()

   ::nTime = ( Val( SubStr( cTime, 1, 2 ) ) * 3600 ) + ;
             ( Val( SubStr( cTime, 4, 2 ) ) *   60 ) + ;
               Val( SubStr( cTime, 7, 2 ) )
return nil

//----------------------------------------------------------------------------//

METHOD cAdd( nHours, nMinutes, nSeconds ) CLASS TTime

   local oTime := TTime():New( nHours, nMinutes, nSeconds )

   ::nTime += oTime:nTime
   ::nTime %= 86400

return ::cGetTime()

//----------------------------------------------------------------------------//

METHOD cSub( nHours, nMinutes, nSeconds ) CLASS TTime

   local oTime

   if ValType( nHours ) == "N"
      oTime = TTime():New( nHours, nMinutes, nSeconds )
   else
      oTime = nHours   // We have there an Object Time already
   endif

   ::nTime -= oTime:nTime
   ::nTime %= 86400

return ::cGetTime()

//----------------------------------------------------------------------------//

METHOD cGetTime() CLASS TTime

   local nTemp    := ::nTime
   local nHours   := Int( nTemp / 3600 )
   local nMinutes := nTemp - ( nHours * 3600 )
   local nSeconds := nMinutes % 60

return StrZero( nHours, 2 ) + ":" + StrZero( Int( nMinutes / 60 ), 2 ) + ":" + ;
       StrZero( nSeconds, 2 )

//----------------------------------------------------------------------------//
