#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function TxtOpen( cFileName )

   local oWndFile, oBrw, oIco, oBar
   local cAlias  := "ARRAY"
   local nField  := 1
   local oFile

   DEFAULT cFileName := cGetFile( "Ascii Text (*.txt) | *.txt",;
                                  "Select a TextFile" )

   if ! File( cFileName )
      MsgStop( "I can't find that file!" )
      return nil
   endif

   oFile = TFile():New( cFileName )

    if oFile:Open( 0 )

       DEFINE ICON oIco RESOURCE "Notes"

       DEFINE WINDOW oWndFile FROM 1, 43 TO 23, 79 ;
          TITLE "Text: " + cNoPath( cNoExt( cFileName ) ) MDICHILD ;
          ICON oIco

       DEFINE BUTTONBAR oBar OF oWndFile

       DEFINE BUTTON RESOURCE "Font" GROUP OF oBar ;
          ACTION oBrw:SelFont() ;
          MESSAGE "Select a new font"

       DEFINE BUTTON RESOURCE "Clr" OF oBar ;
          ACTION ( oBrw:SelColor(),;
                   If( oWndFile != nil,;
                   oWndFile:oControl:SetColor( oBrw:nClrText, oBrw:nClrPane ),) ) ;
          MESSAGE "Select a new backcolor"

       @ 2, 0 LISTBOX oBrw FIELDS "" ;
          HEADERS "" ;
          SIZES   600 ;
          SIZE 400, 400

       oBrw:bLine     = { || { oFile:ReadLn() } }
       oBrw:bLogicLen = { || oFile:LastRec() }
       oBrw:bGoTop    = { || oFile:GoTop() }
       oBrw:bGoBottom = { || oFile:GoBottom() }
       oBrw:bSkip     = { | nSkip, nOld | nOld := oFile:Recno(), oFile:Skip( nSkip ),;
                                    oFile:Recno() - nOld }

       oWndFile:SetControl( oBrw )

       ACTIVATE WINDOW oWndFile ;
          VALID ( oFile:Close(), oWndFile := nil, .t. )            // Destroy the Object
    else
       MsgInfo( "I can't open that file" )
    endif

return nil

//---------------------------------------------------------------------------//
