// Some more reports

#include "report.ch"
#include "FiveWin.ch"

STATIC oReport

//----------------------------------------------------------------------------//

Function Main()

     LOCAL oFont1, oFont2, oFont3

     DEFINE FONT oFont1 NAME "ARIAL" SIZE 0,-10
     DEFINE FONT oFont2 NAME "ARIAL" SIZE 0,-10 BOLD
     DEFINE FONT oFont3 NAME "ARIAL" SIZE 0,-10 BOLD ITALIC

     USE Customer ALIAS Test
     INDEX ON First TO Test
     SET INDEX TO Test
     GO TOP

     REPORT oReport ;
          TITLE  "*** LISTADO DE PRUEBA ***",;
                 "",;
                 OemtoAnsi("Ignacio Ortiz de Zuiga"),;
                 "" ;
          FONT   oFont1,;
                 oFont2,;
                 oFont3 ;
          HEADER "Fecha: "+dtoc(date()),;
                 "Hora:  "+time() ;
                 RIGHT ;
          FOOTER OemtoAnsi("Pgina: ")+str(oReport:nPage,3) ;
                 CENTERED ;
          TO PRINTER

     GROUP ON Test->State ;
           FOOTER "Total Estado "+oReport:aGroups[1]:cValue ;
           FONT 2

     COLUMN TITLE "ST" ;
          DATA Test->State ;
          FONT 2

     COLUMN TITLE "City" ;
          DATA Test->City

     COLUMN TITLE "First Name","Last Name" ;
          DATA Test->First, Test->Last

     COLUMN TITLE "   Salary" ;
          DATA Test->Salary ;
          PICTURE "9,999,999" ;
          SIZE 9 ;
          TOTAL ;
          RIGHT

     END REPORT

     /*
     Segunda linea del titulo en negrita
     */

     oReport:oTitle:aFont[1] := {|| 2 }

     /*
     Poner en italica  cuando el salario es mas de 100.000
     */

     oReport:aColumns[4]:bDataFont := {|| iif(Test->Salary>100000,3 ,1 ) }

     ACTIVATE REPORT oReport ON STARTPAGE Datos() ;
                             ON STARTGROUP oReport:NewLine()

RETURN NIL

Function Datos()

     local cText

     cText := "Ancho hoja    : "+str(oReport:nWidth)+CRLF
     cText += "Ancho listado : "+str(oReport:nRptWidth)+CRLF
     cText += "Margen Izquier: "+str(oReport:nLeftMargin)+CRLF
     cText += "Margen Derecho: "+str(oReport:nRightMargin)+CRLF
     cText += "Ancho del Font: "+str(oReport:aFont[1]:nWidth)+CRLF
     cText += "Alto del Font:  "+str(oReport:aFont[1]:nHeight)+CRLF
     cText += "Ancho Standard: "+str(oReport:nSeparator)+CRLF
     cText += "Ancho columna1: "+str(oReport:aColumns[1]:nWidth)+CRLF
     cText += "Ancho columna2: "+str(oReport:aColumns[2]:nWidth)+CRLF

     Alert(cText)

RETURN NIL




