// Sample showing how to use dialogs stored inside a DLL

#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   SET RESOURCES TO "TestRes.dll"

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 60 ;
      TITLE OemToAnsi( "Utilizacin de Recursos" ) ;
      MENU BuildMenu()

   SET MESSAGE OF oWnd ;
      TO OemToAnsi( "FiveWin 1.5 - (c) A.Linares, F. Pulpn, 1993" )

   ACTIVATE WINDOW oWnd ;
      ON PAINT DrawLogo( oWnd, "Borland" )

   SET RESOURCES TO

return

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM OemToAnsi( "&Informacin" )
      MENU
         MENUITEM "&Acerca de..."  ACTION MsgInfo( "TestRes", "FiveWin" )
         SEPARATOR
         MENUITEM "&Terminar"      ACTION ;
            If( MsgYesNo( OemToAnsi( " Desea terminar ?" ),;
                          OemToAnsi( "Atencin" ) ), oWnd:End(),)
      ENDMENU

      MENUITEM OemToAnsi( "&Cajas de Dilogo" )
      MENU
         MENUITEM "Caja &1 desde DLL"  ACTION CajaUno()
         MENUITEM "Caja &2 desde DLL"  ACTION CajaDos()
      ENDMENU

      MENUITEM "&Utilidades"
      MENU
         MENUITEM "&Calculadora" ACTION WinExec( "Calc" )
         MENUITEM "C&alendario"  ACTION WinExec( "Calendar" )
         SEPARATOR
         MENUITEM "&Escribir"    ACTION oWnd:Say( 20, 2, "FiveWin, que pasada!" )
      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function CajaUno()

   local oDlg
   local cNombre := "FiveWin"

   DEFINE DIALOG oDlg NAME "Primera"

   REDEFINE GET cNombre ID 110 OF oDlg

   REDEFINE BUTTON ID 120 OF oDlg ACTION nMsgBox( "Hola" )
   REDEFINE BUTTON ID 130 OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

   MsgInfo( "cNombre:= " + cNombre, "Resultado" )

return

//----------------------------------------------------------------------------//

function CajaDos()

   local oDlg
   local cNombre     := "Antonio y Francisco"
   local cObserva    := "Ninguna"
   local lUseFivewin := .t.
   local cProducto   := "Objects"
   local aProductos  := { "FivePro", "Dialog", "Objects", "FiveWin", "Simple",;
                          "Projects" }

   DEFINE DIALOG oDlg NAME "Segunda"

   REDEFINE GET cNombre ID 110 OF oDlg
   REDEFINE LISTBOX cProducto ITEMS aProductos ID 120 OF oDlg
   REDEFINE GET cObserva ID 130 OF oDlg
   REDEFINE CHECKBOX lUseFiveWin ID 140 OF oDlg

   REDEFINE BUTTON ID 150 OF oDlg ACTION nMsgBox( "Aceptar" )
   REDEFINE BUTTON ID 160 OF oDlg ACTION nMsgBox( "Cancelar" )
   REDEFINE BUTTON ID 170 OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

   MsgInfo( "cNombre := " + cNombre, "Resultado" )
   MsgInfo( "lUseFiveWin := " + If( lUseFiveWin, ".T.", ".F." ), "Resultado" )
   MsgInfo( "cProducto := " + cProducto )

return

//----------------------------------------------------------------------------//

function DrawLogo( oWnd, cBitMap )

   local hBmp := LoadBitmap( GetResources(), cBitmap )
   
   DrawBitmap( oWnd:hDC, hBmp, 20, 20 )
   
   DeleteObject( hBmp )
   
return   

//----------------------------------------------------------------------------//
