// This sample shows how to create a Management Menu whit ButtonBar and Menu.

#include "FiveWin.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   local oBrush, oBar

   DEFINE BRUSH oBrush STYLE TILED

   DEFINE WINDOW oWnd FROM 1, 5 TO 20, 65 ;
      TITLE "FiveWin ButtonBar & Menu Management" ;
      BRUSH oBrush ;
      MENU  BuildMenu()

   DEFINE BUTTONBAR oBar BUTTONSIZE 33, 33 3D LEFT OF oWnd

   DEFINE BUTTON OF oBar FILE "..\bitmaps\cara.bmp"     MESSAGE "Create a new project" ;
      ACTION MsgInfo( "New Project", "Information" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\OpenPrj.bmp" MESSAGE "Open a previous project" ;
      ACTION MsgStop( "Open Project", "Stop" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\SavePrj.bmp" MESSAGE "Save this project" ;
      ACTION MsgAlert( "Save this project", "Hey!" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\Exit.bmp"    MESSAGE "End this session" ;
      ACTION If( MsgYesNo( "Do you want to end ?", "Please Select" ),;
                 oWnd:End(), )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\Cut.bmp"     MESSAGE "Cut to ClipBoard" GROUP ;
      ACTION MsgInfo( "You can easily call your functions from the ButtonBar",;
                      "Well, this is FiveWin" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\Copy.bmp"    MESSAGE "Copy to ClipBoard" ;
      ACTION MsgStop( "FiveWin automatically will execute your actions",;
                      "Go for productivity!" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\Paste.bmp"   MESSAGE "Paste from ClipBoard" ;
      ACTION MsgAlert( "It's time for OOPS & xBase Power!" + Chr( 13 ) + ;
                       "It provides over 50 new Clipper real Classes" + Chr( 13 ) + ;
                       "using xBase Commands to encapsulate complexity!",;
                       "FiveWin is really Clipper 5 & xBase" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\Calendar.bmp" MESSAGE "Calling Windows Calendar" ;
      ACTION WinExec( "Calendar" ) GROUP

   DEFINE BUTTON OF oBar FILE "..\bitmaps\ClipBoar.bmp" MESSAGE "Looking at ClipBoard" ;
      ACTION WinExec( "Clipbrd" )

   DEFINE BUTTON OF oBar FILE "..\bitmaps\Help.bmp" MESSAGE "Windows Help" ;
      ACTION WinHelp( "progman.hlp" )

   SET MESSAGE OF oWnd TO FWVERSION + "-" + FWCOPYRIGHT CENTERED

   ACTIVATE WINDOW oWnd

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Information"
      MENU
         MENUITEM "About..." MESSAGE "About FiveWin" ;
            ACTION MsgAbout( FWVERSION, FWCOPYRIGHT )

         SEPARATOR

         MENUITEM FILE "End.bmp" MESSAGE "End this session" ;
            ACTION If( MsgYesNo( "Do you want to end ?", "Please select" ),;
                       oWnd:End(), )
      ENDMENU

      MENUITEM "&Files"
      MENU
         MENUITEM "&Clients"
         MENU
            MENUITEM "&New..."      MESSAGE "Add a new Client" ;
               ACTION MsgInfo( "New Client", "Call here your functions..." )

            MENUITEM "&Modify..."   MESSAGE "Modify the information"
            MENUITEM "what ever..." MESSAGE "FiveWin is so easy!"
         ENDMENU

         MENUITEM "&Stocks"
      ENDMENU

      MENUITEM "&Utilities"
      MENU
         MENUITEM FILE "..\bitmaps\Calc.bmp" MESSAGE "Calling calculator" ;
            ACTION WinExec( "Calc" )

         MENUITEM FILE "..\bitmaps\FiveWin.bmp" ;
            ACTION MsgInfo( FWVERSION,;
                            "The xBase & Windows revolution!" )
      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//
