// Developed by a FiveWin user

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

CLASS TComm

        DATA nDevice, nInQueue, nOutQueue, nId, nStop, nBaud, nData, nErr
        DATA cParity, cStyle, cChar
        DATA aStatus

        METHOD Break() BLOCK { |Self| IIF( SetCommBreak( ::nId ) < 0, ;
                                        MsgInfo( "Error al bloquear el puerto de comunicaciones" ), ) }

  METHOD Close() BLOCK { |Self| IIF( CloseComm( ::nId ) < 0, ;
                                        MsgInfo( "Error intentando cerrar el puerto de comunicaciones" ), ) }

  METHOD Error()

  METHOD Escape( nCode ) BLOCK { |Self,nCode| IIF( EscapeCommFunction( ::nId, nCode ) < 0, ;
                                        MsgInfo( OemToAnsi( "Error enviando cdigo de escape" ) ), ) }

  METHOD Flush( nQueue ) BLOCK { |Self,nQueue| IIF( FlushComm( ::nId, nQueue ) != 0, ;
                                        MsgInfo( "Error al vaciar el buffer de las comunicaciones" ), ) }

  METHOD New( nDevice, nInQueue, nOutQueue, cStyle ) CONSTRUCTOR

  METHOD SetUp()

  METHOD UnBreak() BLOCK { |Self| IIF( ClearCommBreak( ::nId ) < 0, ;
                                        MsgInfo( "Error desbloqueando el puerto de comunicaciones" ), ) }

  METHOD Write( cString )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nDevice, nInQueue, nOutQueue, cStyle, nBaud, cParity, nStop, nData ) CLASS TComm
        DEFAULT cStyle := "COM", nInQueue := 1024, nOutQueue := 128, nDevice := 1, ;
                        nBaud := 9600, cParity := "n", nStop := 1, nData := 8

        ::nDevice   := nDevice
        ::nInQueue  := nInQueue
        ::nOutQueue := nOutQueue
        ::cStyle    := cStyle
        ::nBaud     := nBaud
        ::cParity   := cParity
        ::nStop     := nStop
        ::nData         := nData

        ::nId := OpenComm( cStyle + ALLTRIM( STR( nDevice ) ), nInQueue, nOutQueue )

        IIF( ::nId < 0, MsgInfo( "Error al inizializar las comunicaciones" + CHR(13) + ;
                                                        OemToAnsi( "Nmero del error --> " ) + ALLTRIM( STR( ::nId ) ) ), )
return NIL

METHOD Error() CLASS TComm
        ::aStatus := GetError( ::aStatus )
return NIL

METHOD SetUp() CLASS TComm
        LOCAL cString
        cString := ::cStyle + ALLTRIM( STR( ::nDevice ) ) + ":" +  ALLTRIM( STR( ::nBaud ) ) + "," + ;
                        ::cParity + "," + ALLTRIM( STR( ::nData ) ) + "," + ALLTRIM( STR( ::nStop ) )
        IF !ConfComm( cString )
                MsgInfo( "Error al configurar el puerto de comunicaciones" )
        ENDIF
return NIL

METHOD Write( cString ) CLASS TComm
        ::nErr := WriteComm( ::nId, cString )
        IF ::nErr < 0
                MsgInfo( "Error al escribir datos" + CHR(13) +;
                                "Datos escritos --> " + ALLTRIM( STR( ABS( ::nErr ) ) ) )
        ENDIF
return NIL

