// Windows RC to PRG file conversor utility - Developed by our friend Oliver

#define WINDOWS
#ifdef WINDOWS
#include 'L:\fw16b\include\Fivewin.Ch'
#endif
#define CRLF chr(13)+chr(10)
#define CRSM " ;"+chr(13)+chr(10)
#define TAB space(8)
#define FNTX 14
#define FNTY 7
STATIC aVars  := {}
STATIC aLines := {}

#ifdef WINDOWS
STATIC oWndMain
STATIC oMeter
STATIC nTotal := 0

Function Main()
#ifdef WINDOWS
DEFINE WINDOW oWndMain FROM 10,10 TO 20, 50 TITLE "Ressourcen-Compiler"

WndCenter(oWndMain:hWnd)

@4, 5 METER oMeter VAR nTotal ;
      TOTAL 100 ;
      SIZE 200,20 ;
      OF oWndMain

ACTIVATE WINDOW oWndMain ON INIT AnzFile()
oWndMain:End()

#else
Function Main(cFile, cPara)

AnzFile(cFile, cPara)

#endif

Return 0
//----------------------------------------------------------------------------//
#ifdef WINDOWS
Function AnzFile()
#else
Function AnzFile(cFile, cPara)
#endif
   LOCAL cFileIn
   LOCAL cFileOut
   LOCAL nIHdl
   LOCAL nOHdl
   LOCAL nBlen := 256
   LOCAL cBuff := space(256)
   LOCAL cLine
   LOCAL nRead
   LOCAL nAt
   #ifdef WINDOWS
   LOCAL cFile  := ""
   LOCAL lNoDoc := .t.
   LOCAL nFileSize := 0

   cFile := cGetFile("Ressourcendatei | *.rc", OemToAnsi("Ressource auswhlen"))

   cFile := Substr(cFile,1,rat(".", cfile)-1)
   #else
   LOCAL lNoDoc := pcount() > 1
   #endif

   cFile := alltrim(cFile)
   cFileIn  := cFile+".RC"
   cFileOut := cFile+".PRG"

   if (nIHdl := fopen(cFileIn)) > 0
      oMeter:nTotal := (nFileSize := fseek(nIHdl,0,2))
      Fseek(nIHdl,0,0)
      if (nOhdl := fcreate(cFileout)) > 0
         fWrite(nOhdl, '#include "FiveWin.Ch"'+CRLF+CRLF)
         while (nRead := fread(nIhdl, @cBuff, nBlen)) > 0
             if (nAt := at(chr(13), cBuff)) > 0
                cLine := substr(cBuff,1,nAt-1)
                fseek(nIHdl,nAt-nRead+1,1)
             else
                cLine := cBuff
             endif
             #ifdef WINDOWS
             nTotal += len(cLine)+2
             oMeter:Set(nTotal)
             oMeter:Paint()
             SysRefresh()
             #endif
             AnzLine(cLine, nOHdl, lNoDoc)
             cBuff := space(nBlen)
         enddo
      endif
      fclose(nOHdl)
      #ifdef WINDOWS
      MsgInfo("Datei "+cFileOut+" erstellt.")
      oWndMain:End()
      #endif
   endif
   fclose(nIHdl)

RETURN 0

Function AnzLine(cLine, nOhdl, lNoDoc)
   #ifdef WINDOWS
   STATIC oFont
   #endif
   STATIC cDlg    := ""      // Dialogname
   STATIC cFont   := ""      // Dialogfont
   STATIC nFont   := 0       // Dialogfontsize
   STATIC cCaption:= ""      // Dialog Title
   STATIC aValues := {}      // Values of each Line
   STATIC lFunc   := .f.     // Function header written

   LOCAL cMain    := ""      // Main code identifier
   LOCAL cCode    := ""      // Local code
   LOCAL nAt      := 0

   LOCAL cOut    := ""      // Output line
   // LOCAL aFont   := {-21,0,0,0,400,.f.,.f.,0,3,2,1,34,"Arial"}

   cLine := ltrim(cLine)
   if !lNoDoc
      aadd(aLines, "// " + cLine + CRLF )
   endif

   If " DIALOG " $ cLine .and. empty(cDlg)  // Get Dialog name
      aValues := {}
      cDlg    := substr(cLine,1,at(" ", cLine)-1)
      cLine   := ","+substr(cLine, at("DIALOG", cLine)+7)
      cMain   := "DIALOG"
   endif

   if 'CAPTION "' $ cLine .and. empty(cCaption)
       cCaption := rtrim(substr(cLine, at("CAPTION", cLine)+8))
       cMain := "CAPTION"
       cLine    := ""
   endif

   if 'FONT ' $ cLine .and. empty(cFont) .and. !empty(cDlg)
       nFont := val(rtrim(substr(cLine, at('FONT', cLine)+5)))
       cFont := alltrim(substr(cLine,at(',', cLine)+1))
       cFont := substr(cFont,2,len(cFont)-2)
       cMain := "FONT"
       cLine := ""
   endif
   while len(cLine) > 0
      if empty(cMain)
         if (nAt := at(" ",cLine)) > 0
            cMain := substr(cLine,1,nAt-1)
            cLine := ","+substr(cLine,nAt+1)
         else
            cMain := cLine
            cLine := ""
         endif
         if substr(cMain,1,1) == chr(9)
            cMain := substr(cMain,2)
         endif
      else
         if (nAt := at(",", cLine)) > 0
            cCode := substr(cLine,1,nAt-1)
            cLine := substr(cLine,nAt+1)
         else
            cCode := cLine
            cLine := ""
         endif
         aadd(aValues, cCode)
      endif
   end
   // Analyze codes
   #ifndef WINDOWS
   ? "["+cMain+"]"
   #endif
   do case
   case empty(cDlg)         // Do nothing while no Dialog found
   case cMain == "DIALOG"  .and. !empty(cDlg) .and. !lFunc
      Aadd(aLines, "FUNCTION "+cDlg+"()"+CRLF)
      Aadd(aVars,"o"+cDlg)
      lFunc := .t.
   case cMain == "CAPTION" .and. !empty(cDlg)
   case cMain == "FONT"    .and. !empty(cDlg)
      cOut  := "DEFINE FONT oFnt"+cFont+ ' NAME "' + cFont +'"'+ CRSM +;
               TAB+"SIZE "+ltrim(str(nFont)) +", "+ltrim(str(nFont*2))
      aadd(aVars, "oFnt"+cFont)
   case cMain == "BEGIN"   .and. !empty(cDlg) // Start writing Dialog clause
      cOut := 'DEFINE DIALOG o'+cDlg+ CRSM +;
              TAB+'FROM ' + aValues[3] + ',' + aValues[2] +;
              ' TO '      + xCo(aValues[3], aValues[5] ) + ','+ ;
                            yCo(aValues[2], aValues[4] ) + CRSM +;
              TAB+'TITLE '+cCaption + CRSM+;
              TAB+"PIXEL"+CRLF

              aValues := {}
   case cMain == "END"     .and. !empty(cDlg)
      aadd(aLines, "ACTIVATE DIALOG o"+cDlg+CRLF)
      aadd(aLines, "RETURN 0"+CRLF+CRLF+"//"+replicate("-",78)+CRLF+CRLF)

      // Write accumulated vars (e.g. EDITTEXT)
      #ifndef WINDOWS
      ? "Writing:"
      ? "Header"
      #endif
      fwrite(nOhdl,aLines[1])
      #ifndef WINDOWS
      ? "Vars "
      #endif
      for nAt := 1 TO len(aVars)
          fwrite(nOhdl, "LOCAL "+aVars[nAt] + CRLF)
          #ifndef WINDOWS
          ?? "."
          #endif
      next

      // Write accumulated lines
      #ifndef WINDOWS
      ? "Instructions "
      #endif
      for nAt := 2 to Len(aLines)
          fwrite(nOhdl, aLines[nAt] )
          #ifndef WINDOWS
          ?? "."
          #endif
      next

      // Reset main Static values
      aLines  := {}
      aVars   := {}

      // Reset local Static values to begin new Dialog
      cDlg    := ""
      cFont   := ""
      nFont   := 0
      cCaption:= ""
      aValues := {}

      lFunc := .f.
   case cMain == "PUSHBUTTON"
      cOut := '@ '+ aValues[5]+', '+ aValues[4] + ' BUTTON '+ aValues[2]+ CRSM+;
              TAB+'SIZE '+aValues[6]+', '+aValues[7] + CRSM +;
              TAB+'OF o'+cDlg+ CRSM + ;
              TAB+'FONT oFnt'+cFont+CRSM+ ;
              TAB+"PIXEL"+CRLF
      aValues := {}
   case cMain == "LISTBOX"
      cOut := "@ "+aValues[4]+","+aValues[3]+;
               " LISTBOX oLbx"+ltrim(aValues[2])+CRSM+;
               TAB+" SIZE"+aValues[5]+", "+aValues[6]+CRSM+;
               TAB+'OF o'+cDlg+ CRSM + ;
               TAB+'FONT oFnt'+cFont+CRSM+ ;
               TAB+"PIXEL"+CRLF
      aadd(aVars, "oLbx"+ltrim(aValues[2]))
      aValues := {}
   case cMain == "LTEXT"
      cOut := '@ '+ aValues[5] +', '+ aValues[4] +' SAY '+;
              aValues[2] +' OF o'+cDlg+ CRSM + ;
              TAB+'FONT oFnt'+cFont+CRSM+ ;
              TAB+"PIXEL"+CRLF

      aValues := {}
   case cMain == "COMBOBOX"
      cOut := '@ '+ aValues[5] +', '+ aValues[4] +' COMBOBOX oCbx' +;
              aValues[2] + CRSM +;
              TAB+'SIZE '+aValues[6]+', '+ aValues[7] +CRSM+;
              TAB+'OF o'+cDlg+ CRSM + ;
              TAB+'FONT oFnt'+cFont+CRSM+ ;
              TAB+"PIXEL"+CRLF

      aadd(aVars, "oCbx"+aValues[2])
      aValues := {}
   case cMain == "CONTROL"
      cOut := "// Control:"
      aeval(aValues, {|a| cOut += " ["+a+"]"})
      cOut+= CRLF
      do case
      case alltrim(aValues[4]) == '"COMBOBOX"'

         cOut := "@ "+aValues[7]+","+aValues[6]+;
                  " COMBOBOX oCbx"+ltrim(aValues[3])+CRSM+;
                  TAB+" SIZE"+aValues[8]+", "+aValues[9]+CRSM+;
                  TAB+'OF o'+cDlg+ CRSM + ;
                  TAB+'FONT oFnt'+cFont+CRSM+ ;
                  TAB+"PIXEL"+CRLF
         aadd(aVars, "oCbx"+ltrim(aValues[3]))

      case alltrim(aValues[4]) == '"LISTBOX"'

         cOut := "@ "+aValues[7]+","+aValues[6]+;
                  " LISTBOX oLbx"+ltrim(aValues[3])+CRSM+;
                  TAB+" SIZE"+aValues[8]+", "+aValues[9]+CRSM+;
                  TAB+'OF o'+cDlg+ CRSM + ;
                  TAB+'FONT oFnt'+cFont+CRSM+ ;
                  TAB+"PIXEL"+CRLF
         aadd(aVars, "oLbx"+ltrim(aValues[3]))
      endcase
      aValues := {}
   case cMain == "EDITTEXT"
      cOut := '@ '+ aValues[4] +', '+ aValues[3] + ' GET o'+;
              aValues[2] + ' VAR x'+aValues[2] + CRSM+;
              TAB+'SIZE '+ aValues[5] + ', '+ aValues[6] + CRSM+;
              TAB+'OF o'+cDlg+ CRSM +;
              TAB+'FONT oFnt'+cFont+CRSM +;
              TAB+"PIXEL"+CRLF
      aadd(aVars, 'o'+aValues[2])
      aadd(aVars, 'x'+aValues[2])
      aValues := {}
   case cMain == "ICON"
      cOut := '@'+ xCo(aValues[5])+', '+xCo(aValues[4]) +;
              ' ICON oIco'+substr(aValues[2],2,len(aValues[2])-2)+ CRSM +;
              TAB+'RESOURCE '+aValues[2] + CRSM +;
              TAB+'OF o'+cDlg+ CRLF + CRLF +;
              'oIco'+substr(aValues[2],2,len(aValues[2])-2)+":nWidth  := "+;
                   aValues[6]+CRLF +;
              'oIco'+substr(aValues[2],2,len(aValues[2])-2)+":nHeight := "+;
                   aValues[7]+CRLF+CRLF

      aadd(aVars,'oIco'+substr(aValues[2],2,len(aValues[2])-2))
      aValues := {}
   endcase
   if !empty(cOut)
      aadd(aLines, cOut + CRLF)
   endif
Return NIL

//--------------------------------------------------------------//
// Dialog-Coordinates

Function xCo(c,x)
if x == NIL
   return Ltrim(str((Val(c)*FNTX)/8,6,0))
endif
return Ltrim(str(val(c)+(((Val(c)+Val(x))*FNTX)/8),6,0))


Function yCo(c,x)
if x == NIL
   return Ltrim(str((Val(c)*FNTY)/4,6, 0))
endif
return Ltrim(str(val(c)+(((Val(c)+Val(x))*FNTY)/4),6,0))
