#include "FiveWin.ch"
#include "Constant.ch"

#define BM_GETCHECK         (WM_USER+0)
#define BM_SETCHECK         (WM_USER+1)
#define LTGRAY_BRUSH                  1

#define GCW_HCURSOR               (-12)

//----------------------------------------------------------------------------//

CLASS TRadio FROM TControl

   DATA   lChecked             // to init correctly its state
   DATA   oRadMenu
   DATA   nPos

   METHOD New( nRow, nCol, cCaption, lGroup, lChecked, nPos, oWnd, oRadMenu,;
               nHelpId, nClrText, nClrPane, cMsg, lUpdate, bWhen,;
               nWidth, nHeight, bValid ) CONSTRUCTOR

   METHOD Redefine( nID, lChecked, nPos, oDlg, oRadMenu, ;
                    nHelpID, nClrText, nClrPane, cMsg,;
                    lUpdate, bWhen, bValid ) CONSTRUCTOR

   METHOD Click()    INLINE  ::oRadMenu:nOption := ::nPos, Super:Click()
   METHOD cToChar()  INLINE  Super:cToChar( "BUTTON" )

   METHOD Init( hDlg ) INLINE  Super:Init( hDlg ),;
                               ::SetCheck( ::lChecked )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD SetCheck( lOnOff ) INLINE  ::lChecked := lOnOff,;
                               ::SendMsg( BM_SETCHECK, If( lOnOff, 1, 0 ) )

   METHOD lIsChecked() INLINE  ::lChecked := ( ::SendMsg( BM_GETCHECK ) == 1 )

   METHOD Default()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nRow, nCol, cCaption, lGroup, lChecked, nPos, oWnd, oRadMenu,;
            nHelpId, nClrText, nClrPane, cMsg, lUpdate, bWhen, nWidth,;
            nHeight, bValid ) CLASS TRadio

   DEFAULT lChecked := .f., lGroup := .f., nPos := 1,;
           nHelpId := 100, lUpdate := .f.

   ::nTop      = nRow * If( nHeight != nil, nHeight, RAD_CHARPIX_H )  // 13
   ::nLeft     = ( nCol * RAD_CHARPIX_W ) + 4  //  7
   ::nBottom   = ::nTop + If( nHeight != nil, nHeight, 12 )
   ::nRight    = ::nLeft + If( nWidth != nil, nWidth, ( Len( cCaption ) * 5 ) )
   ::cCaption  = cCaption
   ::nStyle    = nOR( WS_CHILD, WS_VISIBLE, BS_AUTORADIOBUTTON,;
                      If( lGroup, WS_GROUP, 0 ) )
   ::nId       = ::GetNewId()
   ::nHelpId   = nHelpId
   ::lChecked  = lChecked
   ::nPos      = nPos
   ::oWnd      = oWnd
   ::oRadMenu  = oRadMenu
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::cMsg      = cMsg
   ::lUpdate   = lUpdate
   ::bWhen     = bWhen
   ::bValid    = bValid

   ::SetColor( nClrText, nClrPane )

   if ! Empty( oWnd:hWnd )
      ::Create( "BUTTON" )
      ::Default()
      oWnd:AddControl( Self )
   else
      oWnd:DefControl( Self )
   endif

return nil

//---------------------------------------------------------------------------//

METHOD Redefine( nID, lChecked, nPos, oDlg, oRadMenu, nHelpID, nClrText,;
                 nClrPane, cMsg, lUpdate, bWhen, bValid ) CLASS TRadio

   DEFAULT lChecked := .f., nPos := 1,;
           nHelpId := 100, lUpdate := .f.

   ::nId       = nID
   ::nHelpId   = nHelpId
   ::oWnd      = oDlg
   ::oRadMenu  = oRadMenu
   ::lChecked  = lChecked
   ::nPos      = nPos
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::cMsg      = cMsg
   ::lUpdate   = lUpdate
   ::bWhen     = bWhen
   ::bValid    = bValid

   ::SetColor( nClrText, nClrPane )

   oDlg:DefControl( Self )

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TRadio

   local nResult := Super:MouseMove( nRow, nCol, nKeyFlags )

return If( ::lDrag, nResult, nil )    // We want standard behavior !!!

//----------------------------------------------------------------------------//

METHOD Default() CLASS TRadio

   if ::lChecked
      ::SetCheck( .t. )
      ::SetFocus()
   endif

return nil

//----------------------------------------------------------------------------//
