#include "FiveWin.ch"
#include "sql.ch"
#include "Set.ch"

//----------------------------------------------------------------------------//

CLASS OdbcStmt

   DATA   hStmt                   AS NUMERIC PROTECTED
   DATA   oOdbc
   DATA   aFields
   DATA   nRetorno
   DATA   cLastComm   

   METHOD New( oOdbc ) CONSTRUCTOR

   METHOD Execute( cCommand )

   METHOD odbcFName( nField )

   METHOD odbcField( nField )

   METHOD odbcFType( nField )

   METHOD odbcFLen( nField )

   METHOD odbcFDec( nField )

   MESSAGE FCount METHOD _FCount()

   METHOD End()

   METHOD odbcFGet( nField )

   METHOD InitFields()

   METHOD LastError()

   METHOD Skip()
   
   METHOD LastComman() INLINE (::cLastComm)
   
   METHOD SetOptions( nType, uBuffer)
   
   METHOD GetOptions( nType)
   
   METHOD SetCurName( cName )

   METHOD GetCurName( )
   
   METHOD RowCount( )
   
   METHOD Cancel()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( oOrigen ) CLASS OdbcStmt

   local nret
   local hStmt

   ::nRetorno := 0

   if oOrigen==nil
      ::nretorno:=1000
      return nil
   else
      ::oOdbc:=oOrigen
   endif

   if (nret:=SQLAllocStmt( ::oOdbc:hDbc, @hStmt )) == SQL_SUCCESS
      ::hStmt = hStmt
   else
      ::nretorno:=nret
      MsgStop( "SQLALLOCSTMT No se puede crear el statement para el ODBC" )
      return nil
   endif


return 0

//----------------------------------------------------------------------------//

METHOD End() CLASS OdbcStmt

   SQLFreeStmt( ::hStmt, SQL_DROP )

   ::hStmt = 0

return nil

//----------------------------------------------------------------------------//

METHOD Execute(cCommand) CLASS OdbcStmt
   local nret:=0

   if cCommand == nil
      nret:=1
   else
      if len(cCommand) < 1
         nret:=2
      else
         ::cLastComm:=cCommand
         if (nret:=SQLExecDirect( ::hStmt, cCommand )) != SQL_SUCCESS
            ::nretorno:=nret
            msginfo( "SQLEXECDIRECT No se puede ejecutar la consulta " + ;
                    CRLF + ::LastError() )
         endif
      endif
   endif

return nret

//----------------------------------------------------------------------------//

METHOD odbcFName ( nField ) CLASS OdbcStmt

return ::aFields[nField][SQLNAME]

//----------------------------------------------------------------------------//

METHOD odbcField ( nField ) CLASS OdbcStmt

return ::aFields[nField][SQLNAME]

//----------------------------------------------------------------------------//

METHOD odbcFType( nField ) CLASS OdbcStmt

return ::aFields[nField][SQLCTYPE]

//----------------------------------------------------------------------------//

METHOD odbcFLen ( nField ) CLASS OdbcStmt

return ::aFields[nField][SQLLEN]

//----------------------------------------------------------------------------//

METHOD odbcFDec ( nField ) CLASS OdbcStmt

return ::aFields[nField][SQLDEC]

//----------------------------------------------------------------------------//

METHOD _FCount() CLASS OdbcStmt

   local nFields

   if SQLNumResultCols( ::hStmt, @nFields ) != SQL_SUCCESS
      MsgStop( "SQLNUMRESULTCOLS Error calculating number fo fields" )
      return 0
   endif

return nFields

//----------------------------------------------------------------------------//

METHOD _FieldName( nField ) CLASS OdbcStmt

   local cName, nType, nLen, nDec

   SQLDescribeCol( ::hStmt, nField, @cName, @nType, @nLen, @nDec )

return cName

//----------------------------------------------------------------------------//

METHOD InitFields() CLASS OdbcStmt

   local n, nFields := ::FCount()
   local cName, nType, nLen, nDec, lNull

   ::aFields = {}

   for n = 1 to nFields
   
      if (SQLDescribeCol( ::hStmt, n, @cName, @nType, @nLen, @nDec, @lNull )!=SQL_SUCCESS)
        msginfo("ERROR: "+cname+::lasterror())
      else
         if (nType==SQL_DOUBLE .OR. nType==SQL_FLOAT) .and. nDec==0
            nDec:=set(_SET_DECIMALS)
         endif
         AAdd( ::aFields, { cName, cSQLType( nType ), nLen, nDec, lNull, nType } )
      endif
      
      
   next

return nil

//----------------------------------------------------------------------------//

METHOD odbcFGet( nField ) CLASS OdbcStmt
   local uData
   local nType:=::aFields[nField][SQLNTYPE]
   local nTipoesp:=0
   local nLen:=::aFields[nField][SQLLEN]
   local cHelp1
   local cHelp2
   
   //a nLen se le debe aadir 1 si es nType
   nlen:= IIF(nLen > 65000, 64000, nLen+1)
   
   nTipoesp:=nType
   
   /*conversiones de tipos especiales*/
   do case
      case nType == SQL_VARCHAR .or. nType == SQL_LONGVARCHAR                        
         nTipoesp:=0
      case nType == SQL_FLOAT                       
         nTipoesp:=0
   endcase
            
   if (::nRetorno:=SQLGetData( ::hStmt, nField, nTipoesp, nLen, @uData)) != SQL_SUCCESS
      MsgAlert( "[Imposible recuperar valor de campo "+::aFields[nField][SQLNAME]+;
                "]" + CRLF + ::LastError() )
   endif
   
   do case
      case nType == SQL_CHAR        .or. nType == SQL_LONGVARCHAR .or. ;
           nType == SQL_VARCHAR      
           //no necesita conversion
         
      case nType == SQL_BIT
         udata:=iif(asc(substr(udata,1,1))==1,.t.,.f.)
         
      case nType == SQL_NUMERIC     .or. nType == SQL_DECIMAL
         udata:=val(udata)
       
      case nType == SQL_SMALLINT
         udata:=bin2i(udata)
           
      case nType == SQL_INTEGER
         udata:=bin2l(udata)
           
      case nType == SQL_DOUBLE      .or. nType == SQL_FLOAT         .OR.;
           nType == SQL_REAL
         udata:=bin2d(udata)
         
      case nType == SQL_DATE
         if len(udata) == 0
            udata:=ctod("0")
          else  
            if len(udata) == 6
               cHelp1:=set(_SET_DATEFORMAT)
               SET DATE TO JAPANESE  // "yyyymmdd"
               udata:=str(bin2i(substr(udata,1,2)),4,0) + "/" + ;
                      str(bin2i(substr(udata,3,2)),2,0) + "/" + ; 
                      str(bin2i(substr(udata,5,2)),2,0) 
               udata:=strtran(udata," ","0")
               udata:=ctod(udata)
               set(_SET_DATEFORMAT,cHelp1)
            endif   
         endif   
         
      case nType == SQL_TIME     
         udata:=str(bin2i(substr(udata, 1,2)),2,0) + ":" + ; 
                str(bin2i(substr(udata, 3,2)),2,0) + ":" + ; 
                str(bin2i(substr(udata, 5,2)),2,0) 
         udata:=strtran(udata," ","0")
         
      case nType == SQL_TIMESTAMP
         //el campo se ha creado en la base como C-23     
         //EL DRIVER DEVUELVE DE LONGITUD REAL 16 CARACTERES DE LOS CUALES
         //PARA LA FECHA SOLO TOMAMOS EN CONSIDERACION LOS 6 PRIMEROS 
         //YA QUE EL RESTO CORREPONDE A UNA ESTRUCTURA TIME
         udata:=str(bin2i(substr(udata, 1,2)),4,0) + "/" + ; 
                str(bin2i(substr(udata, 3,2)),2,0) + "/" + ; 
                str(bin2i(substr(udata, 5,2)),2,0) + "-" + ;
                str(bin2i(substr(udata, 7,2)),2,0) + ":" + ;
                str(bin2i(substr(udata, 9,2)),2,0) + ":" + ;
                str(bin2i(substr(udata,11,2)),2,0) 
         udata:=strtran(udata," ","0")
        
   endcase

return uData

//----------------------------------------------------------------------------//

function cSQLType( nType )

   local cType := "U"

   do case
      case nType == SQL_CHAR     .OR. nType == SQL_VARCHAR
           cType := "C"

      case nType == SQL_BIT
           cType := "L"

      case nType == SQL_NUMERIC  .OR. nType == SQL_DECIMAL  .OR. ;
           nType == SQL_INTEGER  .OR. nType == SQL_SMALLINT .OR. ; 
           nType == SQL_FLOAT    .OR. nType == SQL_REAL     .OR. ;
           nType == SQL_DOUBLE
           cType := "N"

      case nType == SQL_DATE 
           cType := "D"
           
      case nType == SQL_TIME     .or. nType == SQL_TIMESTAMP     
           cType := "C"

      case nType == SQL_LONGVARCHAR
           cType := "M"
           
   endcase
   
   //MSGINFO(cType+str(nType))
return cType

//----------------------------------------------------------------------------//

METHOD LastError() CLASS OdbcStmt

   local cClassError, nType, cMsgError

   SQLError( ::oODbc:hEnv , ::oODbc:hDbc , ::hStmt, @cClassError, @nType, @cMsgError )

return cMsgError

//----------------------------------------------------------------------------//

METHOD skip() CLASS OdbcStmt
LOCAL nret

If (nret:= SQLFetch( ::hStmt )) != SQL_SUCCESS

//   MsgAlert( "Impossible to Skip" + CRLF + ::LastError() )

endif

return nret

//----------------------------------------------------------------------------//

METHOD GetOptions ( nType ) CLASS OdbcStmt

   local cBuffer:=space(256)
   
   ::nRetorno := SQLGetStmtO( ::hStmt , nType , @cBuffer )   

return cBuffer

//----------------------------------------------------------------------------//

METHOD SetOptions ( nType, uBuffer ) CLASS OdbcStmt

  
return (::nRetorno := SQLSetStmtO( ::hStmt , nType , uBuffer )   )

//----------------------------------------------------------------------------//

METHOD SetCurName ( cName ) CLASS OdbcStmt

  
return (::nRetorno := SQLSetCurn( ::hStmt , cName )   )

//----------------------------------------------------------------------------//

METHOD GetCurName ( ) CLASS OdbcStmt

   local cBuffer:=space(256)
   
   ::nRetorno := SQLGetCurN( ::hStmt ,@cBuffer )   

return cBuffer

//----------------------------------------------------------------------------//

METHOD Cancel ( ) CLASS OdbcStmt

  
return (::nRetorno := SQLCancel( ::hStmt )   )

//----------------------------------------------------------------------------//
                                         
METHOD RowCount ( ) CLASS OdbcStmt

   local nRow := 0
   
   ::nRetorno := SQLRowCount( ::hStmt ,@nRow )   

return nRow

//----------------------------------------------------------------------------//

