// Expression Builder Dialog
// FiveWin - Dialog tools

#include "FiveWin.ch"

#define ID_EXPR      110
#define ID_WORKAREAS 120
#define ID_FIELDS    130
#define ID_EQUAL     150
#define ID_NOEQUAL   160
#define ID_AND       170
#define ID_PLUS      180
#define ID_LESS      190
#define ID_GREATER   200
#define ID_OR        210
#define ID_MINUS     220

#define ID_UNDO      345
#define ID_CHECK     350

//----------------------------------------------------------------------------//

function cGetExpression( cExpression, cTitle )

   local oDlg, oExpr, oLbxAreas, oFields, cTemp
   local aUnDo  := { "" }
   local cAlias := "", cField := ""

   DEFAULT cExpression := Space( 100 ),;
           cTitle := "Expression builder"

   cTemp = PadR( cExpression, 100 )

   DEFINE DIALOG oDlg RESOURCE "ExpBuilder" TITLE cTitle

   REDEFINE GET oExpr VAR cTemp ID ID_EXPR OF oDlg

   REDEFINE LISTBOX cAlias ITEMS aGetWorkAreas() ;
      ID ID_WORKAREAS OF oDlg ;
      ON CHANGE ShowFields( cAlias, oFields )

   REDEFINE LISTBOX oFields VAR cField ID ID_FIELDS OF oDlg ;
      ON DBLCLICK ExprAdd( " " + cAlias + "->" + ;
                  SubStr( cField, 1, At( Chr( 9 ), cField ) - 1 ),;
                  @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_EQUAL OF oDlg ;
      ACTION ExprAdd( " = ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_NOEQUAL OF oDlg ;
      ACTION ExprAdd( " <> ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_AND OF oDlg ;
      ACTION ExprAdd( " .and. ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_PLUS OF oDlg ;
      ACTION ExprAdd( " + ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_LESS OF oDlg ;
      ACTION ExprAdd( " < ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_GREATER OF oDlg ;
      ACTION ExprAdd( " > ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_OR OF oDlg ;
      ACTION ExprAdd( " .or. ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_MINUS OF oDlg ;
      ACTION ExprAdd( " - ", @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_UNDO OF oDlg ACTION UnDo( @cTemp, oExpr, aUnDo )

   REDEFINE BUTTON ID ID_CHECK OF oDlg ;
      ACTION If( At( Type( cTemp ), "UIUE" ) == 0,;
                 MsgInfo( "Correct expression" ),;
                 MsgAlert( "Invalid expression" ) )

   ACTIVATE DIALOG oDlg CENTERED

   if oDlg:nResult == IDOK
      cExpression = AllTrim( cTemp )
   endif

return cExpression

//----------------------------------------------------------------------------//

static function UnDo( cTemp, oExpr, aUnDo )

   if Len( aUnDo ) > 0
      cTemp = PadR( ATail( aUnDo ), 100 )
      oExpr:Refresh()
      ASize( aUnDo, Len( aUnDo ) - 1 )
   else
      Tone( 900, 2 )
   endif

return nil

//----------------------------------------------------------------------------//

static function ExprAdd( cNew, cExpr, oExpr, aUnDo )

   AAdd( aUnDo, RTrim( cExpr ) )
   cExpr = PadR( RTrim( cExpr ) + cNew, 100 )
   oExpr:Refresh()

return nil

//----------------------------------------------------------------------------//

static function ShowFields( cAlias, oLbx )

   local aFields
   local n

   aFields = ( cAlias )->( DbStruct() )
   oLbx:Reset()

   for n = 1 to Len( aFields )
      oLbx:Add( aFields[ n ][ 1 ] + Chr( 9 ) + ;
                aFields[ n ][ 2 ] + ;
                xPadL( Str( aFields[ n ][ 3 ], 3 ), 20 ) + ;
                xPadL( Str( aFields[ n ][ 4 ], 1 ), 10 ) )
   next

   oLbx:GoTop()

return nil

//----------------------------------------------------------------------------//
