#include <WinTen.h>
#include <Windows.h>
#include <MMSystem.h>
#include <ClipApi.h>

static WORD wDevices;

//---------------------------------------------------------------------------//

CLIPPER lMidiExist()
{
   _retl( ( wDevices = midiOutGetNumDevs() ) != 0 );
}

//---------------------------------------------------------------------------//

CLIPPER nMidiDevic() // es()  --> wDevices
{
   _retni( wDevices );
}

//---------------------------------------------------------------------------//

CLIPPER cMidiMappe() // r()  --> cMapperName
{
   MIDIOUTCAPS moc;

   if( ! midiOutGetDevCaps( MIDIMAPPER, &moc, sizeof( moc ) ) )
      _retc( moc.szPname );
   else
      _retc( "" );
}

//---------------------------------------------------------------------------//

CLIPPER aMidiDevic() // es()  --> acMidiDevices
{
   WORD wNum = midiOutGetNumDevs();
   WORD w;
   MIDIOUTCAPS moc;

   _reta( wNum );

   for( w = 0; w < wNum; w++ )
   {
      midiOutGetDevCaps( w, &moc, sizeof( moc ) );
      _storc( moc.szPname, -1, w + 1 );
   }
}

//---------------------------------------------------------------------------//

CLIPPER lMidiOutOp() // en( @nMidi, [nDevice] )  --> lOk
{
   HMIDIOUT hMidiOut;
   WORD wDevice = PCOUNT() ? _parni( 1 ): MIDIMAPPER;

   _retl( midiOutOpen( &hMidiOut, wDevice, NULL, 0L, 0L ) == 0 );
   _storni( hMidiOut, 1 );
}

//---------------------------------------------------------------------------//

static DWORD MidiOutMessage( HMIDIOUT hMidi, int iStatus, int iChannel,
                             int iData1,  int iData2 )
{
   DWORD dwMessage = iStatus | iChannel | (iData1 << 8) |
                     ((long) iData2 << 16) ;

   return midiOutShortMsg( hMidi, dwMessage );
}

//---------------------------------------------------------------------------//

CLIPPER MidiNoteOf() // f()
{
   HMIDIOUT hMidi = _parni( 1 );
   int iChannel   = _parni( 2 );
   int iOct       = _parni( 3 );
   int iNote      = _parni( 4 );
   int iVel       = _parni( 5 );

   _retnl( MidiOutMessage( hMidi, 0x080, iChannel, 12 * iOct + iNote, iVel ) );
}

//---------------------------------------------------------------------------//

CLIPPER MidiNoteOn()
{
   HMIDIOUT hMidi = _parni( 1 );
   int iChannel   = _parni( 2 );
   int iOct       = _parni( 3 );
   int iNote      = _parni( 4 );
   int iVel       = _parni( 5 );

   _retnl( MidiOutMessage( hMidi, 0x090, iChannel, 12 * iOct + iNote, iVel ) );
}

//---------------------------------------------------------------------------//

CLIPPER MidiSetPat() // ch( nMidi, nChannel, nVoice )  --> nResult
{
   HMIDIOUT hMidi = _parni( 1 );
   int iChannel   = _parni( 2 );
   int iVoice     = _parni( 3 );

   _retnl( MidiOutMessage( hMidi, 0x0C0, iChannel, iVoice, 0 ) );
}

//---------------------------------------------------------------------------//
