#include "FiveWin.ch"
#include "Constant.ch"

#define WM_MDICREATE        544   // 0x0220
#define WM_MDIDESTROY       545   // 0x0221
#define WM_MDIACTIVATE      546   // 0x0222
#define WM_MDIRESTORE       547   // 0x0223
#define WM_MDINEXT          548   // 0x0224
#define WM_MDIMAXIMIZE      549   // 0x0225
#define WM_MDITILE          550   // 0x0226
#define WM_MDICASCADE       551   // 0x0227
#define WM_MDIICONARRANGE   552   // 0x0228
#define WM_MDIGETACTIVE     553   // 0x0229
#define WM_MDISETMENU       560   // 0x0230

#define WM_CHILDACTIVATE     34   // 0x22
#define WM_GETFONT           49   // 0x0031

#define WM_NCACTIVATE       134   // 0x0086

#define SC_RESTORE        61728
#define SC_CLOSE          61536   // 0xF060
#define SC_MINIMIZE       61472
#define SC_NEXT           61504
#define SC_MAXIMIZE       61488   // 0xF030

#define IDC_ARROW         32512
#define WM_SYSCOMMAND       274   // 0x0112
#define CW_USEDEFAULT     32768

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TMdiChild FROM TWindow

   DATA   oWndClient, oControl

   METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu,;
               oWnd, oIcon, lVScroll, nClrText, nClrBack, oCursor,;
               oBrush, lPixel, lHScroll ) CONSTRUCTOR

   METHOD Maximize() INLINE ::oWndClient:ChildMaximize( Self )

   METHOD MdiActivate( lOn, hWndAct, hWndDeAct )

   METHOD Restore()  INLINE ::oWndClient:ChildRestore( Self )

   METHOD Activate( cShow, bLClicked, bRClicked, bMoved, bResized, bPainted,;
                    bKeyDown, bInit,;
                    bUp, bDown, bPgUp, bPgDn,;
                    bLeft, bRight, bPgLeft, bPgRight, bValid ) INLINE ;
                    ;
                    ::oWndClient:ChildActivate( Self ),;
                    Super:Activate( cShow, bLClicked, bRClicked, bMoved,;
                    bResized, bPainted, bKeyDown, bInit,;
                    bUp, bDown, bPgUp, bPgDn,;
                    bLeft, bRight, bPgLeft, bPgRight, bValid ),;
                    ::lVisible := .t.,;
                    If( ::oControl != nil, ::oControl:SetFocus(),)

   METHOD End()

   METHOD GotFocus() INLINE If( ::oControl != nil, ::oControl:SetFocus(),),;
                                Super:GotFocus()

   METHOD HandleEvent( nMsg, nWParam, nLParam )

   METHOD Next() INLINE ::oWndClient:ChildNext( Self )
   METHOD Prev() INLINE ::oWndClient:ChildNext( Self, .t. )

   METHOD ReSize() BLOCK { | Self, oRect | ;     // It has to be BLOCK
                   Super:ReSize(),;
                   oRect := ::GetCliRect(),;
                   oRect:nTop += If( ::oBar != nil, ::oBar:nBtnHeight, 0 ),;
                   oRect:nLeft--,;
                   If( ::oControl != nil, ::oControl:SetCoors( oRect ),), nil }

   METHOD KeyDown( nKey, nFlags )

   METHOD SetControl( oCtrl ) INLINE ::oControl := oCtrl, ::ReSize()

   METHOD SetMenu( oMenu, nMenuInfo ) INLINE ::oMenu := oMenu,;
                                             ::oWnd:SetMenu( oMenu, nMenuInfo )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nBottom, nRight, cTitle, nStyle, oMenu, oWnd,;
            oIcon, lVScroll, nClrFore, nClrBack, oCursor, oBrush,;
            lPixel, lHScroll ) CLASS TMdiChild

   DEFAULT cTitle   := "MDI Child", lVScroll := .f., lHScroll := .f.,;
           oWnd     := GetWndFrame(),;
           nClrFore := oWnd:oWndClient:nClrText,;
           nClrBack := oWnd:oWndClient:nClrPane,;
           lPixel   := .f.,;
           nStyle   := nOr( WS_OVERLAPPEDWINDOW, WS_VISIBLE )

   ::nTop       = If( nTop    != nil, nTop * If( ! lPixel, MDIC_CHARPIX_H, 1 ), CW_USEDEFAULT )				  // 16
   ::nLeft      = If( nLeft   != nil, nLeft * If( ! lPixel,  MDIC_CHARPIX_W, 1 ), CW_USEDEFAULT )       // 8
   ::nBottom    = If( nBottom != nil, nBottom * If( ! lPixel, MDIC_CHARPIX_H, 1 ), CW_USEDEFAULT )		  // 16
   ::nRight     = If( nRight  != nil, nRight  * If( ! lPixel,  MDIC_CHARPIX_W, 1 ), CW_USEDEFAULT )		// 8
   ::oWndClient = oWnd:oWndClient
   ::oWnd       = oWnd
   ::nStyle     = nStyle
   ::oIcon      = oIcon
   ::lVisible   = .t.
   ::aControls  = {}

   ::oCursor    = oCursor

   ::SetColor( nClrFore, nClrBack, oBrush )

   if ! lRegistered
      RegisterClass( "TMDICHILD",;
                     nOR( CS_VREDRAW, CS_HREDRAW ),;
                     0, 0, 0, 0, 0, "", GetMDIChlProc() )
      lRegistered = .t.
   endif

   ::hWnd = ::oWndClient:SendMsg( WM_MDICREATE, 0,;
        cMdiStruct( "TMDICHILD", cTitle,;
                    ::nTop, ::nLeft, ::nBottom, ::nRight,;
                    ::nStyle ) )
   ::Link()

   if oMenu != nil
      ::SetMenu( oMenu )
   endif

   if lVScroll
      DEFINE SCROLLBAR ::oVScroll VERTICAL OF Self
   endif
   if lHScroll
      DEFINE SCROLLBAR ::oHScroll HORIZONTAL OF Self
   endif

   if ::oFont == nil
      ::oFont = TFont()
      ::oFont:hFont = ::SendMsg( WM_GETFONT )
   endif

   ::oWndClient:Add( Self )

   SetWndDefault( Self )              // Set Default DEFINEd Window

return nil

//----------------------------------------------------------------------------//

METHOD End() CLASS TMdiChild

   local lEnd := .t.

   if ::bValid != nil
      if Eval( ::bValid )
         ::oWndClient:ChildClose( Self )
      else
         lEnd = .f.
      endif
   else
      ::oWndClient:ChildClose( Self )
   endif

return lEnd

//----------------------------------------------------------------------------//

METHOD KeyDown( nKey, nFlags ) CLASS TMdiChild

   // There is no a standard behavior for WM_KEYDOWN messages so we have
   // to process them !

   if nKey == VK_F4 .and. GetKeyState( VK_CONTROL )
      ::SendMsg( WM_SYSCOMMAND, SC_CLOSE )
      return 0
   endif

   if nKey == VK_F6 .and. GetKeyState( VK_CONTROL )
      ::SendMsg( WM_SYSCOMMAND, SC_NEXT )
      return 0
   endif

return Super:KeyDown( nKey, nFlags )

//----------------------------------------------------------------------------//

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TMdiChild

   if nMsg == WM_MDIACTIVATE
      return ::MdiActivate( nWParam == 1, nLoWord( nLParam ),;
                            nHiWord( nLParam ) )
   endif

return Super:HandleEvent( nMsg, nWParam, nLParam )

//----------------------------------------------------------------------------//

METHOD MdiActivate( lOn, hWndAct, hWndDeAct ) CLASS TMdiChild

   if lOn
      ::GotFocus()
      if ::oMenu != nil
         ::oWnd:SetMenu( ::oMenu )
      endif
   else
      if ::oMenu != nil
         ::oWnd:SetMenu( ::oWnd:oMenuStart )
      endif
   endif

return nil

//----------------------------------------------------------------------------//
