// Generating mailing labels - using FiveWin Report Preview

#include "fivewin.ch"

//----------------------------------------------------------------------------//

Function Main()

     local oWnd

     SET 3DLOOK ON

     DEFINE WINDOW oWnd TITLE "Labels generation & preview with FiveWin"

     @ 2, 2 BUTTON "&Labels" SIZE 120, 25 OF oWnd ACTION GenerateLabels()

     ACTIVATE WINDOW oWnd

return nil

//----------------------------------------------------------------------------//

function GenerateLabels()

     LOCAL oPrinter, oFont

     LOCAL nWidth   ,;                           // label Width
           nHeight  ,;                           // label height
           nMargin  ,;                           // Printing margin (.2 inches)
           nLblWid  ,;                           // # labels width  (2)
           nLblHei                               // # labels height (6)

     LOCAL nCounter ,;                           // counter of lbl on each page
           nRow     ,;                           // current row
           nCol     ,;                           // current col
           nOldRow                               // old row position

     USE TEST

     PRINTER oPrinter FROM USER PREVIEW NAME "Fivewin Label Demo"

     DEFINE FONT oFont FROM USER OF oPrinter

     nLblWid := 2
     nLblHei := 6

     nWidth  := oPrinter:nHorzRes()/nLblWid
     nHeight := oPrinter:nVertRes()/nLblHei
     nMargin := Int(oPrinter:nLogPixelsX()*0.2)

     nCounter := 0

     CursorWait()

     DO WHILE !Test->(Eof())

          IF nCounter == 0
               nRow := nMargin
               nCol := nMargin
               oPrinter:StartPage()
          ENDIF

          nOldRow := nRow

          oPrinter:Box( nRow, nCol, nOldRow + nHeight - 20, nCol + nWidth - 50 )
          oPrinter:SayBitmap( nRow + nHeight - 300, nCol + nWidth - 400,;
                              "..\bitmaps\Fw.bmp", 300, 200 )
          oPrinter:Say( nRow + 15, nCol + 15, Trim( Test->First ) + " " + Test->Last, oFont )
          nRow += oFont:nHeight
          oPrinter:Say( nRow + 15, nCol + 15, Test->Street, oFont )
          nRow += oFont:nHeight
          oPrinter:Say( nRow + 15, nCol + 15, Test->City, oFont )
          nRow += oFont:nHeight
          oPrinter:Say( nRow + 15, nCol + 15, Test->State, oFont )
          nRow += oFont:nHeight
          oPrinter:Say( nRow + 15, nCol + 15, Test->Zip, oFont )

          nRow := nOldRow + nHeight

          Test->(DbSkip())

          IF nCounter > 0 .AND. nCounter%nLblHei == 0
               nRow := nMargin
               nCol += nWidth
          ENDIF

          IF nCounter == (nLblHei*nLblWid) .AND. !Test->(Eof())
               nCounter := 0
               oPrinter:EndPage()
          ELSE
               nCounter++
          ENDIF

     ENDDO

     CursorArrow()

     oPrinter:EndPage()

     oPrinter:Preview()

     RELEASE FONT oFont

     CLOSE TEST

RETURN (NIL)
