#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function IconOpen( cFileName )

   local oWnd, oIco, oBar

   DEFAULT cFileName := cGetFile( "Executable EXE (*.exe) | *.exe |" + ;
                                  "Dynamic Library DLL (*.dll) | *.dll |" + ;
                                  "Driver (*.drv) | *.drv |" + ;
                                  "Any file (*.exe) | *.exe", "Select any file" )

   if ! File( cFileName )
      MsgAlert( "I don't find that file!" )
      return nil
   endif

   DEFINE ICON oIco RESOURCE "Icons"

   DEFINE WINDOW oWnd FROM 1, 1 TO 23, 33 TITLE "Icons:" MDICHILD ;
      VSCROLL ICON oIco COLOR "N/W"

   DEFINE BUTTONBAR oBar OF oWnd

   DEFINE BUTTON RESOURCE "Report" OF oBar ;
      ACTION oWnd:HardCopy( 4 ) ;
      MESSAGE "Generates a printout of this icons"

   ACTIVATE WINDOW oWnd ;
      ON PAINT SayIcons( oWnd, cFileName )

return nil

//----------------------------------------------------------------------------//

static function SayIcons( oWnd, cFileName )

   local nIcons  := nIcons( cFileName )
   local n := 0, nRow := 30, nCol := 10
   local nWidth

   oWnd:CoorsUpdate()
   nWidth = oWnd:nRight - oWnd:nLeft + 1

   while n < nIcons
      DrawIcon( oWnd:hDC, nRow, nCol, ExtractIcon( cFileName, n++ ) )
      nCol += 45
      if nCol + 50 >= nWidth
         nCol = 10
         nRow += 50
      endif
   end

return nil

//----------------------------------------------------------------------------//
