// This sample shows how to create a simply Report Database Management.

#include "FiveWin.ch"
#include "FwReport.ch"

static oWnd
static nX := 0, nY := 0
static lEditing := .f.

//----------------------------------------------------------------------------//

function Main()

   local oBar

   USE Report

   SET 3DLOOK ON

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 70 TITLE "Testing Styles" ;
      MDI VSCROLL HSCROLL

   DEFINE BUTTONBAR oBar OF oWnd

   DEFINE BUTTON FILE "..\bitmaps\Info.bmp" OF oBar ;
      MESSAGE "Edit Report Info" ACTION MsgInfo( "FiveWin Reports Engine 1.0" )

   DEFINE BUTTON FILE "..\bitmaps\OpenPrj.bmp" OF oBar ;
      MESSAGE "Select a previous project"

   DEFINE BUTTON FILE "..\bitmaps\Exit.bmp" OF oBar ;
      MESSAGE "Exit FiveWin Reports" ACTION oWnd:End()

   DEFINE BUTTON FILE "..\bitmaps\Browse.bmp" GROUP OF oBar ;
      MESSAGE "Edit Report Info" ACTION Browse( "Report Data", "&Elements" )

   DEFINE BUTTON FILE "..\bitmaps\Printer.bmp" OF oBar ;
      MESSAGE "Send report to the printer"

   DEFINE BUTTON FILE "..\bitmaps\BtnBmp.bmp" GROUP OF oBar ;
      MESSAGE "Place a Bitmap"

   DEFINE BUTTON FILE "..\bitmaps\Text.bmp" OF oBar ;
      MESSAGE "Place some Text" ACTION TextNew()

   DEFINE BUTTON FILE "..\bitmaps\Box.bmp" OF oBar ;
      MESSAGE "Place a Box"

   SET MESSAGE OF oWnd TO "Working on reports"

   ACTIVATE WINDOW oWnd ;
      ON PAINT ReportDisplay() ;
      ON UP   ( nX += 10, oWnd:oWndClient:Refresh() ) ;
      ON DOWN ( nX -= 10, oWnd:oWndClient:Refresh() ) ;
      ON PAGERIGHT MsgInfo( "Page Right" )
return nil

//----------------------------------------------------------------------------//

function ReportDisplay()

   if ! lEditing
      GO TOP

      while ! EoF()
         do case
            case AllTrim( Report->Type ) == "SAY"
                 oWnd:oWndClient:Say( nX + Report->Row, nY + Report->Col,;
                           AllTrim( Report->Data ),,,, .t. )

            case AllTrim( Report->Type ) == "BITMAP"
               if File( Report->Data )
                  oWnd:oWndClient:SayBitmap( nX + Report->Row,;
                                             nY + Report->Col, Report->Data )
               endif

            case AllTrim( Report->Type ) == "BOX"
                 oWnd:oWndClient:Box( nX + Report->Row, nY + Report->Col,;
                                      nX + Report->Row + Report->Height - 1,;
                                      nY + Report->Col + Report->Width - 1 )
         endcase
         SKIP
      end

      GO TOP
   endif

return nil

//----------------------------------------------------------------------------//

function TextNew()

   local oDlg
   local nRow  := 0
   local nCol  := 0
   local cText := PadR( "Some Text", 50 )
   local lSave := .f.

   DEFINE DIALOG oDlg RESOURCE "Text"

   REDEFINE GET nRow PICTURE "999" ID ID_ROW OF oDlg

   REDEFINE GET nCol PICTURE "999" ID ID_COL OF oDlg

   REDEFINE GET cText ID ID_TEXT OF oDlg

   REDEFINE BUTTON ID ID_ACEPTAR  OF oDlg ACTION ( lSave := .t., oDlg:End() )
   REDEFINE BUTTON ID ID_CANCELAR OF oDlg ACTION oDlg:End()

   ACTIVATE DIALOG oDlg CENTERED

   if lSave
      lEditing = .t.
      APPEND BLANK
      Report->Row  := nRow
      Report->Col  := nCol
      Report->Type := "SAY"
      Report->Data := AllTrim( cText )
      lEditing = .f.
      oWnd:Refresh()
   endif

return nil

//----------------------------------------------------------------------------//
