#include "error.ch"
#include "fwerror.ch"

// solo para forzar la creacin de los simbolos de estas funciones.
external ProcName

#define _SUBSYS_     "FiveWin"

#define ERR_MESSAGE    1
#define ERR_SEVERITY   2
#define ERR_SUBSYS     3
#define ERR_ERR_NO     4

/********  error Handler de OBJECTSP.
*/

FUNCTION __LowMemError()
return eval( errorBlock(), _FWGenError( MEMORYLOW_ERROR ) )

FUNCTION _FWGenError( nError, cOperation )

 local aErr := { { "Non defined Id" , ES_CATASTROPHIC,, } , ;
                 { "Duplicated Id"  , ES_CATASTROPHIC,, } , ;
                 { "Cannot create Dialog Box" , ES_CATASTROPHIC,, } , ;
                 { "Memory Low" , ES_WARNING, "BASE", 1001 } ;
               }

 local e

 if nError > 0 .and. nError <= MAX_DEFINED_ERRORS

    e = errornew()
    
    e:severity    = aErr[ nError ][ ERR_SEVERITY ]
    e:candefault  = e:severity < ES_CATASTROPHIC
    e:subsystem   = if( aErr[ nError ][ ERR_SUBSYS ] == nil,;
                        _SUBSYS_ ,;
                        aErr[ nError ][ ERR_SUBSYS ] )
    e:subcode     = if( aErr[ nError ][ ERR_ERR_NO ] == nil,;
                        nError,;
                        aErr[ nError ][ ERR_ERR_NO ] )
    e:description = aErr[ nError ][ ERR_MESSAGE ]
    e:operation   = cOperation

 endif

Return e
