#include "Fivewin.ch"
#include "dbms.ch"

CLASS TDbms

   DATA cFile               AS CHARACTER
   DATA aDb, aField, aIndex AS ARRAY

   METHOD New( cName )      CONSTRUCTOR
   
   METHOD Redefine( cFile ) INLINE ::New( cFile ), ::Read(), Self
   
   METHOD Update( oSelf )

   METHOD AddField( cName, cTipo, nLen, nDec )
   METHOD AddIndex( cName, cKey, bKey, cFor, bFor, lUnique )
   METHOD AddDb( oDbm )

   METHOD ReadFields()
   METHOD ReadIndexs() VIRTUAL
   METHOD ReadDb()
      
   METHOD WriteFields()
   METHOD WriteIndexs() VIRTUAL
   METHOD WriteDb()

   METHOD Create()          INLINE ::WriteFields, ::WriteIndex, ::WriteDb
   METHOD Read()            INLINE ::ReadFields, ::ReadIndex, ::ReadDb

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cFile ) CLASS TDbms

	   BYNAME cFile DEFAULT "DBMS"
	   ::aDb   := {}
	   ::aField:= {}
       ::aIndex:= {}

Return Self

//----------------------------------------------------------------------------//

METHOD Update( oSelf ) CLASS TDbms

   local n, p, arr
   local cClv:= Upper( oSelf:cAlias )
   
   if Empty( p:= aScan( ::aDb, {|e| e:cName == cClv } ) )
      Warning( "Alias '"+cClv+"' * NO FOUND *" )
   endif   

   oSelf:cAlias    := ::aDb[p]:cAlias
   oSelf:cFile     := ::aDb[p]:cFile
   oSelf:cDriver   := ::aDb[p]:cDriver
   oSelf:lShared   := ::aDb[p]:lShared
   oSelf:lReadOnly := ::aDb[p]:lReadOnly
   
   oSelf:ReadFields()
   oSelf:ReadIndex()
   // Los redefinimos segun el diccionario ?
   
Return nil
	
//----------------------------------------------------------------------------//

METHOD AddDb( oDbm ) CLASS TDbms

   if !Empty( aScan( ::aDb, {|e| e:cAlias == oDbm:cAlias } ) )
      Warning( "Alias '"+oDbm:cAlias+"' * FOUND *" )
   endif   

   aAdd( ::aDb, oDbm )
   
Return nil
	
//----------------------------------------------------------------------------//

METHOD AddField( cName, cType, nLen, nDec ) CLASS TDbms

   local i

   if valtype( cName ) == "O"
       aAdd( ::aField, cName )
      else 
       do case
          case cType == 'L'
               nLen:= 1
          case cType == 'D'
               nLen:= 8
          case cType == 'M'
               nLen:= 10
       endcase
       
	   if cType != 'N'
	      nDec := 0
	   endif
	      
	   if valtype( cName ) == "A"
          for i:= 1 to len( cName )
              aAdd( ::aField, TField():New( cName[i], cType, nLen, nDec ) )
          next
         else
          aAdd( ::aField, TField():New( cName, cType, nLen, nDec ) )
       end
   end   
	   
Return nil

//----------------------------------------------------------------------------//

METHOD AddIndex( cFile, cName, cKey, bKey, cFor, bFor, lUnique ) CLASS TDbms

	   if valtype( cFile ) == "O"
	      aAdd( ::aIndex, cFile )
	     else
          aAdd( ::aIndex, TIndex():New( cFile, cName, cKey, bKey, cFor, bFor, lUnique ) )
       end   

Return nil

//----------------------------------------------------------------------------//

METHOD ReadFields() CLASS TDbms

   local nOldArea:= Select()
	
   USE ( ::cFile + EXT_FLS ) NEW READONLY
   
   While !Eof()
         ::AddField( TField():New( Upper( Trim( FieldGet( 1 ) ) ),;  // Name.
                                   Upper( FieldGet( 2 ) ),;          // Type.
                                   FieldGet( 3 ),;                   // Len.
                                   FieldGet( 4 ) ;                   // Dec.
								 );
                   )
         SKIP
   end
   CLOSE
	
   Select ( nOldArea )
   
Return nil

//----------------------------------------------------------------------------//

METHOD WriteFields() CLASS TDbms

   local i, o, nLen := len( ::aField ), nOldArea:= Select()
	
   DbCreate( ::cFile + EXT_FLS, aSTRU_FIELD )
   
   USE (::cFile + EXT_FLS) NEW
       
   for i:= 1 to nLen
       o:= ::aField[i]
       APPEND BLANK
       FieldPut( 1, o:cName )
       FieldPut( 2, o:cType )
       FieldPut( 3, o:nLen )
       FieldPut( 4, o:nDec )
   next
   CLOSE

   Select ( nOldArea )
   
Return nil

//----------------------------------------------------------------------------//

METHOD ReadDb() CLASS TDbms

   local i, nOldArea2, cFile, nOldArea:= Select()
   local aField:= {}, aIndex:= {}
	
   USE (::cFile + EXT_DBS) NEW READONLY
   
   while !Eof()
         cFile := Upper( Trim( FieldGet(1) ) )

         nOldArea2 := Select()         
         USE ( cFile + EXT_FLD ) NEW READONLY
         aField := Array( FCount() )
         i := 1
         while !Eof()
			   aField[i++]:= Upper( Trim( FieldGet(1) ) ) // cName.
               SKIP
         enddo
         CLOSE

         ::AddDb( TDbm():New( Upper( Trim( FieldGet(1) ) ),;  // Alias.
                              Upper( Trim( FieldGet(2) ) ),;  // File.
                              Upper( Trim( FieldGet(3) ) ),;  // Driver.
                              FieldGet(4) ,;                  // Shared.
                              FieldGet(5) ,;                  // ReadOnly.
                              aField, aIndex ) )
         SKIP
   enddo
   CLOSE

   Select ( nOldArea )
   
Return nil

//----------------------------------------------------------------------------//

METHOD WriteDb() CLASS TDbms

   local a, i, o, n, cClv, nLen:= len( ::aDb )
   local nOldArea2, nOldArea:= Select()
	
   DbCreate( ::cFile + EXT_DBS, aSTRU_DB )
   
   USE ( ::cFile + EXT_DBS ) NEW
   
   nLen := len( ::aDb )
   for n:= 1 to nLen
   	   o:= ::aDb[n]
   	   APPEND BLANK
   	   FieldPut( 1, o:cAlias )
   	   FieldPut( 2, o:cFile )
   	   FieldPut( 3, o:cDriver )
   	   FieldPut( 4, o:lShared )
   	   FieldPut( 5, o:lReadOnly )
   	   
       nOldArea2 := Select()         
       DbCreate( o:cAlias + EXT_FLD, aSTRU_FIELD )

       USE ( o:cAlias + EXT_FLD ) NEW
       a := ::aDb[n]:aField
       for i:= 1 to len( a )
       	   cClv := Upper( a[i] )
           o := ::aField[ aScan( ::aField, { |e| e:cName == cClv } ) ]
           APPEND BLANK
           FieldPut( 1, o:cName )
           FieldPut( 2, o:cType )
           FieldPut( 3, o:nLen )
           FieldPut( 4, o:nDec )
	   next
       CLOSE
	   Select ( nOldArea2 )
	   
   next
   CLOSE

   Select ( nOldArea )
	
Return nil

//----------------------------------------------------------------------------//

function Warning( cText )

   CLS
   @ 10, 10 Say cText
   @ 23, 0
   quit

return nil

//----------------------------------------------------------------------------//
