// FiveWin - DataBase Objects Tutorial - 01
// FiveWin DataBase tools

#include "FiveWin.ch"
#include "Dbf01.ch"

static oWnd

//----------------------------------------------------------------------------//

function Main()

   SET 3DLOOK ON

   DEFINE WINDOW oWnd FROM 2, 2 TO 20, 70 ;
      TITLE "Testing DataBase Objects" ;
      MENU BuildMenu()

   SET MESSAGE OF oWnd ;
      TO "FiveWin - Object Oriented DataBase Management" CENTERED

   oWnd:bLDblClick = { || MsgInfo( "Double Left Click" ) }

   ACTIVATE WINDOW oWnd MAXIMIZED ;
      VALID MsgYesNo( "Do you really want to end ?" )

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   local oMenu

   MENU oMenu
      MENUITEM "&Clients"
      MENU
         MENUITEM "&Management..." ACTION Clients() ;
            MESSAGE "Clients management dialog"

         SEPARATOR

         MENUITEM "&Exit Test..."  ACTION oWnd:End() ;
            MESSAGE "End doing this tutorial"
      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function Clients()

   local oDbf, oDlg
   local oBtnNew, oBtnTop, oBtnPrev, oBtnNext, oBtnBottom, oBtnEnd
   local aButtons
   local lNew := .f.

   USE Clients

   DATABASE oDbf        // We create a DBF Object based on the current Alias
                        // Now we can change WorkArea and the DBF Object
                        // automatically access its area !


   DEFINE DIALOG oDlg RESOURCE "Clients" OF oWnd  // Specify the container,
                                                  // to access its MsgBar !

   REDEFINE GET oDbf:Name ID ID_NAME OF oDlg UPDATE ;
      MESSAGE "Please type here the name of the customer"

                                              // We directly use the Fields
                                              // name, but we are working on
                                              // a buffer ! This is perfect
                                              // for Network management

   REDEFINE GET oDbf:Adress ID ID_ADDRESS OF oDlg UPDATE ;
      MESSAGE "Please type here the address of the customer"

   REDEFINE CHECKBOX oDbf:Active ID ID_ACTIVE OF oDlg UPDATE ;
      MESSAGE "Is the customer currently active"

   REDEFINE BUTTON oBtnNew ID ID_NEW OF oDlg ;
      ACTION  New( @lNew, oDbf, aButtons, oDlg ) ;
      MESSAGE "Add a new customer"

   REDEFINE BUTTON oBtnTop ID ID_TOP OF oDlg ;
      ACTION  Top( @lNew, oDbf, aButtons, oDlg ) ;
      MESSAGE "Go to the first record of the DataBase"

   REDEFINE BUTTON oBtnPrev ID ID_PREV OF oDlg ;
      ACTION ( oDbf:Skip( -1 ), oDlg:Update() ) ;
      MESSAGE "Go to the previous record of the DataBase"

   REDEFINE BUTTON oBtnNext ID ID_NEXT OF oDlg ;
      ACTION ( oDbf:Skip(), oDlg:Update() ) ;
      MESSAGE "Go to the next record of the DataBase"

   REDEFINE BUTTON oBtnBottom ID ID_BOTTOM OF oDlg ;
      ACTION ( oDbf:GoBottom(), oDlg:Update() ) ;
      MESSAGE "Go to the last record of the DataBase"

   REDEFINE BUTTON oBtnEnd ID ID_END OF oDlg ;
      ACTION oDlg:End() ;
      MESSAGE "End this dialog"

   // Now all the buttons objects are created so we may store them
   // inside an array
   aButtons = { oBtnNew, oBtnTop, oBtnPrev, oBtnNext, oBtnBottom, oBtnEnd }

   ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function New( lNew, oDbf, aButtons, oDlg )

   local n

   if ! lNew
      aButtons[ 1 ]:SetText( "&Save" )
      aButtons[ 2 ]:SetText( "&Cancel" )
      for n = 3 to Len( aButtons )
         aButtons[ n ]:Disable()
      next
      oDbf:Blank()   // we 'clean' the DataBase buffer
      oDlg:Update()  // we refresh the controls
      oDlg:aControls[ 1 ]:SetFocus()  // we give focus to the first GET
   else
      oDbf:Append()  // The user selected 'save'
      oDbf:Save()    // we copy from the DataBase buffer into the 'real' DBF
      aButtons[ 1 ]:SetText( "&New" )
      aButtons[ 2 ]:SetText( "&Top" )
      for n = 3 to Len( aButtons )
	 aButtons[ n ]:Enable()
      next
   endif

   lNew = ! lNew     // we toggle the lNew value

return nil

//----------------------------------------------------------------------------//

function Top( lNew, oDbf, aButtons, oDlg )

   local n

   if ! lNew		// the user wants to GO TOP
      oDbf:GoTop()
      oDlg:Update()	// we repaint the controls containts

   else 		// the user canceled the 'New' option
      oDbf:Load()	// reload again fields info from the DBF
      oDlg:Update()	// we repaint the controls contains
      aButtons[ 1 ]:SetText( "&New" )
      aButtons[ 2 ]:SetText( "&Top" )
      for n = 3 to Len( aButtons )
	 aButtons[ n ]:Enable()
      next
      lNew = .f.
   endif

return nil

//----------------------------------------------------------------------------//
