#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

BOOL pascal Ctl3dRegister( HANDLE hInstance );
BOOL pascal Ctl3dAutoSubClass( HANDLE hInstance );
BOOL pascal Ctl3dUnregister( HANDLE hInstance );
BOOL pascal Ctl3dSubclassCtl( HWND hCtl );

extern void _fwAddTerminator( PCLIPFUNC );  // FiveWin internal.

extern HANDLE __hInstance;

static BOOL bInstaled;
static WORD wTimes = 0;

static BYTE bRegisterTerminator = FALSE;

//----------------------------------------------------------------------------//

static CLIPPER UnInstall( void )
{
   if( --wTimes )
      return;

   if( bInstaled )
   {
       Ctl3dUnregister( __hInstance );
       bInstaled = FALSE;
   }
}

//---------------------------------------------------------------------------//

static void CheckTerminator( void )
{
    if( ! bRegisterTerminator )
    {
        bRegisterTerminator = TRUE;
        _fwAddTerminator( UnInstall );
    }
}

//---------------------------------------------------------------------------//

static CLIPPER Install( void )
{
   if( ! bInstaled )
   {
       bInstaled = TRUE;
       Ctl3dRegister( __hInstance );
       Ctl3dAutoSubClass( __hInstance );
       CheckTerminator();
   }
   wTimes++;
}

//---------------------------------------------------------------------------//

CLIPPER Set3DLook()
{
   _retl( bInstaled );

   if( _parl( 1 ) )
   {
       Install();
   }
   else if( PCOUNT() )
   {
       UnInstall();
   }
}

//----------------------------------------------------------------------------//

CLIPPER CTL3DLOOK()   //  hWnd  --> lSuccess     // Makes 3D any Control
{
   Install();

   _retl( Ctl3dSubclassCtl( _parni( 1 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER CTL3DREGIS() // TER()
{
   Ctl3dRegister( _parni( 1 ) );
}

//----------------------------------------------------------------------------//

CLIPPER CTL3DAUTOS() // UBCLASS()
{
   Ctl3dAutoSubClass( _parni( 1 ) );
}

//----------------------------------------------------------------------------//

CLIPPER CTL3DUNREG() // ISTER()
{
   Ctl3dUnregister( _parni( 1 ) );
}

//----------------------------------------------------------------------------//
