#include "FiveWin.ch"

#define LTGRAY_BRUSH       1
#define GRAY_BRUSH         2

#define WM_ERASEBKGND     20
#define WM_LBUTTONDBLCLK 515  // 0x203
#define WM_CTLCOLOR       25  // 0x19       // Don't remove Color Control
#define WM_MENUSELECT    287

#define GW_HWNDNEXT        2
#define GW_CHILD           5

#define SC_CLOSE       61536   // 0xF060
#define SC_NEXT        61504
#define WM_SYSCOMMAND    274   // 0x0112

static nId := 100
static nPoint
static nMRow, nMCol

//----------------------------------------------------------------------------//

CLASS TControl FROM TWindow

   DATA   bSetGet, bChange
   DATA   cCaption
   DATA   lCaptured, lDrag, lMouseDown, lUpdate
   DATA   nLastRow, nLastCol

   METHOD Change() VIRTUAL

   METHOD Click() INLINE  ::oWnd:AEvalWhen()

   METHOD cToChar( cCtrlClass )
   METHOD Init( hDlg )

   METHOD Default()

   METHOD EraseBkGnd( hDC )

   METHOD FWLostFocus()

   METHOD GetDlgCode( nLastKey )

   METHOD GetNewId() INLINE ++nId

   METHOD GotFocus( hCtlLost ) INLINE   ::oWnd:nResult := Self,;
                               Super:GotFocus(), ::SetMsg( ::cMsg ), nil

   METHOD LostFocus() INLINE Super:LostFocus(), ::SetMsg()

   METHOD End()

   METHOD HandleEvent( nMsg, nWParam, nLParam ) EXTERN ;
                                    CtlHandleEvent( nMsg, nWParam, nLParam )

   METHOD KeyChar( nKey, nFlags )
   METHOD KeyDown( nKey, nFlags )

   MESSAGE SetFocus METHOD _SetFocus()

   METHOD Colors( hDC )
   METHOD DrawItem( nPStruct ) VIRTUAL
   METHOD FillMeasure()        VIRTUAL

   METHOD KillFocus( hCtlFocus )

   METHOD Set3DLook() INLINE Ctl3DLook( ::hWnd )

   METHOD VarPut( uVal ) INLINE  If( ValType( ::bSetGet ) == "B",;
                                 Eval( ::bSetGet, uVal ),)

   METHOD VarGet() INLINE If( ValType( ::bSetGet ) == "B", Eval( ::bSetGet ),)

   METHOD LButtonDown( nRow, nCol, nKeyFlags )

   METHOD LButtonUp( nRow, nCol, nKeyFlags )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD ForWhen()

   METHOD Display() VIRTUAL

   METHOD Paint() VIRTUAL

ENDCLASS

//----------------------------------------------------------------------------//

METHOD cToChar( cCtrlClass ) CLASS TControl

   local n := GetDlgBaseUnits()

   DEFAULT cCtrlClass := ::ClassName(),;
           ::cCaption := "",;
           ::nId      := ::GetNewId(),;
           ::nStyle   := nOR( WS_CHILD, WS_VISIBLE, WS_TABSTOP )

return cCtrl2Chr( Int( 2 * 8 * ::nTop    / nHiWord( n ) ),;
                  Int( 2 * 4 * ::nLeft   / nLoWord( n ) ),;
                  Int( 2 * 8 * ::nBottom / nHiWord( n ) ),;
                  Int( 2 * 4 * ::nRight  / nLoWord( n ) ),;
                  ::nId, ::nStyle, cCtrlClass, ::cCaption )

//----------------------------------------------------------------------------//

METHOD Init( hDlg ) CLASS TControl

   local oRect

   DEFAULT ::lActive := .t., ::lDrag := .f., ::lCaptured := .f.

   if( ( ::hWnd := GetDlgItem( hDlg, ::nId ) ) != 0 )
      oRect     = ::GetRect()
      ::nTop    = oRect:nTop
      ::nLeft   = oRect:nLeft
      ::nBottom = oRect:nBottom
      ::nRight  = oRect:nRight

      If( ::lActive, ::Enable(), ::Disable() )

      ::Link()

      if ::oFont != nil
         ::SetFont( ::oFont )
      else
         ::SetFont( ::oWnd:oFont )
      endif

   else
     #define NOVALID_CONTROLID   1
     Eval( ErrorBlock(), _FWGenError( NOVALID_CONTROLID, "No: " + ;
                                      Str( ::nId, 6 ) ) )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD _SetFocus() CLASS TControl

   local hCtrlNext

   if ::lWhen()
      SetFocus( ::hWnd )
   else
      hCtrlNext = GetWindow( ::hWnd, GW_HWNDNEXT )
      if GetParent( hCtrlNext ) != ::oWnd:hWnd
         hCtrlNext = GetWindow( ::oWnd:hWnd, GW_CHILD )
      endif
      SetFocus( hCtrlNext )
   endif

return nil

//----------------------------------------------------------------------------//

/*

METHOD HandleEvent( nMsg, nWParam, nLParam ) CLASS TControl

   do case
      case nMsg == WM_PAINT          // Standard Controls must use default
           return ::Display()

      case nMsg == WM_COMMAND
           return ::Command( nWParam, nLParam )

      case nMsg == WM_CLICK
           return ::Click()

      case nMsg == WM_CHANGE
           return ::Change()

      case nMsg == WM_COLOR
           return ::Colors( nWParam )

      case nMsg == WM_DESTROY
           return ::Destroy()

      case nMsg == FM_MEASURE
           return ::FillMeasure( nLParam )

      case nMsg == WM_MENUSELECT
           return ::MenuSelect( nWParam )

      case nMsg == FM_DRAW
           return ::DrawItem( nLParam )

      case nMsg == WM_GETDLGCODE
           return ::GetDlgCode( nWParam )

      case nMsg == WM_KEYDOWN
           return ::KeyDown( nWParam, nLParam )

      case nMsg == WM_CHAR
           return ::KeyChar( nWParam, nLParam )

      case nMsg == WM_KILLFOCUS
           return ::KillFocus( nWParam )

      case nMsg == FM_LOSTFOCUS
           return ::FWLostFocus()

      case nMsg == WM_MOUSEMOVE
           return ::MouseMove( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_SETFOCUS
           return ::GotFocus()

      case nMsg == WM_LBUTTONDOWN
           return ::LButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_LBUTTONUP
           return ::LButtonUp( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_RBUTTONDOWN
           return ::RButtonDown( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_LBUTTONDBLCLK
           return ::LDblClick( nHiWord( nLParam ), nLoWord( nLParam ), nWParam )

      case nMsg == WM_CTLCOLOR
           return ::CtlColor( nLoWord( nLParam ), nWParam )

      case nMsg == WM_ERASEBKGND
           return ::EraseBkGnd( nWParam )

      case nMsg == WM_VSCROLL
           return ::VScroll( nWParam, nLParam )

      case nMsg == WM_HSCROLL
           return ::HScroll( nWParam, nLParam )
   endcase

return nil

*/

//----------------------------------------------------------------------------//

METHOD Colors( hDC ) CLASS TControl

   DEFAULT ::nClrText := GetTextColor( hDC ),;
           ::nClrPane := GetBkColor( hDC ),;
           ::oBrush   := TBrush():New( ,::nClrPane,)

   SetTextColor( hDC, ::nClrText )
   SetBkColor( hDC,   ::nClrPane )

return ::oBrush:hBrush

//----------------------------------------------------------------------------//

METHOD Default() CLASS TControl

   ::lDrag     = .f.
   ::lCaptured = .f.

return nil

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol, nKeyFlags ) CLASS TControl

   ::lMouseDown = .t.
   ::nLastRow   = nRow
   ::nLastCol   = nCol

   if ::lDrag
      if ! ::lCaptured
         ::Capture()
         ::lCaptured = .t.
         nMRow  = nRow
         nMCol  = nCol
         nPoint = 0
         CtrlDrawFocus( ::hWnd )
      endif
      return 0
   else
      return Super:LButtonDown( nRow, nCol, nKeyFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD LButtonUp( nRow, nCol, nKeyFlags ) CLASS TControl

   ::lMouseDown = .f.

   if ::lDrag
      if ::lCaptured
         ReleaseCapture()
         ::lCaptured = .f.
         if nPoint != 0
            CtrlDrawFocus( ::hWnd, nLoWord( nPoint ) - nMRow,;
                                   nHiWord( nPoint ) - nMCol )
            ::Move( ::nTop + nRow - nMRow, ::nLeft + nCol - nMCol )
            ::oWnd:Refresh( .t. )
         else
            CtrlDrawFocus( ::hWnd, 0, 0 )
         endif
      endif
      return 0
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TControl

   DEFAULT ::lMouseDown := .f.

   if ::lDrag
      if ::lCaptured
         CursorCatch()
         if nPoint != 0
            CtrlDrawFocus( ::hWnd, nLoWord( nPoint ) - nMRow,;
                                   nHiWord( nPoint ) - nMCol )
         else
            CtrlDrawFocus( ::hWnd, 0, 0 )
         endif
         nPoint = nMakeLong( nRow, nCol )
         CtrlDrawFocus( ::hWnd, nLoWord( nPoint ) - nMRow,;
                                nHiWord( nPoint ) - nMCol )
      else
         CursorSize()
      endif
      return 0
   else
      if ::lMouseDown .and. ;
         ( Abs( nRow - ::nLastRow ) > 5 .or. Abs( nCol - ::nLastCol ) > 5 ) ;
         .and. ! Empty( ::oCursor )
         SetCursor( ::oCursor:hCursor )
         // Start drag operation here...
      else
         return Super:MouseMove( nRow, nCol, nKeyFlags )
      endif
   endif

return 0

//----------------------------------------------------------------------------//

METHOD End() CLASS TControl

   local nAt := If( ! Empty( ::aControls ),;
                AScan( ::oWnd:aControls, { | oCtrl | oCtrl:hWnd == Self:hWnd } ),;
                0 )

   if nAt != 0
      ADel( ::oWnd:aControls, nAt )
      ASize( ::oWnd:aControls, Len( ::oWnd:aControls ) - 1 )
   endif

return Super:End()

//----------------------------------------------------------------------------//

METHOD KeyChar( nKey, nFlags ) CLASS TControl

   local nDlgCode

   do case
      case nKey == VK_TAB .and. GetKeyState( VK_SHIFT )
           ::oWnd:GoPrevCtrl( ::hWnd )
           return 0    // We don't want API default behavior

      case nKey == VK_TAB
           ::oWnd:GoNextCtrl( ::hWnd )
           return 0    // We don't want API default behavior

      otherwise
           return Super:KeyChar( nKey, nFlags )
   endcase

return nil             // We want API default behavior

//----------------------------------------------------------------------------//

METHOD ForWhen() CLASS TControl

   ::oWnd:AEvalWhen()
   
   ::lCaptured = .f.
   
   // keyboard navigation
   if ::oWnd:nLastKey == VK_UP .or. ::oWnd:nLastKey == VK_DOWN ;
      .or. ::oWnd:nLastKey == VK_RETURN .or. ::oWnd:nLastKey == VK_TAB
      ::oWnd:FocusNext( ::hWnd, ( ::oWnd:nLastKey == VK_UP .or. ;
      ( ::oWnd:nLastKey == VK_TAB .and. GetKeyState( VK_SHIFT ) ) ) )
   else 
      if Empty( GetFocus() )
         SetFocus( ::hWnd )
      endif
   endif

   ::oWnd:nLastKey = 0

return nil 

//----------------------------------------------------------------------------//

METHOD KeyDown( nKey, nFlags ) CLASS TControl

   if ::lDrag
      do case
         case nKey == VK_DELETE
              if MsgYesNo( "Delete this control ?" )
                 ::End()
                 SysRefresh()
              endif
      endcase
   else
      return Super:KeyDown( nKey, nFlags )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD KillFocus( hCtlFocus ) CLASS TControl

   ::LostFocus()
   if ( GetParent( hCtlFocus ) == GetParent( ::hWnd ) .or. ;
      ( ::oWnd:oBar != nil .and. ;
      ::oWnd:oBar:hWnd == GetParent( hCtlFocus ) ) ) .and. ;
      ! ::oWnd:lValidating
      PostMessage( ::hWnd, FM_LOSTFOCUS )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD EraseBkGnd( hDC ) CLASS TControl

   if ::oBrush != nil
      FillRect( hDC, GetClientRect( ::hWnd ), ::oBrush:hBrush )
      return 1
   endif

return nil

//----------------------------------------------------------------------------//

METHOD FWLostFocus() CLASS TControl

   if ! ::oWnd:lValidating
        ::oWnd:lValidating = .t.
        if ! ::lValid()
           SetFocus( ::hWnd )
        else
           ::ForWhen()
        endif
        ::oWnd:lValidating = .f.
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GetDlgCode( nLastKey ) CLASS TControl

   if .not. ::oWnd:lValidating
      if nLastKey == VK_UP .or. nLastKey == VK_DOWN ;
         .or. nLastKey == VK_RETURN .or. nLastKey == VK_TAB
         ::oWnd:nLastKey = nLastKey

      // don't do a else here with :nLastKey = 0
      // or WHEN does not work properly, as we pass here twice before
      // evaluating the WHEN

      endif
   endif

return nil

//----------------------------------------------------------------------------//
