// This sample shows how to connect to CA-Ret using DDE.

#include "FiveWin.ch"

#define SW_MINNOACTIVE 7

static oWnd, oDde

//----------------------------------------------------------------------------//

function Main()

   DEFINE WINDOW oWnd FROM 1, 1 TO 20, 70 ;
      TITLE "Exec and DDE for CA-RET";
      MENU BuildMenu()

   SET MESSAGE OF oWnd ;
      TO OemToAnsi( "Test CA-RET WinExec and DDE" ) CENTERED

   ACTIVATE WINDOW oWnd

   if oDde != nil
      oDde:End()
   endif

return nil

//----------------------------------------------------------------------------//

function BuildMenu()

   LOCAL oMenu

   MENU oMenu
      MENUITEM "&Dynamic Data Exchange"
      MENU
         MENUITEM "Establish a DDE link"  ACTION StartDDE() ;
            MESSAGE "We are going to start CA-RET and create a link to it"

         MENUITEM "Try the link..." ACTION TestDDE() ;
            MESSAGE "Run a Report"

         MENUITEM "Disconnect the link..." ;
            ACTION ( If( oDde != nil, oDde:End(),), oDde := nil ) ;
            MESSAGE "End the connection, if already available"

         SEPARATOR

         MENUITEM "Exit" ACTION oWnd:End() ;
            MESSAGE "End of Demonstration"
      ENDMENU
   ENDMENU

return oMenu

//----------------------------------------------------------------------------//

function StartDDE()

   local nStatus

   if oDde != nil .and. ! oDde:lActive
      oDde:End()
      oDde = nil
   endif

   if oDde == nil

      oWnd:SetMsg( "Trying to connect with CA-Ret. Please wait..." )

      nStatus = WinExec( "CaRetRun", SW_MINNOACTIVE )
      if nStatus < 32 .and. nStatus != 16
         MsgAlert( "CaRetRun not available!" )
      endif

      oWnd:SetMsg( "CA-Ret connection available!" )

      DEFINE DDE oDde SERVICE "CARETRUN" TOPIC "SYSTEM" ;
         VALID MsgInfo( "The connection has just finished!" )

      ACTIVATE DDE oDde

      MsgInfo( "Link Established!","DDE")
   else
      MsgInfo( "The link was already created...","DDE")
   endif

return nil

//----------------------------------------------------------------------------//

function TestDDE()

   if oDde != nil
      if oDde:lActive
         oDde:Execute( "[App.Maximize]" )
         oDde:Execute( "[File.Open( TRIAL.RET )]" )
         oDde:Execute( "[File.Print(0,0)]" )
         oDde:Execute( "[File.Exit]" )
      else
         MsgInfo( "DDE connection not longer available" + CRLF + ;
                  "try to connect again" )
         oDde = nil
      endif
   else
      MsgInfo( "Before you have to make the connection..." )
   endif

return nil

//----------------------------------------------------------------------------//
