#include "FiveWin.ch"

#define LTGRAY_BRUSH 1
#define RT_BITMAP    2

static lRegistered := .f.

//----------------------------------------------------------------------------//

CLASS TBtnBmp FROM TControl

   DATA   bAction, cMsg
   DATA   lPressed, lCaptured, lAdjust, lGroup
   DATA   hBmpPal1, hBmpPal2
   DATA   lWorking, lBtnUp

   METHOD New( nTop, nLeft, nWidth, nHeight,;
               cResName1, cResName2, cBmpFile1, cBmpFile2,;
               bAction, oWnd, cMsg, bWhen, lAdjust, lUpdate ) CONSTRUCTOR

   METHOD NewBar( cResName1, cResName2, cBmpFile1, cBmpFile2,;
                  cMsg, bAction, lGroup, oBar, lAdjust, bWhen ) CONSTRUCTOR

   METHOD ReDefine( nId, cResName1, cResName2, cBmpFile1, cBmpFile2,;
                    cMsg, bAction, oBar, lAdjust, bWhen, lUpdate ) CONSTRUCTOR

   METHOD Click()
   METHOD Display() INLINE ::BeginPaint(), ::Paint(), ::EndPaint(), 0
   METHOD FreeBitmaps()
   METHOD cGenPRG()
   METHOD LButtonDown( nRow, nCol )
   METHOD LButtonUp( nRow, nCol )
   METHOD LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

   METHOD Paint() INLINE ;
          PalBtnPaint( ::hWnd, ::hBmpPal1, ::hBmpPal2, ::lPressed, ::lAdjust )

   METHOD MouseMove( nRow, nCol, nKeyFlags )

   METHOD Destroy()

   METHOD SetFile( cBmpUpFile, cBmpDownFile )

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( nTop, nLeft, nWidth, nHeight,;
            cResName1, cResName2, cBmpFile1, cBmpFile2,;
            bAction, oWnd, cMsg, bWhen, lAdjust, lUpdate )  CLASS TBtnBmp
   
   DEFAULT cMsg := " ", nWidth := 20, nHeight := 20, lAdjust := .f.,;
           lUpdate := .f.

   ::nStyle    = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::nId       = ::GetNewId()
   ::oWnd      = oWnd
   ::bAction   = bAction
   ::cMsg      = cMsg
   ::nTop      = nTop
   ::nLeft     = nLeft
   ::nBottom   = nTop + nHeight - 1
   ::nRight    = nLeft + nWidth - 1
   ::lPressed  = .f.
   ::lWorking  = .f.
   ::lAdjust   = lAdjust
   ::lDrag     = .f.
   ::lCaptured = .f.
   ::bWhen     = bWhen
   ::nClrPane  = CLR_LIGHTGRAY
   ::lUpdate   = lUpdate

   ::hBmpPal1  = 0
   ::hBmpPal2  = 0

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   if oWnd:lVisible
      ::Create()
   else
      oWnd:DefControl( Self )
   endif

   ::LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

return nil

//----------------------------------------------------------------------------//

METHOD NewBar( cResName1, cResName2, cBmpFile1, cBmpFile2, cMsg, bAction,;
               lGroup, oBar, lAdjust, bWhen ) CLASS TBtnBmp

   DEFAULT cMsg := "", lAdjust := .f.

   ::nStyle    = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::nId       = ::GetNewId()
   ::oWnd      = oBar
   ::bAction   = bAction
   ::cMsg      = cMsg
   ::nTop      = oBar:GetBtnTop( lGroup )
   ::nLeft     = oBar:GetBtnLeft( lGroup )
   ::nBottom   = ::nTop + oBar:nBtnHeight + 1 - If( oBar:l3D, 6, 0 )
   ::nRight    = ::nLeft + oBar:nBtnWidth - If( oBar:l3D, 2, 0 )
   ::lPressed  = .f.
   ::lCaptured = .f.
   ::lWorking  = .f.
   ::lDrag     = .f.
   ::lAdjust   = lAdjust
   ::lGroup    = lGroup
   ::bWhen     = bWhen
   ::nClrPane  = CLR_LIGHTGRAY
   ::oCursor   = oBar:oCursor

   ::hBmpPal1  = 0
   ::hBmpPal2  = 0

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   ::Create()
   oBar:Add( Self )

   ::LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

return nil

//----------------------------------------------------------------------------//

METHOD ReDefine( nId, cResName1, cResName2, cBmpFile1, cBmpFile2, cMsg,;
                 bAction, oBar, lAdjust, bWhen, lUpdate ) CLASS TBtnBmp

   DEFAULT cMsg := "", lAdjust := .f., lUpdate := .f.

   ::nStyle    = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::nId       = nId
   ::oWnd      = oBar
   ::bAction   = bAction
   ::cMsg      = cMsg
   ::lPressed  = .f.
   ::lCaptured = .f.
   ::lWorking  = .f.
   ::lDrag     = .f.
   ::lAdjust   = .f.
   ::bWhen     = bWhen
   ::nClrPane  = CLR_LIGHTGRAY
   ::lUpdate   = lUpdate

   ::hBmpPal1  = 0
   ::hBmpPal2  = 0

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   oBar:AddControl( Self )

   ::LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 )

return nil

//----------------------------------------------------------------------------//

METHOD Click() CLASS TBtnBmp

   if ::bAction != nil
      Eval( ::bAction )
   endif

   Super:Click()         // keep it here, the latest!

return nil

//----------------------------------------------------------------------------//

METHOD cGenPRG() CLASS TBtnBmp

   local cPrg := ""

   cPrg += CRLF + CRLF + "   DEFINE BUTTON OF oBar " + ;
              'ACTION MsgInfo( "Not defined yet" )'

return cPrg

//----------------------------------------------------------------------------//

METHOD LButtonDown( nRow, nCol ) CLASS TBtnBmp

   ::lWorking = .t.
   ::lBtnUp   = .f.

   SetFocus( ::hWnd )    // To let the main window child control
   SysRefresh()          // process its valid

   if GetFocus() == ::hWnd
      ::lCaptured = .t.
      ::lPressed  = .t.
      ::Capture()
      ::Refresh( .f. )
   endif

   ::lWorking = .f.

   if ::lBtnUp
      ::LButtonUp( nRow, nCol )
      ::lBtnUp = .f.
   endif

return 0

//----------------------------------------------------------------------------//

METHOD LButtonUp( nRow, nCol )  CLASS TBtnBmp

   local lClick := IsOverWnd( ::hWnd, nRow, nCol )

   ::lBtnUp = .t.

   if ! ::lWorking
      if ::lCaptured
         ::lCaptured = .f.
         ReleaseCapture()
         if ::lPressed
            ::lPressed = .f.
            ::Refresh( .f. )
         endif
         if lClick
            ::Click()
         endif
      endif
   endif

return 0

//----------------------------------------------------------------------------//

METHOD Destroy() CLASS TBtnBmp

   ::FreeBitmaps()
   Super:Destroy()

return 0

//----------------------------------------------------------------------------//

METHOD SetFile( cBmpUpFile, cBmpDownFile ) CLASS TBtnBmp

   ::FreeBitmaps()
   ::LoadBitmaps( nil, nil, cBmpUpFile, cBmpDownFile )
   ::Refresh()

return nil

//----------------------------------------------------------------------------//

METHOD FreeBitmaps() CLASS TBtnBmp

   if ::hBmpPal1 != 0
      PalBmpFree( ::hBmpPal1 )
   endif

   if ::hBmpPal2 != 0
      PalBmpFree( ::hBmpPal2 )
   endif

   ::hBmpPal1 = 0
   ::hBmpPal2 = 0

return nil

//----------------------------------------------------------------------------//

METHOD LoadBitmaps( cResName1, cResName2, cBmpFile1, cBmpFile2 ) CLASS TBtnBmp

   if ! Empty( cResName1 )
      ::hBmpPal1 := PalBmpLoad( cResName1 )
   endif

   if ! Empty( cResName2 )
      ::hBmpPal2 := PalBmpLoad( cResName2 )
   endif

   if ! Empty( cBmpFile1 )
      if File( cBmpFile1 )
         ::hBmpPal1  := PalBmpRead( ::GetDC(), cBmpFile1 )
         ::ReleaseDC()
      endif
   endif

   if ! Empty( cBmpFile2 )
      if File( cBmpFile2 )
         ::hBmpPal2  := PalBmpRead( ::GetDC(), cBmpFile2 )
         ::ReleaseDC()
      endif
   endif

   if !empty( ::hBmpPal1 )
      PalBmpNew( ::hWnd, ::hBmpPal1 )
   endif

   if !empty( ::hBmpPal2 )
      PalBmpNew( ::hWnd, ::hBmpPal2 )
   endif

return nil

//----------------------------------------------------------------------------//

METHOD MouseMove( nRow, nCol, nKeyFlags ) CLASS TBtnBmp

   Super:MouseMove( nRow, nCol, nKeyFlags )

   if ::lCaptured
      if ::lPressed != IsOverWnd( ::hWnd, nRow, nCol )
         ::lPressed = ! ::lPressed
         ::Refresh( .f. )
      endif
   endif
   ::oWnd:SetMsg( ::cMsg )

return 0

//----------------------------------------------------------------------------//
