// Generic Browse implementation built from source code
// Implementacin de un Browse genrico creado desde cdigo

#include "FiveWin.ch"
#include "Report.ch"
#include "InKey.ch"

#define ENGLISH

//----------------------------------------------------------------------------//

function Browse( cTitle, cListName, bNew, bModify, bDelete, bSearch, bList )

   local oDlg, oLbx, oFont
   local btnNew, btnModify, btnDelete, btnSearch, btnList, btnEnd

   DEFAULT cTitle  := "Browse", cListName := "Fields",;
           bNew    := { || oLbx:RecAdd(), oLbx:Refresh() },;
           bDelete := { || RecDelete( oLbx ) },;
           bModify := { || RecModify( oLbx ) },;
           bList   := { || Report( oLbx ) }

   DEFINE FONT oFont NAME "Arial" SIZE 6, 15 BOLD

   DEFINE DIALOG oDlg FROM 3, 3 TO 26, 79 TITLE cTitle FONT oFont

   @ 0, 1 SAY cListName  OF oDlg

   @ 1, 1 LISTBOX oLbx FIELDS ;
      SIZE 284, 137  OF oDlg

   oLbx:bLDblClick = { | nRow, nCol | EditCell( oLbx, nRow, nCol ) }
   oLbx:bKeyDown   = { | nKey, nFlags | KeyDown( oLbx, nKey, nFlags ) }
   oLbx:bKeyChar   = { | nKey, nFlags | KeyChar( oLbx, nKey, nFlags ) }

#ifdef ENGLISH

   @ 13,  1 BUTTON btnNew    PROMPT "&New"    OF oDlg SIZE 40, 12
   @ 13,  8 BUTTON btnModify PROMPT "&Modify" OF oDlg SIZE 40, 12
   @ 13, 15 BUTTON btnDelete PROMPT "&Delete" OF oDlg SIZE 40, 12
   @ 13, 22 BUTTON btnSearch PROMPT "&Search" OF oDlg SIZE 40, 12
   @ 13, 29 BUTTON btnList   PROMPT "&Print"  OF oDlg SIZE 40, 12
   @ 13, 36 BUTTON btnEnd    PROMPT "&Exit"   OF oDlg SIZE 40, 12

#else

   @ 13,  1 BUTTON btnNew    PROMPT "&Nuevo"    OF oDlg SIZE 40, 12
   @ 13,  8 BUTTON btnModify PROMPT "&Modifica" OF oDlg SIZE 40, 12
   @ 13, 15 BUTTON btnDelete PROMPT "&Elimina"  OF oDlg SIZE 40, 12
   @ 13, 22 BUTTON btnSearch PROMPT "&Buscar"   OF oDlg SIZE 40, 12
   @ 13, 29 BUTTON btnList   PROMPT "&Imprimir" OF oDlg SIZE 40, 12
   @ 13, 36 BUTTON btnEnd    PROMPT "&Salir"    OF oDlg SIZE 40, 12

#endif

   btnNew:bAction    = { || Eval( bNew ),;
                         oLbx:GoBottom(), oLbx:SetFocus() }

   btnModify:bAction = If( bModify != nil,;
                           { || Eval( bModify ),;
                           oLbx:Refresh(), oLbx:SetFocus() },)

   btnDelete:bAction = If( bDelete != nil,;
                           { || Eval( bDelete ),;
                           oLbx:Refresh(), oLbx:SetFocus() },)

   btnSearch:bAction = If( bSearch != nil,;
                           { || Eval( bSearch ),;
                           oLbx:Refresh(), oLbx:SetFocus() },)

   btnList:bAction   = { || Eval( bList ), oLbx:Refresh() }

   btnEnd:bAction    = { || oDlg:End() }

   ACTIVATE DIALOG oDlg 

return nil

//----------------------------------------------------------------------------//

function Report( oLbx )

   local oRpt
   local n
   local cAlias := If( oLbx != nil, oLbx:cAlias, Alias() )

   REPORT oRpt TITLE "Report: " + cAlias ;
      HEADER "Date: " + DToC( Date() ) + ", Time: " + Time() ;
      FOOTER "Page: " + Str( oRpt:nPage, 3 ) ;
      PREVIEW

      for n = 1 to FCount()
         oRpt:AddColumn( TrColumn():New( { FInfo1( cAlias, n ) },,;
                     { FInfo2( cAlias, n ) },,,,,,,,,, oRpt ) )
      next

   ENDREPORT

   ACTIVATE REPORT oRpt

   GO TOP

return nil

//----------------------------------------------------------------------------//

static function FInfo1( cAlias, n )
return { || ( cAlias )->( FieldName( n ) ) }

static function FInfo2( cAlias, n )
return { || ( cAlias )->( FieldGet( n ) ) }

//----------------------------------------------------------------------------//

static function RecModify( oLbx )

   local n := 1
   local nCols := ( oLbx:cAlias )->( FCount() )
   local u := ( oLbx:cAlias )->( FieldGet( 1 ) )

   while n <= nCols .and. oLbx:lEditCol( n, @u )
      oLbx:DrawSelect()
      SysRefresh()
      if ( oLbx:cAlias )->( RLock() )
         ( oLbx:cAlias )->( FieldPut( n, u ) )
         UNLOCK
      else
         MsgAlert( "DataBase non available" )
         n = nCols + 1
      endif
      n++
      if n <= nCols
         u = ( oLbx:cAlias )->( FieldGet( n ) )
      endif
   end

return nil

//----------------------------------------------------------------------------//

static function EditCell( oLbx, nRow, nCol )

   local nColumn := oLbx:nAtCol( nCol )
   local u

   u = ( oLbx:cAlias )->( FieldGet( nColumn ) )

   if oLbx:lEditCol( nColumn, @u )
      if ( oLbx:cAlias )->( RLock() )
         ( oLbx:cAlias )->( FieldPut( nColumn, u ) )
         UNLOCK
         oLbx:DrawSelect()
      else
         MsgAlert( "DataBase non available" )
      endif
   endif

return nil

//----------------------------------------------------------------------------//

static function KeyDown( oLbx, nKey, nFlags )

   do case
      case nKey == VK_DELETE
           RecDelete( oLbx )
   endcase

return nil

//----------------------------------------------------------------------------//

static function KeyChar( oLbx, nKey, nFlags )

   do case
      case nKey == K_ENTER
           RecModify( oLbx )
   endcase

return nil

//----------------------------------------------------------------------------//

static function RecDelete( oLbx )

   if MsgYesNo( "Delete this record ?", "Please, confirm" )
      DELETE
      PACK
      oLbx:Refresh()
   endif

return nil

//----------------------------------------------------------------------------//
