/*
 * File......:
 * Author....: A.L., F.P.
 * Date......: $Date:   17 Oct 1994 24:00:00  $
 * Revision..: $Revision:   1.0  $
 * Log file..: $Logfile$
 * 
 * Modification history:
 * ---------------------
 *
 *  rev 1.0
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *  ReadBitmap()
 *  $CATEGORY$
 *  Bitmaps
 *  $ONELINER$
 *  Load a bitmap from a disk file.
 *  $SYNTAX$
 *
 *  ReadBitmap( [<hDC>], <cBmpFile> )  --> hBitmap
 *
 *  $ARGUMENTS$
 *
 *  <hDC>       Is the handle of the device context to be used with
 *              that bitmap. You should supply 0 is no hDC is available.
 *
 *  <cBmpFile>  Is the name of the .BMP file in the disk.
 *
 *  $RETURNS$
 *
 *  <hBitmap>   Is a bitmap handle.
 *
 *  $DESCRIPTION$
 *
 *  This function is very usefull to dynamically load bitmaps from disk.
 *  It lets the user of our application supply new BMPs with photos,
 *  drawings, etc... or just to modify the BMPs we have used.
 *
 *  It has been tested with 16 and 256 colors bitmaps.
 *
 *  $EXAMPLES$
 *
 *  local hBmp := ReadBitmap( 0, "Test.bmp" )
 *
 *  $SEEALSO$
 *
 *  LoadBitmap()
 *
 *  $END$
 */

#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

void RegisterResource( HANDLE hRes, LPSTR szType );

//----------------------------------------------------------------------------//

CLIPPER READBITMAP()
{
   HDC hDC = _parni( 1 );
   HFILE hFile;
   LONG lSize;
   HANDLE hDib;
   void huge * pData;
   HBITMAP hBitmap = 0;
   BITMAPFILEHEADER Header;
   BOOL bDestroyDC = ( hDC == 0 );

   if( hFile = _lopen( _parc( 2 ), READ ) )
   {
      if( hDib = GlobalAlloc( GMEM_MOVEABLE | GMEM_DISCARDABLE,
                              lSize = _llseek( hFile, 0, 2 ) ) )
      {
         _llseek( hFile, 0, 0 );
         _lread( hFile, &Header, sizeof( BITMAPFILEHEADER ) );
         _hread( hFile, pData = GlobalLock( hDib ),
                 lSize - sizeof( BITMAPFILEHEADER ) );

         if( bDestroyDC )
             hDC = GetDC( 0 );

         hBitmap = CreateDIBitmap( hDC,
                                   pData,
                                   CBM_INIT,
          ( LPSTR ) pData + Header.bfOffBits - sizeof( BITMAPFILEHEADER ),
                                   pData,
                                   DIB_RGB_COLORS );
         if( bDestroyDC )
             ReleaseDC( 0, hDC );

         GlobalUnlock( hDib );
         GlobalFree( hDib );
      }
      _lclose( hFile );
   }

   RegisterResource( hBitmap, "BMP" );

   _retni( hBitmap );
}

//----------------------------------------------------------------------------//
