#include <WinTen.h>
#include <Windows.h>

//----------------------------------------------------------------------------//

int DIBitmapColors( BITMAPINFO FAR * bmi )
{
  if (bmi->bmiHeader.biSize == sizeof( BITMAPCOREHEADER ) )
	{
		/*
		**	OS/2 PM Bitmap, use bcBitCount field to determine colors
		*/

    switch ( ( ( BITMAPCOREINFO FAR * )bmi )->bmciHeader.bcBitCount )
		{
			case 1:
				return 2;	/* Monochrome bitmap -> 2 colors */

			case 4:
				return 16;	/* 4-bit image -> 16 colors */

			case 8:
				return 256;	/* 8-bit image -> 256 colors */

			case 24:
				return 0;	/* 24-bt image -> 0 colors in color table */
		}
	}
	else
	{
		/*
		**	Windows bitmap
		*/
    if( bmi->bmiHeader.biClrUsed == 0 )
		{
			/* Maximum number of entries */
			switch (bmi->bmiHeader.biBitCount)
			{
				case 1:
					return 2;	/* Monochrome bitmap -> 2 colors */

				case 4:
					return 16;	/* 4-bit image -> 16 colors */

				case 8:
					return 256;	/* 8-bit image -> 256 colors */

				case 24:
					return 0;	/* 24-bt image -> 0 colors in color table */
			}
		}
		else
		{
			return (int)bmi->bmiHeader.biClrUsed;
		}
	}

	return 0;
}

//----------------------------------------------------------------------------//
