#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

#define BAR_TOP     1
#define BAR_LEFT    2
#define BAR_RIGHT   3
#define BAR_DOWN    4
#define BAR_FLOAT   5

//----------------------------------------------------------------------------//

CLIPPER BarAdjust()
{
   HWND hWnd    = _parni( 1 );
   BYTE bMode   = _parni( 2 );
   BOOL bMsgBar = _parl( 3 );
   HWND hParent = GetParent( hWnd );
   RECT rcWnd, rcParent;

   GetClientRect( hWnd, &rcWnd );
   GetClientRect( hParent, &rcParent );

   switch( bMode )
   {
      case BAR_TOP:
           SetWindowPos( hWnd, 0, -1, -1,
                         rcParent.right - rcParent.left + 2,
                         rcWnd.bottom - rcWnd.top + 2, SWP_NOZORDER );
           break;

      case BAR_LEFT:
           SetWindowPos( hWnd, 0, -1, -1, rcWnd.right - rcWnd.left + 2,
                         rcParent.bottom + 1 - IF( bMsgBar, 24, 0 ), SWP_NOZORDER );
           break;

      case BAR_RIGHT:
           SetWindowPos( hWnd, 0, rcParent.right - ( rcWnd.right - rcWnd.left ) - 1,
                         -1, rcWnd.right - rcWnd.left + 2,
                         rcParent.bottom + 1 - IF( bMsgBar, 24, 0 ), SWP_NOZORDER );
           break;

      case BAR_DOWN:
           SetWindowPos( hWnd, 0, -1, rcParent.bottom - IF( bMsgBar, 24, 0 ) -
                         ( rcWnd.bottom - rcWnd.top ) - 2,
                         rcParent.right - rcParent.left + 2,
                         rcWnd.bottom - rcWnd.top + 2,
                         SWP_NOZORDER );
           break;

      case BAR_FLOAT:
           break;
   }
}

//----------------------------------------------------------------------------//
