#include "FiveWin.ch"

static lRegistered := .f.

#define BAR_HEIGHT     28
#define MSGBAR_HEIGHT  25
#define GRAY_BRUSH      2

#define BAR_TOP         1
#define BAR_LEFT        2
#define BAR_RIGHT       3
#define BAR_DOWN        4
#define BAR_FLOAT       5

//----------------------------------------------------------------------------//

CLASS TBar FROM TControl

   DATA   nGroups, nMode
   DATA   nBtnWidth, nBtnHeight
   DATA   l3D

   METHOD New( oWnd, nBtnWidth, nBtnHeight, l3D, cMode, oCursor ) CONSTRUCTOR

   METHOD Add( oBtnBmp ) INLINE  AAdd( ::aControls, oBtnBmp )

   METHOD Adjust() INLINE BarAdjust( ::hWnd, ::nMode, ::oWnd:oMsgBar != nil )

   METHOD BtnAdjust()

   METHOD Display() INLINE ::BeginPaint(), ::Paint(), ::EndPaint(), 0

   METHOD cGenPRG()
   METHOD GetBtnTop( lNewGroup )
   METHOD GetBtnLeft( lNewGroup )

   METHOD Float()
   METHOD GoDown()
   METHOD GoLeft()
   METHOD GoRight()
   METHOD GoTop()

   METHOD RButtonDown( nRow, nCol )

   METHOD MouseMove( nRow, nCol, nKeyFlags ) INLINE ;
                     Super:MouseMove( nRow, nCol, nKeyFlags ),;
                     ::oWnd:SetMsg(), 0

   METHOD Paint()

ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( oWnd, nBtnWidth, nBtnHeight, l3D, cMode, oCursor ) CLASS TBar

   local oRect := oWnd:GetCliRect()

   DEFAULT nBtnWidth := BAR_HEIGHT, nBtnHeight := BAR_HEIGHT,;
           l3D := .f., cMode := "TOP"

   ::nStyle      = nOR( WS_BORDER, WS_CHILD, WS_VISIBLE )
   ::aControls   = {}
   ::nGroups     = 0
   ::oWnd        = oWnd
   ::nTop        = If( cMode == "BOTTOM", oRect:nBottom - nBtnHeight, -1 )
   ::nLeft       = If( cMode == "RIGHT", oRect:nRight - nBtnWidth - ;
                   If( l3D, 3, 0 ), -1 )
   ::nBottom     = If( cMode == "TOP", nBtnHeight, oRect:nBottom + 1 )
   ::nRight      = If( cMode == "TOP" .or. cMode == "BOTTOM",;
                       oRect:nRight,;
                   If( cMode == "LEFT", nBtnWidth + If( l3D, 3, 0 ), oRect:nRight + 1 ) )
   ::nBtnWidth   = nBtnWidth
   ::nBtnHeight  = nBtnHeight
   ::nId         = ::GetNewId()
   ::lDrag       = .f.
   ::lCaptured   = .f.
   ::nClrPane    = If( l3D, CLR_LIGHTGRAY, CLR_GRAY )
   ::lVisible    = .t.
   ::l3D         = l3D
   ::nMode       = AScan( { "TOP", "LEFT", "RIGHT", "BOTTOM", "FLOAT" }, cMode )
   ::oCursor     = oCursor
   ::lValidating = .f.

   ::SetColor( ::nClrText, ::nClrPane )

   if ! lRegistered
      ::Register( nOR( CS_VREDRAW, CS_HREDRAW ) )
      lRegistered = .t.
   endif

   ::Create()

   if oWnd != nil
      oWnd:oBar = Self
   endif

return Self

//----------------------------------------------------------------------------//

METHOD BtnAdjust() CLASS TBar

   local n, nGroups := 0
   local nRow := If( ::l3D, 2, -1 )
   local nCol := If( ::l3D, 2, -1 )

   do case
      case ::nMode == BAR_TOP .or. ::nMode == BAR_DOWN
           for n = 1 to Len( ::aControls )
              nGroups += If( ::aControls[ n ]:lGroup, 1, 0 )
              ::aControls[ n ]:Move( If( ::l3D, 3, 0 ) - 1,;
                                     nCol + ( nGroups * 15 ) )
              ::aControls[ n ]:Refresh()
              nCol    += ::nBtnWidth
           next

      case ::nMode == BAR_LEFT .or. ::nMode == BAR_RIGHT
           for n = 1 to Len( ::aControls )
              nGroups += If( ::aControls[ n ]:lGroup, 1, 0 )
              ::aControls[ n ]:Move( nRow + ( nGroups * 15 ),;
                                     If( ::l3D, 3, 0 ) - 1 )
              ::aControls[ n ]:Refresh()
              nRow    += ::nBtnHeight - If( ::l3D, 3, 0 )
           next

      case ::nMode == BAR_FLOAT
           nRow = 0
           nCol = 0
           for n = 1 to Len( ::aControls )
              ::aControls[ n ]:Move( nRow, nCol )
              nRow = If( nCol == ::nBtnWidth - If( ::l3D, 2, 0 ), nRow + ;
                         ::nBtnHeight - If( ::l3D, 5, -1 ), nRow )
              nCol = If( nCol == 0, ::nBtnWidth - If( ::l3D, 2, 0 ), 0 )
           next

   endcase

return nil

//----------------------------------------------------------------------------//

METHOD cGenPRG() CLASS TBar

   local cPrg := ""
   local n

   cPrg += CRLF + CRLF + "   DEFINE BUTTONBAR oBar OF oWnd " + ;
           If( ::nMode != BAR_TOP,;
               { "LEFT", "RIGHT", "DOWN", "FLOAT" }[ ::nMode ],)

   AEval( ::aControls, { | oCtrl | cPrg += oCtrl:cGenPRG() } )

return cPrg

//----------------------------------------------------------------------------//

METHOD GetBtnLeft( lNewGroup ) CLASS TBar

   local nPos := 0

   do case
      case ::nMode == BAR_TOP .or. ::nMode == BAR_DOWN
           nPos = ( Len( ::aControls ) * ::nBtnWidth ) + ;
                  ( If( lNewGroup, ++::nGroups, ::nGroups ) * 15 ) + ;
                  If( ::l3D, 2, 0 )

      case ::nMode == BAR_LEFT .or. ::nMode == BAR_RIGHT
           nPos = If( ::l3D, 2, 0 )

      case ::nMode == BAR_FLOAT
           nPos = If( Len( ::aControls ) > 0,;
                  If( ATail( ::aControls ):nRight + ::nBtnWidth > ::nRight,;
                      -1, ( Len( ::aControls ) * ::nBtnWidth ) - 1 ), -1 )
   endcase

return nPos

//----------------------------------------------------------------------------//

METHOD GetBtnTop( lNewGroup ) CLASS TBar

   local nPos     := 0
   local nButtons := Len( ::aControls )

   do case
      case ::nMode == BAR_TOP .or. ::nMode == BAR_DOWN
           nPos = If( ::l3D, 2, -1 )

      case ::nMode == BAR_LEFT .or. ::nMode == BAR_RIGHT
           nPos = If( ::l3D, 2, 0 ) + ;
                  ( nButtons * ( ::nBtnHeight - If( ::l3D, 3, 0 ) ) ) + ;
                  ( If( lNewGroup, ++::nGroups, ::nGroups ) * 15 )
   endcase

return nPos

//----------------------------------------------------------------------------//

METHOD RButtonDown( nRow, nCol ) CLASS TBar

   local oMenu
   local aCoors := { nRow, nCol }

   ClientToScreen( ::hWnd, aCoors )

   MENU oMenu POPUP
      MENUITEM "&Top"    ACTION ::GoTop()
      MENUITEM "&Left"   ACTION ::GoLeft()
      MENUITEM "&Right"  ACTION ::GoRight()
      MENUITEM "&Bottom" ACTION ::GoDown()
      SEPARATOR
      MENUITEM "&Float"  ACTION ::Float()
   ENDMENU

   ACTIVATE POPUP oMenu AT aCoors[ 1 ], aCoors[ 2 ] OF Self

return nil

//----------------------------------------------------------------------------//

METHOD GoDown() CLASS TBar

   local oRect

   if ::nMode != BAR_DOWN
      ::nMode = BAR_DOWN
      oRect = ::oWnd:GetCliRect()
      oRect:nBottom -= If( ::oWnd:oMsgBar != nil, MSGBAR_HEIGHT, 0 )
      oRect:nTop = oRect:nBottom - ::nBtnHeight - 1
      oRect:nLeft--
      ::SetCoors( oRect )
      ::BtnAdjust()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GoLeft() CLASS TBar

   local oRect

   if ::nMode != BAR_LEFT
      ::nMode = BAR_LEFT
      oRect = ::oWnd:GetCliRect()
      oRect:nTop--
      oRect:nLeft--
      oRect:nBottom -= If( ::oWnd:oMsgBar != nil, MSGBAR_HEIGHT, 0 )
      oRect:nRight = ::nBtnWidth - 1 + If( ::l3D, 4, 0 )
      ::SetCoors( oRect )
      ::BtnAdjust()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GoRight() CLASS TBar

   local oRect

   if ::nMode != BAR_RIGHT
      ::nMode = BAR_RIGHT
      oRect = ::oWnd:GetCliRect()
      oRect:nTop--
      oRect:nLeft = oRect:nRight - ::nBtnWidth - If( ::l3D, 3, 0 ) - 1
      oRect:nBottom -= If( ::oWnd:oMsgBar != nil, MSGBAR_HEIGHT, 0 )
      ::SetCoors( oRect )
      ::BtnAdjust()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD GoTop() CLASS TBar

   local oRect

   if ::nMode != BAR_TOP
      ::nMode = BAR_TOP
      oRect = ::oWnd:GetCliRect()
      oRect:nTop--
      oRect:nLeft--
      oRect:nBottom = ::nBtnHeight
      ::SetCoors( oRect )
      ::BtnAdjust()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Float() CLASS TBar

   local oWnd
   local oBar := Self
   local n

   if ::nMode != BAR_FLOAT
      ::nMode = BAR_FLOAT

      DEFINE WINDOW oWnd ;
         TITLE "" OF ::oWnd ;
         BORDER NONE ;
         NOZOOM NOICONIZE

      for n = 1 to Len( ::aControls )
         SetParent( ::aControls[ n ]:hWnd, oWnd:hWnd )
      next

      oWnd:Move( 60, 20, ( oBar:nBtnWidth * 2 ) - ;
                 If( ::l3D, 2, -2 ), oBar:nBtnHeight * 8 )
      oWnd:bRClicked = { | nRow, nCol | MsgInfo( "Click" ) }

      ::End()
      SysRefresh()
      ::hWnd = oWnd:hWnd

      ::BtnAdjust()
      oWnd:Show()
      oWnd:SetFocus()
   endif

return nil

//----------------------------------------------------------------------------//

METHOD Paint() CLASS TBar

   if ! ::l3D
      Super:Paint()
   else
      WndRaised( ::hWnd, ::hDC )
   endif

return nil

//----------------------------------------------------------------------------//
