// FiveWin - RC from DBF generator !!! Use it for quickly developing Dialogs

/*
!short: Introduction
Start the program, drag and drop a dbf file onto the icon and
this program will generate a resource file for you which contains a
dialog based upon the database you droped on it.  Optional Buttons too!

Very Cool!

First written by Antonio Linares, modified and extended by John Stolte,
finished and polished up by Jeff Heisler.
*/

#include "FiveWin.ch"

//----------------------------------------------------------------------------//

function Main()
   local oBar
	local oBrush, oIco
	local hBorland := LoadLibrary( "BWCC.dll" )

	SET RESOURCES TO "autolay.dll"                  // Personal DLL

	SET 3DLOOK ON                                 // CTL3D

	DEFINE BRUSH oBrush STYLE BORLAND

	DEFINE ICON oIco RESNAME "AUTOLAY"

	DEFINE WINDOW oWnd FROM 0,0 TO 24,79 ;
		TITLE "Drag & Drop DBF Layout Builder With FiveWin" ;
		BRUSH oBrush ;
		ICON  oIco ;
		MDI ;
		MENU BuildMenu() ;
		MENUINFO 2                                 // Where Windows will report of MdiChild

	 DEFINE BUTTONBAR oBar SIZE 33,33 OF oWnd
	 DEFINE BUTTON RESOURCE 'HELP' GROUP OF oBar MESSAGE "Help About" ;
		     ACTION MsgAbout( "D&D","Drag & Drop DBF Layout")
	 DEFINE BUTTON RESOURCE 'WORKSHOP' GROUP OF oBar MESSAGE "Run The Borland Workshop" ;
		     ACTION winexec("workshop.exe")
	 DEFINE BUTTON RESOURCE 'EXIT' GROUP OF oBar MESSAGE "Exit";
           ACTION oWnd:end()

	 DEFINE MESSAGE BAR OF oWnd PROMPT "Drag and Drop With FiveWin" CENTERED

	 ACTIVATE WINDOW oWnd ICONIZED ;
      ON DROPFILES TakeDrop( aFiles );
      ON INIT	sethandlecount(99)

	SET RESOURCES TO                              // Close DLL
	FreeLibrary( hBorland )                       // Release borland

return nil

//----------------------------------------------------------------------------//

static function BuildMenu()

   local oMenu

   MENU oMenu
	  MENUITEM "&File"
		 MENU
		 MENUITEM "&Open"                     MESSAGE "Open a DBF File";
			ACTION lay(cGetFile( "*.dbf", "Select a DBF" ),1)
		 MENUITEM "&Exit"                    MESSAGE "Exit Drag & Drop";
           ACTION oWnd:end()
		 ENDMENU
	  oMenu:addmdi()                                // This is a standard windows menu
	  MENUITEM "&Help"                      MESSAGE "Help on This Prgram"
	    MENU
			MENUITEM "&Contents"               MESSAGE "Help on This Prgram"
			MENUITEM "&Search for Help on..."  MESSAGE "Help on This Prgram"
			SEPARATOR
	      MENUITEM "&About"                 MESSAGE "Info About this Program" ;
		     ACTION MsgAbout( "D&D","Drag & Drop DBF Layout Builder")
		 ENDMENU
	ENDMENU

return oMenu

Static function TakeDrop( aFiles )

   local n, lBrowsed := .F.
	oWnd:maximize()

   for n = 1 to Len( aFiles )
      if Right( aFiles[ n ], 3 ) != "DBF"
         MsgAlert( "Sorry I only Layout DBF files!!!" )
      else
		   cursorwait()
			lBrowsed := .T.
         lay(aFiles[ n ], len(aFiles)  )
	      cursorarrow()
      endif
   next

return nil

static function Lay(cTemp,nFiles)

	local oDlg, oGet
	local cDbfName := Space( 40 )

	IIF(!empty(cTemp),cDbfName := cTemp, )

	DEFINE DIALOG oDlg RESOURCE "Dbf2RC"

	REDEFINE GET oGet VAR cDbfName ID 110 OF oDlg

	REDEFINE BUTTON ID 120 OF oDlg ;
		ACTION ( cTemp := cGetFile( "*.dbf", "Select a DBF" ),;
		If( ! Empty( cTemp ), ( cDbfName := cTemp, oGet:Refresh() ),))

	REDEFINE BUTTON ID 1 OF oDlg ACTION ( CursorWait(), GenRC( cDbfName, nFiles ), CursorArrow(), oDlg:End() )

	REDEFINE BUTTON ID 2 OF oDlg ACTION oDlg:End()

	ACTIVATE DIALOG oDlg CENTERED

return nil

//----------------------------------------------------------------------------//

function GenRC( cDbfName, nFiles )

	local n, nId := 110
	local cRC := "", cCH := "", cButton := ""
	local aFields, cRow
	local cRCFile := ""
	local lButton := .F.
	if Empty( cDbfName ) .or. ! File( cDbfName )
		MsgAlert( "Please select a DBF file first!" )
		return nil
	endif

	cursorwait()

	USE ( cDbfName )
	aFields = DbStruct()

	IF MsgYesNo("Do You want buttons on the bottom of the Dialog?","Buttons?")
		lButton := .T.
		cRC += '#define BITMAP_10	10'     + CRLF
		cRC += '#define BITMAP_9	9 '     + CRLF
		cRC += '#define BITMAP_8	8 '     + CRLF
		cRC += '#define BITMAP_7	7 '     + CRLF
		cRC += '#define BITMAP_6	6 '     + CRLF
		cRC += '#define BITMAP_5	5 '     + CRLF
		cRC += '#define BITMAP_3	3 '     + CRLF
		cRC += '#define BITMAP_2	2 '     + CRLF
		cRC += '#define BITMAP_1	1 '     + CRLF
	ENDIF

        cRC += '#include "..\include\WinApi.ch"' + CRLF
	cRC += '#include "' + Alias() + '.ch"' + CRLF + CRLF
	cRC += Alias() + " DIALOG 32, 18, 236," + ;
		Str( ( Len( aFields ) * 14) + IIF(lButton,43 ,20), 4 ) + CRLF
	cRC += "STYLE DS_MODALFRAME | WS_POPUP | WS_CAPTION | WS_SYSMENU" + CRLF
	cRC += 'CAPTION "' + Alias() + '"' + CRLF
	cRC += 'FONT 8, "Arial"' + CRLF
	cRC += "BEGIN" + CRLF

	for n = 1 to Len( aFields )
		cCH += "#define ID_" + PadR( aFields[ n ][ 1 ], 11 ) + ;
			Str( nId, 4 ) + CRLF

		do case

			case aFields[ n ][ 2 ] $ "CND"
				cRC += '   LTEXT "' + aFields[ n ][ 1 ] + '"' + ;
					Space( 10 - Len( aFields[ n ][ 1 ] ) ) + ", -1, 3," + ;
					Str( 5 + 14 * ( n - 1 ), 4 ) + ", 41, 8" + CRLF

				cRC += "   EDITTEXT ID_" + aFields[ n ][ 1 ] + ;
					", 45," + Str( 3 + 14 * ( n - 1 ), 4 ) + ", " + ;
					Str( aFields[ n ][ 3 ] * 7, 4 ) + ", 12" + CRLF

			case aFields[ n ][ 2 ] == "L"
				cRC += '   CONTROL "' + aFields[ n ][ 1 ] + ;
					'", ID_' + aFields[ n ][ 1 ] + ;
					', "BUTTON", BS_AUTOCHECKBOX | WS_CHILD | WS_VISIBLE | WS_TABSTOP, ' + ;
					"45, " + Str( 3 + 14 * ( n - 1 ), 4 ) + ;
					", 50, 12" + CRLF

			case aFields[ n ][ 2 ] == "M"
				cRC += '   LTEXT "' + aFields[ n ][ 1 ] + '"' + ;
					Space( 10 - Len( aFields[ n ][ 1 ] ) ) + ", -1, 100," + ;
					Str( 5 + 14 * ( n - 1 ), 4 ) + ", 41, 8" + CRLF

				//            cRC += '   CONTROL "' + aFields[ n ][ 1 ] + ;
				cRC += '   CONTROL "' + "" + ;
					'", ID_' + aFields[ n ][ 1 ] + ;
					', "EDIT", ES_LEFT | ES_MULTILINE | ES_WANTRETURN | WS_CHILD | WS_VISIBLE | WS_BORDER | WS_VSCROLL | WS_TABSTOP , ' + ;
					"145, " + Str( 3 + 14 * ( n - 1 ), 4 ) + ", "  + "77, 63" + CRLF
				//^^^ gotta put out to the right somewhere so you can see it
				//    and not sit under a bunch of other controls
		endcase

		nId += 10

	next

	IF lButton
		cRow := alltrim(str(len(aFields)*14+12))
		cRC += 'CONTROL "Button", 1,  "BorBtn", BS_DEFPUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 1,'+ cRow +', 37, 23   '     + CRLF
		cRC += 'CONTROL "Button", 2,  "BorBtn", BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 50,'+ cRow +', 37, 23     '     + CRLF
		cRC += 'CONTROL "Button", 90, "BorBtn", BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 99,'+ cRow +', 37, 23    '     + CRLF
		cRC += 'CONTROL "Button", 91, "BorBtn", BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 148,'+ cRow +', 37, 23    '     + CRLF
		cRC += 'CONTROL "Button", 92, "BorBtn", BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP, 197,'+ cRow +', 37, 23    '     + CRLF
	ENDIF

	cRC += "END" + CRLF

	IF lButton
		cButton := button()
	ENDIF

	MemoWrit( Alias() + ".ch", cCH )

	cRCFile := alias() + ".rc"


	cursorarrow()

	IF !file(Alias() + ".rc")
		cursorwait()
		IF lButton
			MemoWrit( alias() + ".rc", cRC + cButton )
		ELSE
			MemoWrit( alias() + ".rc", cRC )
		ENDIF
	ELSEIF MsgYesno("That Resource Already Exists - Overwrite it?", "OOPS")
		cursorwait()
		IF lButton
			MemoWrit( alias() + ".rc", cRC + cButton )
		ELSE
			MemoWrit( alias() + ".rc", cRC )
		ENDIF
	ELSE
		msgstop("Rename the existing " + cRCFile + " and try again")
	ENDIF

	cursorarrow()

	IF nFiles == 1
	 WinExec( "workshop" + " " + cRCFile )
	ENDIF

	USE

return nil

static function Button
return(but1()+but2()+but3()+but4()+but5()+but6()+but7()+but8()+but9())

/*
!short: Data... */

Static function but1
	local cB1 := ""
		cB1 += "1090 BITMAP                                       "   + CRLF
		cB1 += "{                                                 "   + CRLF
		cB1 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB1 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB1 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB1 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB1 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB1 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB1 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB1 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB1 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB1 += " '00 00 00 00 00 07 07 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB1 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB1 += " '88 88 88 88 88 07 0F 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB1 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB1 += " '88 88 88 88 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB1 += " '88 87 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 08 0F 77 77 77 77 77 77 77 78 88'"   + CRLF
		cB1 += " '88 87 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 78 88 80'"   + CRLF
		cB1 += " '08 87 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 78 88 80 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 77 70 77 70 00 77 77 07 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 78 88 80 00 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 77 70 77 07 77 07 77 07 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 0A 0F 77 77 77 77 88 80 00 00 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 77 70 77 07 77 77 70 70 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 0A 0F 77 77 77 77 80 00 00 00 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 77 70 77 00 00 07 70 70 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 08 0F 77 77 77 70 00 00 00 00 00'"   + CRLF
		cB1 += " '08 87 77 77 00 00 07 70 77 07 77 07 07 77 07 77'"   + CRLF
		cB1 += " '77 77 77 77 88 08 0F 77 77 77 70 00 00 00 00 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 70 70 07 70 00 77 07 77 07 77'"   + CRLF
		cB1 += " '77 77 77 77 88 08 0F 77 77 77 77 70 00 00 00 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 70 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 70 00 00 00'"   + CRLF
		cB1 += " '08 87 77 77 07 77 70 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 70 00 00'"   + CRLF
		cB1 += " '08 87 77 77 00 00 07 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 70 00'"   + CRLF
		cB1 += " '08 87 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 70'"   + CRLF
		cB1 += " '07 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 00 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 0F 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 0F 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 0F 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 00 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 01 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB1 += " '77 77 77 77 88 01 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB1 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB1 += " 'FF FF FF FF 78 0F 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB1 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB1 += " 'FF FF FF FF F7 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB1 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB1 += " '00 00 00 00 00 06'                              "   + CRLF
		cB1 += "}                                                 "   + CRLF
		cB1 += "                                                  "   + CRLF
		cB1 += "                                                  "   + CRLF
return(cB1)

/*
!short: Data... */

Static function but2
	local cB2 := ""
		cB2 += "1091 BITMAP                                       "   + CRLF
		cB2 += "{                                                 "   + CRLF
		cB2 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB2 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB2 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB2 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB2 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB2 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB2 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB2 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB2 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB2 += " '00 00 00 00 00 0A 07 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB2 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB2 += " '88 88 88 88 88 0A 0F 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB2 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB2 += " '88 88 88 88 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 87 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 88 87 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 08 88 87 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 08 88 87'"   + CRLF
		cB2 += " '77 77 77 77 07 77 70 77 70 00 77 07 70 77 07 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 08 88'"   + CRLF
		cB2 += " '87 77 77 77 07 77 00 77 07 77 07 07 70 70 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 00 08'"   + CRLF
		cB2 += " '88 77 77 77 07 77 00 77 07 77 77 70 07 70 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB2 += " '08 77 77 77 07 70 70 77 00 00 07 70 07 70 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB2 += " '00 07 77 77 07 07 70 77 07 77 07 07 70 70 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB2 += " '00 07 77 77 07 07 70 77 70 00 77 07 70 70 07 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB2 += " '07 77 77 77 00 77 70 77 77 77 77 77 77 70 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 00 07'"   + CRLF
		cB2 += " '77 77 77 77 00 77 70 77 77 77 77 77 77 70 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 00 07 77'"   + CRLF
		cB2 += " '77 77 77 77 07 77 70 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 00 07 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 07 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB2 += " '77 77 77 77 88 0A 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB2 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB2 += " 'FF FF FF FF 78 0A 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB2 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB2 += " 'FF FF FF FF F7 0A 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB2 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB2 += " '00 00 00 00 00 0A'                              "   + CRLF
		cB2 += "}                                                 "   + CRLF
		cB2 += "                                                  "   + CRLF
		cB2 += "                                                  "   + CRLF
		return(cB2)

/*
!short: Data... */

Static function but3
	local cB3 := ""
		cB3 += "3090 BITMAP                                       "   + CRLF
		cB3 += "{                                                 "   + CRLF
		cB3 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB3 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB3 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB3 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB3 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB3 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB3 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB3 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB3 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB3 += " '00 00 00 00 00 07 08 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB3 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB3 += " '88 88 88 88 88 07 08 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB3 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB3 += " '88 88 88 88 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '78 88 77 87 87 87 87 87 87 87 87 87 87 87 87 87'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB3 += " '88 88 78 77 77 77 77 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 78 88'"   + CRLF
		cB3 += " '88 88 77 77 07 77 77 70 77 70 00 77 77 07 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 78 88 80'"   + CRLF
		cB3 += " '08 88 78 77 07 77 77 70 77 07 77 07 77 07 77 78'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 78 88 80 00'"   + CRLF
		cB3 += " '08 88 77 77 07 77 77 70 77 07 77 77 70 70 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 0F 08 77 77 77 77 78 88 80 00 00'"   + CRLF
		cB3 += " '08 88 78 77 07 77 77 70 77 00 00 07 70 70 77 78'"   + CRLF
		cB3 += " '77 77 77 77 88 0F 08 77 77 77 77 77 70 00 00 00'"   + CRLF
		cB3 += " '08 88 77 77 00 00 07 70 77 07 77 07 07 77 07 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 70 00 00 00 00'"   + CRLF
		cB3 += " '08 88 78 77 07 77 70 70 07 70 00 77 07 77 07 78'"   + CRLF
		cB3 += " '77 77 77 77 88 0F 08 77 77 77 70 00 00 00 00 00'"   + CRLF
		cB3 += " '08 88 77 77 07 77 70 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 0F 08 77 77 77 70 00 00 00 00 00'"   + CRLF
		cB3 += " '08 88 78 77 07 77 70 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 70 00 00 00 00'"   + CRLF
		cB3 += " '07 88 77 77 00 00 07 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 70 00 00 00'"   + CRLF
		cB3 += " '07 88 78 77 77 77 77 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 70 00 00'"   + CRLF
		cB3 += " '07 78 77 87 87 87 87 87 87 87 87 87 87 87 87 87'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 70 00'"   + CRLF
		cB3 += " '07 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 70'"   + CRLF
		cB3 += " '07 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 0F 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 01 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 88 01 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB3 += " '77 77 77 77 78 0F 08 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB3 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB3 += " '88 88 88 88 88 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB3 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB3 += " '00 00 00 00 00 06'                              "   + CRLF
		cB3 += "}                                                 "   + CRLF
		cB3 += "                                                  "   + CRLF
		cB3 += "                                                  "   + CRLF
		return(cB3)

/*
!short: Data... */

Static function but4
	local cB4 := ""
		cB4 += "3091 BITMAP                                       "   + CRLF
		cB4 += "{                                                 "   + CRLF
		cB4 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB4 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB4 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB4 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB4 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB4 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB4 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB4 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB4 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB4 += " '00 00 00 00 00 05 08 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB4 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB4 += " '88 88 88 88 88 05 08 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB4 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB4 += " '88 88 88 88 88 05 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 0C 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 87 77 77 77'"   + CRLF
		cB4 += " '77 77 77 87 87 87 87 87 87 87 87 87 87 87 87 87'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 88 87 77 77'"   + CRLF
		cB4 += " '77 77 78 77 77 77 77 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 88 88 87 77'"   + CRLF
		cB4 += " '77 77 77 77 07 77 70 77 70 00 77 07 70 77 07 77'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 08 88 88 87'"   + CRLF
		cB4 += " '77 77 78 77 07 77 00 77 07 77 07 07 70 70 77 78'"   + CRLF
		cB4 += " '77 77 77 77 88 05 08 77 77 77 77 77 00 08 88 88'"   + CRLF
		cB4 += " '87 77 77 77 07 77 00 77 07 77 77 70 07 70 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 08 88'"   + CRLF
		cB4 += " '88 77 78 77 07 70 70 77 00 00 07 70 07 70 77 78'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 00 07'"   + CRLF
		cB4 += " '78 77 77 77 07 07 70 77 07 77 07 07 70 70 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB4 += " '07 77 78 77 07 07 70 77 70 00 77 07 70 70 07 78'"   + CRLF
		cB4 += " '77 77 77 77 88 0F 08 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB4 += " '00 07 77 77 00 77 70 77 77 77 77 77 77 70 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB4 += " '00 07 78 77 00 77 70 77 77 77 77 77 77 70 77 78'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 00 00'"   + CRLF
		cB4 += " '07 77 77 77 07 77 70 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 00 07'"   + CRLF
		cB4 += " '77 77 78 77 77 77 77 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 00 07 77'"   + CRLF
		cB4 += " '77 77 77 87 87 87 87 87 87 87 87 87 87 87 87 87'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 00 07 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 07 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 0F 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 01 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 01 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 0F 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 06 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 00 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 0B 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 88 07 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB4 += " '77 77 77 77 78 0F 08 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB4 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB4 += " '88 88 88 88 88 09 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB4 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB4 += " '00 00 00 00 00 01'                              "   + CRLF
		cB4 += "}                                                 "   + CRLF
		cB4 += "                                                  "   + CRLF
		cB4 += "                                                  "   + CRLF
		return(cB4)

/*
!short: Data... */

Static function but5
	local cB5 := ""
		cB5 += "5090 BITMAP                                       "   + CRLF
		cB5 += "{                                                 "   + CRLF
		cB5 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB5 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB5 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB5 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB5 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB5 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB5 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB5 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB5 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB5 += " '00 00 00 00 00 0A 07 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB5 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB5 += " '88 88 88 88 88 0A 0F 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB5 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB5 += " '88 88 88 88 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 78'"   + CRLF
		cB5 += " '88 87 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 78 88'"   + CRLF
		cB5 += " '88 87 77 87 87 87 87 87 87 87 87 87 87 87 88 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 78 88 80'"   + CRLF
		cB5 += " '08 87 78 77 77 77 77 77 77 77 77 77 77 77 77 87'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 78 88 80 00'"   + CRLF
		cB5 += " '08 87 77 70 77 77 77 07 77 00 07 77 70 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 78 88 80 00 00'"   + CRLF
		cB5 += " '08 87 78 70 77 77 77 07 70 77 70 77 70 77 77 87'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 88 80 00 00 00'"   + CRLF
		cB5 += " '08 87 77 70 77 77 77 07 70 77 77 77 07 07 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 80 00 00 00 00'"   + CRLF
		cB5 += " '08 87 78 70 77 77 77 07 70 00 00 77 07 07 77 87'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 70 00 00 00 00 00'"   + CRLF
		cB5 += " '08 87 77 70 00 00 77 07 70 77 70 70 77 70 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 70 00 00 00 00 00'"   + CRLF
		cB5 += " '08 87 78 70 77 77 07 00 77 00 07 70 77 70 77 87'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 70 00 00 00 00'"   + CRLF
		cB5 += " '08 87 77 70 77 77 07 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 70 00 00 00'"   + CRLF
		cB5 += " '08 87 78 70 77 77 07 77 77 77 77 77 77 77 77 87'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 70 00 00'"   + CRLF
		cB5 += " '08 87 77 70 00 00 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 70 00'"   + CRLF
		cB5 += " '08 87 78 77 77 77 77 77 77 77 77 77 77 77 77 87'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 70'"   + CRLF
		cB5 += " '07 77 77 87 87 87 87 87 78 78 78 78 78 78 78 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB5 += " '77 77 77 77 88 0A 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB5 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB5 += " 'FF FF FF FF 78 0A 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB5 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB5 += " 'FF FF FF FF F7 0A 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB5 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB5 += " '00 00 00 00 00 0A'                              "   + CRLF
		cB5 += "}                                                 "   + CRLF
		cB5 += "                                                  "   + CRLF
		cB5 += "                                                  "   + CRLF
		return(cB5)

/*
!short: Data... */

Static function but6
	local cB6 := ""
		cB6 += "5091 BITMAP                                       "   + CRLF
		cB6 += "{                                                 "   + CRLF
		cB6 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB6 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB6 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB6 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB6 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB6 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB6 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB6 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB6 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB6 += " '00 00 00 00 00 0F 07 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB6 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB6 += " '88 88 88 88 88 0F 0F 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB6 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB6 += " '88 88 88 88 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 87 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 88 87 77 77'"   + CRLF
		cB6 += " '77 77 77 87 87 87 87 87 87 87 87 87 87 87 87 87'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 08 88 87 77'"   + CRLF
		cB6 += " '77 77 78 77 77 77 77 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 08 88 87'"   + CRLF
		cB6 += " '77 77 77 77 07 77 70 77 70 00 77 07 70 77 07 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 08 88'"   + CRLF
		cB6 += " '87 77 78 77 07 77 00 77 07 77 07 07 70 70 77 78'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 00 08'"   + CRLF
		cB6 += " '88 77 77 77 07 77 00 77 07 77 77 70 07 70 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 00 00'"   + CRLF
		cB6 += " '08 77 78 77 07 70 70 77 00 00 07 70 07 70 77 78'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 00 00'"   + CRLF
		cB6 += " '00 07 77 77 07 07 70 77 07 77 07 07 70 70 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 00 00'"   + CRLF
		cB6 += " '00 07 78 77 07 07 70 77 70 00 77 07 70 70 07 78'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 00 00'"   + CRLF
		cB6 += " '07 77 77 77 00 77 70 77 77 77 77 77 77 70 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 00 07'"   + CRLF
		cB6 += " '77 77 78 77 00 77 70 77 77 77 77 77 77 70 77 78'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 00 07 77'"   + CRLF
		cB6 += " '77 77 77 77 07 77 70 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 00 07 77 77'"   + CRLF
		cB6 += " '77 77 78 77 77 77 77 77 77 77 77 77 77 77 77 78'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 07 77 77 77'"   + CRLF
		cB6 += " '77 77 77 87 87 87 87 87 87 87 87 87 87 87 87 87'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 00 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 00 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 00 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 00 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 0F 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 00 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 01 0F F7 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB6 += " '77 77 77 77 88 01 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB6 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB6 += " 'FF FF FF FF 78 0F 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB6 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB6 += " 'FF FF FF FF F7 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB6 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB6 += " '00 00 00 00 00 06'                              "   + CRLF
		cB6 += "}                                                 "   + CRLF
		cB6 += "                                                  "   + CRLF
		cB6 += "                                                  "   + CRLF
		return(cB6)

/*
!short: Data... */

Static function but7
	local cB7 := ""
		cB7 += "1092 BITMAP                                       "   + CRLF
		cB7 += "{                                                 "   + CRLF
		cB7 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB7 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB7 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB7 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB7 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB7 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB7 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 0A 07 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB7 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB7 += " '88 88 88 88 88 0A 0F 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB7 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB7 += " '88 88 88 88 88 0A 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 07 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 77 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 88 88 88 88 88 88 78 78'"   + CRLF
		cB7 += " '88 88 88 88 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB7 += " '08 80 70 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 70 88 08 70 78'"   + CRLF
		cB7 += " '07 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB7 += " '08 80 70 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB7 += " '08 70 70 80 80 77 70 00 07 77 77 00 07 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 07 80 78 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 70 77 70 77 70 77 70 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 07 80 78 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 70 77 77 07 70 77 77 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB7 += " '07 80 80 80 80 77 70 77 77 07 70 00 00 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 70 88 08 70 78'"   + CRLF
		cB7 += " '08 80 70 80 80 77 70 77 77 07 70 77 70 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 70 77 77 07 77 00 07 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 70 77 77 07 77 77 77 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB7 += " '08 70 80 80 80 77 70 77 70 77 77 77 77 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 70 80 80 77 70 00 07 77 77 77 77 70 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 70 78 08 70 78'"   + CRLF
		cB7 += " '07 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB7 += " '08 80 70 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 88 88 88 88 88 88 78 78'"   + CRLF
		cB7 += " '88 88 88 88 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 07 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 77 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 08 88 88 88 88 88 88 88 88'"   + CRLF
		cB7 += " '88 88 88 88 88 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 07 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 77 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 07 77 77 77'"   + CRLF
		cB7 += " '07 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F 77 77 77 77 77 70 00 00 00'"   + CRLF
		cB7 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB7 += " '77 77 77 77 88 0A 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB7 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB7 += " 'FF FF FF FF 78 0A 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB7 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB7 += " 'FF FF FF FF F7 0A 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB7 += " '00 00 00 00 00 0A'                              "   + CRLF
		cB7 += "}                                                 "   + CRLF
		cB7 += "                                                  "   + CRLF
		cB7 += "                                                  "   + CRLF
		return(cB7)

/*
!short: Data... */

Static function but8
	local cB8 := ""
		cB8 += "3092 BITMAP                                       "   + CRLF
		cB8 += "{                                                 "   + CRLF
		cB8 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB8 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB8 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB8 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB8 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB8 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB8 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB8 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB8 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB8 += " '00 00 00 00 00 0A 08 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB8 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB8 += " '88 88 88 88 88 0A 08 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB8 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB8 += " '88 88 88 88 88 0A 08 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 77 00 00 00 00 00 00 00 00'"   + CRLF
		cB8 += " '00 07 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 08 08 80 80 88 08 80 00'"   + CRLF
		cB8 += " '00 00 07 00 00 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 88 08 80 88 08 80 88 03'"   + CRLF
		cB8 += " '33 33 30 03 30 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 00'"   + CRLF
		cB8 += " '00 03 33 33 30 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '77 00 03 33 30 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '08 48 88 88 80 77 87 87 87 87 87 87 87 87 87 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '08 48 84 84 80 77 77 77 77 77 77 77 77 77 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '08 44 84 84 40 78 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '08 44 84 84 40 77 70 00 07 77 77 00 07 70 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '00 84 84 44 40 78 70 77 70 77 70 77 70 70 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 88 40 77 70 77 77 07 70 77 77 70 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 88 40 78 70 77 77 07 70 00 00 70 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 44 40 77 70 77 77 07 70 77 70 70 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 48 40 78 70 77 77 07 77 00 07 70 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 84 40 77 70 77 77 07 77 77 77 70 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 44 40 78 70 77 70 77 77 77 77 70 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 70 77 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 84 40 77 70 00 07 77 77 77 77 70 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 00 07 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 84 40 78 77 77 77 77 77 77 77 77 78 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 07 07 70 77 07 70 77 07'"   + CRLF
		cB8 += " '70 84 84 84 40 77 87 87 87 87 87 87 87 87 87 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 00 07 08 08 80 88 08 80 80 07'"   + CRLF
		cB8 += " '70 84 84 84 40 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 00 07 00 00 00 00 00 00 00 07'"   + CRLF
		cB8 += " '70 84 84 44 40 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 00 00 EE 0F B0 BF B0 33 07'"   + CRLF
		cB8 += " '70 84 84 44 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 E0 0B FB FB 00 00 07'"   + CRLF
		cB8 += " '70 84 84 84 40 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 0F BF BF B0 30 70 07'"   + CRLF
		cB8 += " '70 84 84 44 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 FB FB FB 00 30 00 77'"   + CRLF
		cB8 += " '70 84 88 44 44 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 BF BF B0 B0 00 07 77'"   + CRLF
		cB8 += " '70 08 44 44 44 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 0B FB 0B 70 77 77 77'"   + CRLF
		cB8 += " '77 00 84 44 44 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 70 B0 B7 07 77 77 77'"   + CRLF
		cB8 += " '77 70 88 44 44 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 77 00 70 77 77 77 77'"   + CRLF
		cB8 += " '77 77 08 84 44 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 77 77 07 77 77 77 77'"   + CRLF
		cB8 += " '77 77 70 84 44 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 07 70 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 08 88 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 88 0A 08 00 00 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB8 += " '77 77 77 77 78 0A 08 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB8 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB8 += " '88 88 88 88 88 0A 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB8 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB8 += " '00 00 00 00 00 0A'                              "   + CRLF
		cB8 += "}                                                 "   + CRLF
		cB8 += "                                                  "   + CRLF
		cB8 += "                                                  "   + CRLF
		return(cB8)

/*
!short: Data... */

Static function but9
	local cB9 := ""
		cB9 += "5093 BITMAP                                       "   + CRLF
		cB9 += "{                                                 "   + CRLF
		cB9 += " '42 4D 56 05 00 00 00 00 00 00 76 00 00 00 28 00'"   + CRLF
		cB9 += " '00 00 3F 00 00 00 27 00 00 00 01 00 04 00 00 00'"   + CRLF
		cB9 += " '00 00 E0 04 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 10 00 00 00 00 00 00 00 00 00 80 00 00 80'"   + CRLF
		cB9 += " '00 00 00 80 80 00 80 00 00 00 80 00 80 00 80 80'"   + CRLF
		cB9 += " '00 00 C0 C0 C0 00 80 80 80 00 00 00 FF 00 00 FF'"   + CRLF
		cB9 += " '00 00 00 FF FF 00 FF 00 00 00 FF 00 FF 00 FF FF'"   + CRLF
		cB9 += " '00 00 FF FF FF 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 07 07 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB9 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB9 += " '88 88 88 88 88 07 0F 78 88 88 88 88 88 88 88 88'"   + CRLF
		cB9 += " '88 88 88 88 88 88 88 88 88 88 88 88 88 88 88 88'"   + CRLF
		cB9 += " '88 88 88 88 88 07 0F 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 07 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 77 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 88 88 88 88 88 88 78 78'"   + CRLF
		cB9 += " '88 88 88 88 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB9 += " '08 80 70 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 08 70 88 08 70 78'"   + CRLF
		cB9 += " '07 80 80 80 80 77 87 87 87 87 87 87 87 87 87 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB9 += " '08 80 70 80 80 77 77 77 77 77 77 77 77 77 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 78 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB9 += " '08 70 70 80 80 77 70 00 07 77 77 00 07 70 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F 70 80 88 07 80 78 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 78 70 77 70 77 70 77 70 70 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 0F 0F 70 80 88 07 80 78 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 77 70 77 77 07 70 77 77 70 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 0F 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB9 += " '07 80 80 80 80 78 70 77 77 07 70 00 00 70 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 08 70 88 08 70 78'"   + CRLF
		cB9 += " '08 80 70 80 80 77 70 77 77 07 70 77 70 70 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 01 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 78 70 77 77 07 77 00 07 70 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 77 70 77 77 07 77 77 77 70 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 07 80 88 08 70 78'"   + CRLF
		cB9 += " '08 70 80 80 80 78 70 77 70 77 77 77 77 70 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 70 80 80 77 70 00 07 77 77 77 77 70 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 08 80 78 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 78 77 77 77 77 77 77 77 77 78 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 80 80 80 77 87 87 87 87 87 87 87 87 87 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 80 88 08 70 78 08 70 78'"   + CRLF
		cB9 += " '07 80 80 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 0F 0F 70 80 88 08 80 88 08 70 78'"   + CRLF
		cB9 += " '08 80 70 80 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 88 88 88 88 88 88 78 78'"   + CRLF
		cB9 += " '88 88 88 88 80 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 01 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 01 0F 07 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 77 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 0F 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 08 88 88 88 88 88 88 88 88'"   + CRLF
		cB9 += " '88 88 88 88 88 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 06 0F 07 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 77 07 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 70 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 00 0F 77 77 77 77 77 07 77 77 77'"   + CRLF
		cB9 += " '07 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 0B 0F 77 77 77 77 77 70 00 00 00'"   + CRLF
		cB9 += " '77 77 77 77 77 77 77 77 77 77 77 77 77 77 77 77'"   + CRLF
		cB9 += " '77 77 77 77 88 07 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB9 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB9 += " 'FF FF FF FF 78 0F 0F FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB9 += " 'FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF FF'"   + CRLF
		cB9 += " 'FF FF FF FF F7 09 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00'"   + CRLF
		cB9 += " '00 00 00 00 00 01'                              "   + CRLF
		cB9 += "}                                                 "   + CRLF

return(cB9)


