/*  $FUNCNAME$
 *  GlobalAddAtom()
 *  $CATEGORY$
 *  WinApi
 *  $ONELINER$
 *  Adds a new atom to the Windows public atom list and returns an unique value
 *  $SYNTAX$
 *
 *     GlobalAddAtom( <cText> )  -->  <nIdentifier>
 *
 *  $ARGUMENTS$
 *
 *  <cText>     Is the string to be added to the Windows global atom list.
 *
 *  $RETURNS$
 *
 *  <nIdentifier>  Is a numeric value which represents the unique identifier
 *                 of the <cText> string.
 *
 *  $DESCRIPTION$
 *
 *  This is a Windows API function. Basicly this system is based on a
 *  a hash table that Windows keeps. In other words: We provide a string
 *  and WIndows returns a unique number. Lately Windows may use again this
 *  number to get back the string again.
 *
 *  $EXAMPLES$
 *
 *  ? GlobalAddAtom( "Hello" )
 *
 *  $SEEALSO$
 *
 *  AddAtom() GlobalDeleteAtom() GlobalGetAtomName()
 *
 *  $END$
 */

#include <WinTen.h>
#include <Windows.h>
#include <ClipApi.h>

//----------------------------------------------------------------------------//

CLIPPER GLOBALADDA()    // TOM()
{
   _retni( GlobalAddAtom( _parc( 1 ) ) );
}

//----------------------------------------------------------------------------//

CLIPPER GLOBALGETA() // TOMNAME( hAtom )  --> cAtom
{
   BYTE bBuffer[ 255 ];

   _retclen( bBuffer, GlobalGetAtomName( ( ATOM ) _parnl( 1 ), bBuffer, 254 ) );
}

//----------------------------------------------------------------------------//
