//===========================================================
// DKICK.H -- Header File 
// Copyright (c) 1995 Douglas Boling
//===========================================================
// Returns no. of elements
#define dim(x) (sizeof(x) / sizeof(x[0]))   

#define  MAXMENULEN        40
#define  MAXCMDLINELEN     256
#define  MAXENTRIES        32

//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#define INT       int
#define APIENTRY  PASCAL
//
// Error numbers
//
#define ERR_LAUNCH        16
#define ERR_DOS           64

#define ERR_NOCMDLINE     -1
#define ERR_MAXSCH        -2
#define ERR_NOSCHSEL      -3
#define ERR_NOMENUNAME    -4
//
// Flags
//
#define SCH_ERROR     0x01
#define SCH_ICON      0x02

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
//
// Program entry foramt
//
typedef struct {
	char	szMenu[MAXMENULEN];
	char	szCmd[MAXCMDLINELEN];
	char	szDir[MAXCMDLINELEN];
	UINT	fFlags;
} PROGENTRY;
typedef PROGENTRY *PPROGENTRY;
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HINSTANCE, HINSTANCE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc(HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, DLGPROC, LPARAM);
void PrintError (HWND, INT);
BOOL MyGetFilename (HWND, char *, INT, char *, INT);
BOOL MyWritePrivateProfileInt (char *, char *, int, char *);
//
// Program specific prototypes
//
// Dialog box functions
BOOL CALLBACK AddDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK ConfigDlgProc (HWND, UINT, UINT, LONG);
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoLaunchMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoDropFilesMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainCtlProgList (HWND, UINT, HWND, UINT);
LONG DoMainCtlAdd (HWND, UINT, HWND, UINT);
LONG DoMainCtlDel (HWND, UINT, HWND, UINT);
LONG DoMainCtlEdit (HWND, UINT, HWND, UINT);
LONG DoMainCtlConfig (HWND, UINT, HWND, UINT);
LONG DoMainCtlAbout (HWND, UINT, HWND, UINT);
LONG DoMainCtlExit (HWND, UINT, HWND, UINT);

void SavetoINI (void);
void SetButtons (HWND);
void FillLB (HWND);

//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"

#define     PRO_LST       "Array"
#define     PRO_CNT       "ArrayCnt"
#define     PRO_FLAGS     "Flags"
#define     PRO_MENU      "Menu"
#define     PRO_CMD       "Cmd"
#define     PRO_DIR       "Dir"
//
// Resource Idendifiers
//
#define     IDD_PROGLIST   100
#define     IDD_ADD        101
#define     IDD_DEL        102
#define     IDD_EDIT       103
#define     IDD_CONFIG     104
#define     IDD_ABOUT      105
#define     IDD_EXIT       106

#define     IDD_MENUNAME   201
#define     IDD_CMD        202
#define     IDD_WDIR       203
#define     IDD_ACTIVATE   204
#define     IDD_ICON       205
#define     IDD_ADDBROWSE  206

#define     IDD_LEFT       220
#define     IDD_MID        221
#define     IDD_RIGHT      222
#define     IDD_ALT        223
#define     IDD_CTRL       224
#define     IDD_SHIFT      225

#define     IDD_PROGSTR    300
#define     IDD_FRAME      301
