// 3D_Frame.h 

/****************************************************************************************
*
*  	3DFrame (HDC, int, int, int, int)
*
*	Takes an HDC as an argument + 4 integer dimensions.Final argument is a constant which 
*	determines whether the frame is drawn RAISED, SUNKEN, FLUSHED, or SHADOWED.
*
*****************************************************************************************/
/*------- P R O T O T Y P E ------------------------------------------------------------*/

void ThreeDFrame (HDC, int, int, int, int, int); // creates a 3D frame                    

/*------- D E F I N E S ----------------------------------------------------------------*/

#define RAISED 1000
#define SUNKEN 2000
#define FLUSHED 3000
#define SHADOWED 4000
                                                                                          
/*------- F U N C T I O N   D E F I N I T I O N ----------------------------------------*/                                                                                          
void ThreeDFrame (HDC hDC, int nLeft, int nTop, int nRight, int nBottom, int nStyle)
{           
	HPEN hPen;
	
	switch (nStyle)
	{
		case RAISED: // draw a sunken box
		    
		    hPen = CreatePen (PS_SOLID, 1, RGB(80,80,80));
			SelectObject (hDC, hPen);                        
			MoveTo (hDC, nLeft, nBottom);
			LineTo (hDC, nRight, nBottom);
			LineTo (hDC, nRight, nTop);
			SelectObject (hDC, GetStockObject (WHITE_PEN));
			LineTo (hDC, nLeft, nTop);
			LineTo (hDC, nLeft, nBottom);			 
			break;		
		    break;

		case SUNKEN: // draw a raised box 
			
			hPen = CreatePen (PS_SOLID, 1, RGB(80,80,80));
			SelectObject (hDC, hPen);                        
			MoveTo (hDC, nLeft, nBottom);
			LineTo (hDC, nLeft, nTop);
			LineTo (hDC, nRight, nTop);
			SelectObject (hDC, GetStockObject (WHITE_PEN));
			LineTo (hDC, nRight, nBottom);
			LineTo (hDC, nLeft, nBottom);			 
			break;		
			
		
		case FLUSHED: // draw a flushed box  
		
			hPen = CreatePen (PS_SOLID,1,RGB(80,80,80));
			SelectObject (hDC, hPen);
			SelectObject (hDC, GetStockObject(NULL_BRUSH));
			Rectangle (hDC, nLeft, nTop, nRight, nBottom);
			SelectObject (hDC, GetStockObject(WHITE_PEN));
			Rectangle (hDC, ++nLeft, ++nTop, ++nRight, ++nBottom);			
		    break;
		
		case SHADOWED: // draw a white box w/ a black outline and a DKGRAY shadow
		    
		    SelectObject (hDC, GetStockObject (NULL_PEN));
		    SelectObject (hDC, GetStockObject (GRAY_BRUSH));
		    Rectangle (hDC, nLeft + 2, nTop + 2, nRight + 2, nBottom + 2);
		    SelectObject (hDC, GetStockObject (BLACK_PEN));
		    SelectObject (hDC, GetStockObject (WHITE_BRUSH));
		    Rectangle (hDC, nLeft - 2, nTop - 2, nRight - 2, nBottom - 2);
		    break;
		
		default:  
		    break;
	
	}         
	
	DeleteObject (hPen);
	
}                                                                         
