'
'  Copyright (C) 1988-1993 The GAP Development Company
'
'  All Rights Reserved
'
'
'  GAPQBSRC.BI
'
'  Include file for all GAPQBDR source modules
'
'

' Internal functions used by GAPQBDR. May be used by the programmer

DECLARE SUB getlocal(flag%)               ' stores address of l.ocal flag
DECLARE SUB dosprint (a$)                 ' sends a string to display via BIOS
DECLARE SUB gapputs (a$)                  ' sends string to local and remote
DECLARE SUB CLS.ALL ALIAS "CLS_ALL" ()    ' clear all of the screen
DECLARE SUB CLS23 ()                      ' clear 1st 23 lines of screen
DECLARE SUB cursor (flag%)                ' turn cusor on or off
DECLARE SUB set.cursor ALIAS "SET_CURSOR" (position%)  ' positions cursor to row & column
DECLARE SUB set.directory (drive$)        ' sets the default drive and path
DECLARE SUB wrap.word ()                  ' wraps words during sysop chat
DECLARE FUNCTION get.cursor% ALIAS "GET_CURSOR" ()     ' returns cursor position
DECLARE FUNCTION getkeyc% ()              ' ket a key from local console
DECLARE FUNCTION get.directory$ ()        ' get current drive and path

' source code not provided for following functions

DECLARE FUNCTION get.time& ()             ' returns time as long integer
DECLARE FUNCTION getanum& ()              ' used internally by getrand
DECLARE SUB init.rand ()                  ' used internally by init.door


' function declarations for the communications routines

DECLARE FUNCTION init.port% ALIAS "INIT_PORT" (parity%, d.ata%) ' initializes port
DECLARE FUNCTION setport% (port%, baud&, irq%, b.ase%) ' configures the port
DECLARE FUNCTION ckeypress% ()                      ' checks for keypress
DECLARE FUNCTION comgetc% ()                        ' gets a character
DECLARE FUNCTION iscd% ()                           ' checks for carrier
DECLARE FUNCTION isring% ()                         ' checks if phone is ringing
DECLARE FUNCTION rxempty% ()                        ' checks if receive buffer is empty
DECLARE SUB clr.buf ALIAS "CLR_BUF" ()              ' clears receive buffer
DECLARE SUB computc (c%)                            ' sends a character
DECLARE SUB computs (a$)                            ' sends a string
DECLARE SUB dtr (how%)                              ' toggles DTR
DECLARE SUB rts (how%)                              ' toggles RTS

   ' DigiBoard specific routines

DECLARE FUNCTION dsetup% (b.ase%, port%, chnl%, baud&, parity%, d.ata%, s.top%)

   ' used to setup Direct DigiBoard Programming support
   ' RESETDIG.EXE must have already been run in the AUTOEXEC.BAT or this
   ' function will fail

   ' base   = Memory Window
   ' port   = I/O Port
   ' chnl   = DigiBoard Channel # (1 - 8)
   ' baud   = baudrate (long)
   ' parity = 0 = None, 1 = Odd, 2 = Even
   ' data   = 6, 7, or 8
   ' stop   = 1 or 2

   ' Return 0 = success
   '        1 = no board
   '        2 = Can't talk to board
   '        3 = Invalid Parameter
   '        4 = EPROM too old


DECLARE FUNCTION int14set% (chnl%, baud&, parity%, d.ata%, s.top%)

   ' used to setup DigiBoard via INT14/EBIOS Device Driver
   ' The Device Driver must be installed and configured for EBIOS Support
   ' or this function will fail

   ' chnl   = DigiBoard Channel # (usually 4 - 11)
   ' baud   = baudrate (long)
   ' parity = 0 = None, 1 = Odd, 2 = Even
   ' data   = 6, 7, or 8
   ' stop   = 1 or 2

   ' Return 0 = success
   '        1 = Device Driver Not installed or board not installed
   '        2 = EBIOS not configured
   '        3 = Invalid Parameter

   ' all other Digi Functions work with either Direct Programming or
   ' Int14/EBIOS


DECLARE SUB drestore ()

   ' Resets The Modem attached to the DigiBoard
   ' don't call if you want DTR to stay up


   ' Fossil specific routines

DECLARE FUNCTION fos.setport% ALIAS "FOS_SETPORT" (port%)

   ' Used to tell Fossil driver we want to use the specified Port

   ' MUST BE CALLED prior to using any Communications routine (if using
   ' the Fossil Interface).

   ' port = COM Port # (0 based, COM 1 = 0, COM 2 = 1, etc)

   ' Return 0 = success
   '        1 = Device Driver Not installed


DECLARE SUB fos.resetport ALIAS "FOS_RESETPORT" ()

   ' Tells the Fossil Driver we are finished with the port.


DECLARE FUNCTION fos.initport% ALIAS "FOS_INITPORT" (baud&, parity%, d.ata%, s.top%)

   ' Initializes the Fossil port 

   ' baud   = baudrate (long)
   ' parity = 0 = None, 1 = Odd, 2 = Even
   ' data   = 6, 7, or 8
   ' stop   = 1 or 2

   ' Return 0 = success
   '        1 = bad parameter passed


DECLARE SUB fos.clrtx ALIAS "FOS_CLRTX" ()
   
   ' Clears the Fossil port's Transmit Buffer



   '***********************************************************************
   '*  private GAPQBDR variables                                          *
   '*                                                                     *
   '*  these variables may be used in your source modules                 *
   '***********************************************************************

   COMMON SHARED /GAPQBDR/ parity        AS INTEGER  ' actually data and not used
   COMMON SHARED /GAPQBDR/ numbells      AS INTEGER  ' used in time.left function
   COMMON SHARED /GAPQBDR/ usemore1      AS INTEGER  ' true if showing a file
   COMMON SHARED /GAPQBDR/ redisplay     AS INTEGER  ' true if wants to start over
   COMMON SHARED /GAPQBDR/ endview       AS INTEGER  ' true if dont want to see any more
   COMMON SHARED /GAPQBDR/ NS            AS INTEGER  ' true if in Continuous Mode
   COMMON SHARED /GAPQBDR/ clockon       AS INTEGER  ' 0 = no clock, 1 = display clock
   COMMON SHARED /GAPQBDR/ chat          AS INTEGER  ' true if chatting with user

   COMMON SHARED /GAPQBDR/ recnum        AS LONG     ' user's record number
   COMMON SHARED /GAPQBDR/ temptime      AS LONG     ' for calculating time out

   COMMON SHARED /GAPQBDR/ anystring1    AS STRING   ' global garbage collector
   COMMON SHARED /GAPQBDR/ five.left     AS STRING   ' five minutes left
   COMMON SHARED /GAPQBDR/ ANSI.CLS      AS STRING   ' ansi clear screen
   COMMON SHARED /GAPQBDR/ strtime       AS STRING   ' holds the time string
   COMMON SHARED /GAPQBDR/ curtime       AS STRING   ' holds the current time as a string
   COMMON SHARED /GAPQBDR/ expired.time  AS STRING   ' out of time

