
/*************************************************************************
**************************************************************************

   Listing 6
   Copyright David Perelman-Hall 1994.
   Main function to test and demonstrate building and unifying of DAGs.

**************************************************************************
*************************************************************************/



#include "misc.h"
#pragma hdrstop

int main(void)
{
   // CHANGE THE VALUES FOR "NUMBER" TO MATCH (AND THE ASSOCIATED
   // TEXT STRINGS IF YOU WANT) TO GET THE UNIFICATION BELOW TO SUCCEED.

   // TOP-LEVEL DAG FOR THE NOUN PHRASE
   Dag NP_COW;
   NP_COW.add(Feature("CASE"),AtomicValue("NOMINATIVE"));
   NP_COW.add(Feature("NP_CAT"),AtomicValue("NP"));
   NP_COW.add(Feature("NP_STRING"),AtomicValue("THE COWS"));

   // SUB-DAG FOR THE NOUN PHRASE VALUES ASSOCIATED WITH AGREEMENT
   Dag NnInner;
   NnInner.add(Feature("NUMBER"),AtomicValue("PLURAL")); // mismatch with Verb
   NnInner.add(Feature("ANIMACY"),AtomicValue("ANIMATE"));

   // ADD SUB-DAG TO TOP-LEVEL NOUN PHRASE DAG
   NP_COW.add(Feature("AGREEMENT"),DagValue(NnInner));

   // TOP-LEVEL DAG FOR THE VERB PHRASE
   Dag VP_EATS;
   VP_EATS.add(Feature("SUBCAT"),AtomicValue("INTRANSITIVE"));
   VP_EATS.add(Feature("VP_CAT"),AtomicValue("VP"));
   VP_EATS.add(Feature("VP_STRING"),AtomicValue("EATS GRASS"));

   // SUB-DAG FOR THE VERB PHRASE VALUES ASSOCIATED WITH AGREEMENT
   Dag VbInner;
   VbInner.add(Feature("NUMBER"),AtomicValue("SINGULAR")); // mismatch w/ Noun
   VbInner.add(Feature("ANIMACY"),AtomicValue("ANIMATE"));

   // OR CHANGE COMMENTS BELOW TO TEST UNIFICATION WITH VARIABLE OR DAG:
   // COMMENT THE SECOND ADDITION BELOW OF AGREEMENT 
   // AS A DagValue, AND UNCOMMENT THE ADDITION AS VariableValue (or vice versa)
   // VP_EATS.add(Feature("AGREEMENT"),VariableValue("VAR_VALUE"));

   // ADD SUB-DAG TO TOP-LEVEL VERB PHRASE DAG
   VP_EATS.add(Feature("AGREEMENT"),DagValue(VbInner));

   cout << "NP =\n" << NP_COW << endl << endl;
   cout << "VP =\n" << VP_EATS << endl << endl;
   cout << "NnInner =\n" << NnInner << endl << endl;
   cout << "VbInner =\n" << VbInner << endl << endl;

   Dag Sentence;
   SubstitutionList subst;
   if( unify(NP_COW,VP_EATS,subst,Sentence) ) {
      cout << "\n *** SUCCESS! ***\n\n";
      cout << "Unified NP and VP =\n" << Sentence << endl;
   }
   else {
      cout << "\n *** FAILURE! ***\n\n";
   }
   return 0;
}
