#ifndef TEMPLATE_SET_H
#define TEMPLATE_SET_H

#include "dpharray.h"


//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//     SET TEMPLATE--DERIVED FROM ARRAY TEMPLATE
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
template<class T> class SetOf : public ArrayOf<T> {
   public:
      SetOf(): ArrayOf<T>(), set_idx(0) {}
      SetOf(const T* arr, int size);
      SetOf(const SetOf<T>& set) : ArrayOf<T>(set), set_idx(set.set_idx) {}
      void operator=(const SetOf<T>& set){
			ArrayOf<T>::operator=(set);
			set_idx=set.set_idx;
		}
      int operator==(const SetOf<T>& set) const;
      void operator+=(const T& item);
      void operator+=(const SetOf<T>& set);
      SetOf<T>& operator+(const T& item) { *this+=item; return *this; }
      SetOf<T>& operator+(const SetOf<T>& set) { *this+=set; return *this; }
      void operator-=(const T& item);
      void operator-=(const SetOf<T>& set);
      SetOf<T>& operator-(const T& item) { *this-=item; return *this; }
      SetOf<T>& operator-(const SetOf<T>& set) { *this-=set; return *this; }
      int size() const { return set_idx; }
      int contains(const T& item) const;
      ~SetOf() { clear(); }
      virtual void clear() {
         ArrayOf<T>::clear();
         set_idx=0;
      }
      friend ostream& operator << (ostream& os, const SetOf<T>& set);
   private:
      int set_idx;
};

template<class T>
ostream& operator<<(ostream& os, const SetOf<T>& set)
{
   for(int i=0; i<set.size(); i++) os << set[i] << ' ';
   return os;
}

template<class T>
int SetOf<T>::contains(const T& item) const
{
   for(int i=0; i<set_idx; i++) if(item==ArrayOf<T>::elem(i)) return 1;
   return 0;
}


template<class T>
SetOf<T>::SetOf(const T* arr, int size) : ArrayOf<T>(), set_idx(size)
{
   ArrayOf<T>::resize(size);
   for(int i=0; i<size; ++i)
      if( !ArrayOf<T>::contains(arr[i]) )
         ArrayOf<T>::insert(arr[i], i);
}

template<class T>
void SetOf<T>::operator+=(const T& item)
{
	//  NO DUPLICATES ALLOWED IN A SET
	if(!contains(item)){
   	if(set_idx+1>=ArrayOf<T>::length){
      	resize(ArrayOf<T>::length+10);
   	}
   	ArrayOf<T>::arr[set_idx++]=item;
	}
}

template<class T>
void SetOf<T>::operator-=(const T& item)
{
	// ONLY REMOVE ITEMS CONTAINED IN SET
	if(contains(item)){
		// NEW A TEMPORARY SET
	   SetOf<T> *new_set = new SetOf<T>;
		assert(new_set!=0);

		// COPY OVER ALL ITEMS EXCEPT THE ONE BEING SUBTRACTED
		for(int i=0; i<set_idx; i++) if(ArrayOf<T>::arr[i]!=item) {
         *new_set+=ArrayOf<T>::arr[i];
      }

		// MAKE CURRENT SET EQUAL TO THE TEMPORARY SET
		*this=*new_set;

		// DELETE THE TEMPORARY SET
		delete new_set;
	}
}

template<class T>
int SetOf<T>::operator==(const SetOf<T>& set) const
{
	for(int i=0; i<set.size(); i++){
		T item = set.elem(i);
		if(!contains(item)) return 0;
	}
	return 1;
}

template<class T>
void SetOf<T>::operator+=(const SetOf<T>& set)
{
   for(int i=0; i<set.size(); i++) *this+=set.elem(i);
}

template<class T>
void SetOf<T>::operator-=(const SetOf<T>& set)
{
   for(int i=0; i<set.set_idx; i++) *this-=set.elem(i);
}

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//     SET ITERATOR TEMPLATE
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------

template<class T> class SetOfIter : public SetOf<T> {
   public:
      SetOfIter() : Ptr(0), pos(0), ptr(0) {}
      SetOfIter(const SetOf<T>* p) : Ptr(p), pos(0) { ptr=&pos;
         if(Ptr->size()==0) ptr=0;
      }
      void operator=(const SetOfIter<T>& iter) {
         Ptr=iter.Ptr;
         pos=iter.pos;
         ptr=iter.ptr;
      }
      void rewind() {
         assert(Ptr!=0);
         ptr=&pos;
         pos=0;
      }
      void goEnd() {
         assert(Ptr!=0);
         ptr=&pos;
         pos=Ptr->size()-1;
      }
      int offEnd() const {
         if(pos<0 || pos>=Ptr->size()) return 1;
         return 0;
      }
      T& first() {return Ptr->elem(0);}
      T& last() { return Ptr->elem(Ptr->size()-1); }
      operator void* () { return ptr; }
      T& operator()() {
         assert(!offEnd());
         assert(ptr!=0);
         return Ptr->elem(pos);
      }
      void operator++() { pos++; if(offEnd()) ptr=0;}
      void operator--() { pos--; if(offEnd()) ptr=0;}
   private:
      const SetOf<T> *Ptr;
      int *ptr;
      int pos;
};

#endif // TEMPLATE_SET_H
