

/*************************************************************************
**************************************************************************

   Listing 4
   Copyright David Perelman-Hall & Jamshid Afshar 1994.
   DagValue class

**************************************************************************
*************************************************************************/

#ifndef DAG_H
#define DAG_H

#include "misc.h"
#include "value.h"
#include "atomic.h"
#include "variable.h"


typedef MapOf<Feature, ValuePtr> FVList;
typedef MapOfIter<Feature, ValuePtr> FVListIter;

class Dag {
public:
   // CONSTRUCTOR
   Dag():_datap(new Data){}

   // COPY CONSTRUCTOR 
   Dag(const Dag& dag): _datap(dag._datap){}

   // DESTRUCTOR
   ~Dag(){}

   // ASSIGNMENT OPERATOR
   void operator=(const Dag& dag){_datap=dag._datap;}

   // ADD A FEATURE-VALUE PAIR TO THIS DAG
   void add(const Feature& f, const ValuePtr& vp){own_fvlist().enter(f,vp);}

   // EQUALITY OPERATORS
   bool operator==(const Dag& dag) const;
   bool operator!=(const Dag& dag) const {return !operator==(dag);}

   // CLEAR DATA FROM THIS DAG
   void clear(void){own_fvlist().clear();}

   // TEST FOR EXISTENCE OF FEATURE IN THIS DAG
   bool contains(const Feature& feature) const {
      return fvlist().contains(feature);
   }

   // RETRIEVE VALUE ASSOCIATED WITH FEATURE 
   ValuePtr value(const Feature& feature) const {
      if(!fvlist().contains(feature)){
         cerr << "Dag " << *this << " does not have feature " << feature
         << endl;
      }
      assert(fvlist().contains(feature));
      return fvlist().valueOf(feature);
   }

   // RETRIEVE THE LIST OF FEATURES OF THIS DAG
   FeatureSet list_features() const;

   // SET SUBSTITUTION FOR VARIABLES 
   Dag substitute(const SubstitutionList& substList) const;

   // APPLY SUBSTITUTION
   static Dag apply_substitution(const Dag& dag,
      const SubstitutionList& substList){return dag.substitute(substList);}

   // OUTPUT OPERATOR
   void write(ostream& os, int level) const;

   // IOSTREAM OPERATORS
   friend ostream& operator << ( ostream& os, const Dag& dag );
   //friend istream& operator >> ( istream& is, Dag& dag );

private:
   struct Data {
      FVList fvs;
      Data() {}
      Data(const FVList& map) : fvs(map) {}
   };
   Data *_datap;
   const FVList& fvlist() const {return _datap->fvs;}
   FVList& own_fvlist() {return _datap->fvs;}
};

/*
inline
istream& operator >> ( istream& is, Dag& dag )
{ 
   is >> dag.own_fvlist(); 
   return is;
}
*/

// DECLARATION OF GLOBAL UNIFY WHICH ACTUALLY UNIFIES TWO DAGs
bool unify(const Dag& dag1, const Dag& dag2, SubstitutionList& subst, Dag& result);

// DECLARATION & DEFINITION OF GLOBAL UNIFY TAKING TWO DAG REFERENCES,
// DOES NOT ACTUALLY UNIFY, BUT RETURNS BOOLEAN TEST ON THEIR UNIFICATION
inline
bool unify(const Dag& dag1, const Dag& dag2){
   SubstitutionList subst;
   Dag result;
   return unify(dag1, dag2, subst, result);
}


// MAKE DAG_LIST CLASS
typedef ListOf<Dag> DagList;
typedef ListOfIter<Dag> DagIter;

ostream& operator<<(ostream& os, const ListOf<Dag>& list);


class DagValue : public Value {
private:
   Dag _d;
public:
   //empty constructor
   DagValue(){}

   //copy constructor
   DagValue( const DagValue& value ) : _d(value._d) { }

   DagValue( const Dag& dag ) : _d(dag) { }

   Value* copy() const { return new DagValue(*this); }

   //assignment operator
   void operator = (const DagValue& value) { _d = value._d; }

   virtual bool operator == (const Value& value) const
      { return value==*this; }
   virtual bool operator == (const DagValue& value) const
      { return _d==value._d; }

   virtual bool unify(const Value& value, SubstitutionList& subst, ValuePtr& result) const
      { return value.unify(*this, subst, result); }
   virtual bool unify(const DagValue& value, SubstitutionList& subst, ValuePtr& result) const;

   virtual void write(ostream& os, int level) const;
   //virtual void read(istream& is) { is >> _d; }
   virtual ValuePtr substitute(const SubstitutionList& substList) const;
};

#endif
