

/*************************************************************************
**************************************************************************

   Listing 2
   Copyright David Perelman-Hall & Jamshid Afshar 1994.
   AtomicValue class

**************************************************************************
*************************************************************************/

#ifndef ATOMIC_H
#define ATOMIC_H

#include <cstring.h>    // BORLAND HEADER
#include "value.h"      // BASE VALUE & VALUEPTR CLASSES

typedef string String;
#define Atomic String

class AtomicValue : public Value, public Atomic {
   public:
      //EMPTY CTOR
      AtomicValue(){}

      //COPY CTOR
      AtomicValue( const AtomicValue& value ) : Atomic(value) { }

      //CONSTRUCTOR
      AtomicValue( const String& str ) : Atomic(str) { }

      //CONSTRUCTOR
      AtomicValue( const char* s ) : Atomic(s) { }

      //RETURN POINTER TO NEW ATOMIC VALUE COPY CONSTRUCTED FROM THIS
      Value* copy() const { return new AtomicValue(*this); }

      // EXPLICIT STRING CONVERSION
      const String& str() const { return (const Atomic&)*this; }

      //ASSIGNMENT OPERATOR
      void operator = (const AtomicValue& value) { Atomic::operator=(value); }

      //EQUALITY
      virtual bool operator == (const Value& value) const;
      virtual bool operator == (const AtomicValue& value) const;

      // UNIFY
      virtual bool unify(const Value& value, SubstitutionList& subst, ValuePtr& result) const;
      virtual bool unify(const AtomicValue& value, SubstitutionList& /*subst*/, ValuePtr& result) const;

      // OUTPUT
      virtual void write(ostream& os, int level) const { os << (const Atomic&)*this; }

      // SUBSTITUTE
      virtual ValuePtr substitute(const SubstitutionList& /*substList*/) const
         {  return *this; }

};


#endif
