#if !defined(__tppmdicl_h)              // Sentry, use file only if it's not already included.
#define __tppmdicl_h

/*  Project popclnt
    
    SUBSYSTEM:    popclnt.exe Application
    FILE:         tppmdicl.hpp
    AUTHOR:       Robert A. Duffy


    OVERVIEW
    ========
    Class definition for TPopMDIClient (TMDIClient).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "ppclntap.rh"            // Definition of all resources.

#include "socket.hpp"

//{{TMDIClient = TPopMDIClient}}
class TPopMDIClient : public TMDIClient, public TPOPSocketCatch
{
public:
    int                     ChildCount;                 // Number of child window created. 

    TPopMDIClient(TModule* module = 0);
    virtual ~TPopMDIClient ();

    void OpenFile (const char *fileName = 0);

    // Socket catch overrides
    virtual void WinSocketError(int nErr, const char* pErrText);
    virtual void MessageCount(int nCount);
    virtual void MessageRetrieved(int nMessageID, const char* pFilename);
private:
    void LoadTextFile ();

//{{TPopMDIClientVIRTUAL_BEGIN}}
protected:
  TAsyncPOPSocket* pPOPSocket;
  int nPendingMessageCount;
    virtual void SetupWindow ();
//{{TPopMDIClientVIRTUAL_END}}

//{{TPopMDIClientRSP_TBL_BEGIN}}
protected:
    void CmFileNew ();
	  void CmFileOpen ();
    void CmMailRetrieve();
//{{TPopMDIClientRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TPopMDIClient);
};    //{{TPopMDIClient}}


#endif                                      // __tppmdicl_h sentry.
